/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MetaDataNumItemsByEachReducer;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.sort.ReadWithZeros;

public class PickFromCompactInputFormat
extends FileInputFormat<MatrixIndexes, MatrixCell> {
    public static final String VALUE_IS_WEIGHT = "value.is.weight";
    public static final String INPUT_IS_VECTOR = "input.is.vector";
    public static final String SELECTED_RANGES = "selected.ranges";
    public static final String SELECTED_POINTS_PREFIX = "selected.points.in.";
    public static final String VALUE_CLASS = "value.class.to.read";
    public static final String PARTITION_OF_ZERO = "partition.of.zero";
    public static final String NUMBER_OF_ZERO = "number.of.zero";

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    public static void setZeroValues(JobConf job, MetaDataNumItemsByEachReducer metadata) {
        job.setInt(PARTITION_OF_ZERO, metadata.getPartitionOfZero());
        job.setLong(NUMBER_OF_ZERO, metadata.getNumberOfZero());
    }

    public static void setKeyValueClasses(JobConf job, Class<? extends WritableComparable> keyClass, Class<? extends Writable> valueClass) {
        job.setClass(VALUE_CLASS, valueClass, Writable.class);
    }

    private static void getPointsInEachPartFile(long[] counts, double[] probs, HashMap<Integer, ArrayList<Pair<Integer, Integer>>> posMap) {
        long[] ranges = new long[counts.length];
        ranges[0] = counts[0];
        for (int i = 1; i < counts.length; ++i) {
            ranges[i] = ranges[i - 1] + counts[i];
        }
        long total = ranges[ranges.length - 1];
        Object[] sortedProbs = new SortElement[probs.length];
        for (int i = 0; i < sortedProbs.length; ++i) {
            sortedProbs[i] = new SortElement(probs[i], i + 1);
        }
        Arrays.sort(sortedProbs);
        int currentPart = 0;
        for (Object e : sortedProbs) {
            long pos = (long)Math.ceil((double)total * ((SortElement)e).prob);
            while (ranges[currentPart] < pos) {
                ++currentPart;
            }
            ArrayList<Pair<Integer, Integer>> vec = posMap.get(currentPart);
            if (vec == null) {
                vec = new ArrayList();
                posMap.put(currentPart, vec);
            }
            if (currentPart > 0) {
                vec.add(new Pair<Integer, Integer>((int)(pos - ranges[currentPart - 1] - 1L), ((SortElement)e).index));
                continue;
            }
            vec.add(new Pair<Integer, Integer>((int)pos - 1, ((SortElement)e).index));
        }
    }

    public static Set<Integer> setPickRecordsInEachPartFile(JobConf job, MetaDataNumItemsByEachReducer metadata, double[] probs) {
        HashMap<Integer, ArrayList<Pair<Integer, Integer>>> posMap = new HashMap<Integer, ArrayList<Pair<Integer, Integer>>>();
        PickFromCompactInputFormat.getPointsInEachPartFile(metadata.getNumItemsArray(), probs, posMap);
        for (Map.Entry<Integer, ArrayList<Pair<Integer, Integer>>> e : posMap.entrySet()) {
            job.set(SELECTED_POINTS_PREFIX + e.getKey(), PickFromCompactInputFormat.getString(e.getValue()));
        }
        job.setBoolean(INPUT_IS_VECTOR, true);
        return posMap.keySet();
    }

    public static void setRangePickPartFiles(JobConf job, MetaDataNumItemsByEachReducer metadata, double lbound, double ubound) {
        if (lbound < 0.0 || lbound > 1.0 || ubound < 0.0 || ubound > 1.0 || lbound >= ubound) {
            throw new RuntimeException("Invalid ranges for range pick: [" + lbound + "," + ubound + "]");
        }
        long[] counts = metadata.getNumItemsArray();
        long[] ranges = new long[counts.length];
        ranges[0] = counts[0];
        for (int i = 1; i < counts.length; ++i) {
            ranges[i] = ranges[i - 1] + counts[i];
        }
        long sumwt = ranges[ranges.length - 1];
        double qbegin = lbound * (double)sumwt;
        double qend = ubound * (double)sumwt;
        int partID = -1;
        long wt = 0L;
        while ((double)wt < qbegin) {
            wt += counts[++partID];
        }
        StringBuilder sb = new StringBuilder();
        while ((double)wt <= qend) {
            sb.append(partID + "," + (wt - counts[partID]) + ";");
            if (++partID >= counts.length) continue;
            wt += counts[partID];
        }
        sb.append(partID + "," + (wt - counts[partID]) + ";");
        sb.append(sumwt + "," + lbound + "," + ubound);
        job.set(SELECTED_RANGES, sb.toString());
        job.setBoolean(INPUT_IS_VECTOR, false);
    }

    private static String getString(ArrayList<Pair<Integer, Integer>> value) {
        StringBuilder sb = new StringBuilder();
        for (Pair<Integer, Integer> i : value) {
            sb.append(i.getKey());
            sb.append(":");
            sb.append(i.getValue());
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public RecordReader<MatrixIndexes, MatrixCell> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (job.getBoolean(INPUT_IS_VECTOR, true)) {
            return new PickRecordReader(job, (FileSplit)split);
        }
        return new RangePickRecordReader(job, (FileSplit)split);
    }

    public static class PickRecordReader
    implements RecordReader<MatrixIndexes, MatrixCell> {
        private boolean valueIsWeight = true;
        private FileSystem fs;
        private Path path;
        private FSDataInputStream currentStream;
        private int posIndex = 0;
        private int[] pos = null;
        private int[] indexes = null;
        private DoubleWritable readKey = new DoubleWritable();
        private IntWritable readValue = new IntWritable();
        private int numRead = 0;
        private boolean noRecordsNeeded = false;
        ReadWithZeros reader = null;

        private static int getIndexInTheArray(String name) {
            return Integer.parseInt(name.substring(name.indexOf("part-") + 5));
        }

        public PickRecordReader(JobConf job, FileSplit split) throws IOException {
            this.path = split.getPath();
            this.fs = IOUtilFunctions.getFileSystem(this.path, (Configuration)job);
            this.currentStream = this.fs.open(this.path);
            int partIndex = PickRecordReader.getIndexInTheArray(this.path.getName());
            String arrStr = job.get(PickFromCompactInputFormat.SELECTED_POINTS_PREFIX + partIndex);
            if (arrStr == null || arrStr.isEmpty()) {
                this.noRecordsNeeded = true;
                return;
            }
            String[] strs = arrStr.split(",");
            this.pos = new int[strs.length];
            this.indexes = new int[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                String[] temp = strs[i].split(":");
                this.pos[i] = Integer.parseInt(temp[0]);
                this.indexes[i] = Integer.parseInt(temp[1]);
            }
            this.valueIsWeight = job.getBoolean(PickFromCompactInputFormat.VALUE_IS_WEIGHT, true);
            int part0 = job.getInt(PickFromCompactInputFormat.PARTITION_OF_ZERO, -1);
            boolean contain0s = false;
            long numZeros = 0L;
            if (part0 == partIndex) {
                contain0s = true;
                numZeros = job.getLong(PickFromCompactInputFormat.NUMBER_OF_ZERO, 0L);
            }
            this.reader = new ReadWithZeros(this.currentStream, contain0s, numZeros);
        }

        public boolean next(MatrixIndexes key, MatrixCell value) throws IOException {
            if (this.noRecordsNeeded || this.posIndex >= this.pos.length) {
                return false;
            }
            while (this.numRead <= this.pos[this.posIndex]) {
                this.reader.readNextKeyValuePairs(this.readKey, this.readValue);
                if (this.valueIsWeight) {
                    this.numRead += this.readValue.get();
                    continue;
                }
                ++this.numRead;
            }
            key.setIndexes(this.indexes[this.posIndex], 1L);
            value.setValue(this.readKey.get());
            ++this.posIndex;
            return true;
        }

        public void close() throws IOException {
            IOUtilFunctions.closeSilently((Closeable)this.currentStream);
        }

        public MatrixIndexes createKey() {
            return new MatrixIndexes();
        }

        public MatrixCell createValue() {
            return new MatrixCell();
        }

        public long getPos() throws IOException {
            long currentOffset = this.currentStream == null ? 0L : this.currentStream.getPos();
            return currentOffset;
        }

        public float getProgress() throws IOException {
            if (this.pos != null) {
                return (float)this.posIndex / (float)this.pos.length;
            }
            return 100.0f;
        }
    }

    public static class RangePickRecordReader
    implements RecordReader<MatrixIndexes, MatrixCell> {
        private Path path;
        private FSDataInputStream currentStream;
        protected long totLength;
        private DoubleWritable readKey = new DoubleWritable();
        private IntWritable readValue = new IntWritable(0);
        private boolean noRecordsNeeded = false;
        private int index = 0;
        private int beginPart = -1;
        private int endPart = -1;
        private int currPart = -1;
        private double sumwt = 0.0;
        private double readWt;
        private double lbound;
        private double ubound;
        private HashMap<Integer, Double> partWeights = null;
        private boolean isFirstRecord = true;
        private ReadWithZeros reader = null;

        public RangePickRecordReader(JobConf job, FileSplit split) throws IOException {
            this.parseSelectedRangeString(job.get(PickFromCompactInputFormat.SELECTED_RANGES));
            this.path = split.getPath();
            this.totLength = split.getLength();
            this.currentStream = IOUtilFunctions.getFileSystem(this.path, (Configuration)job).open(this.path);
            this.currPart = RangePickRecordReader.getIndexInTheArray(this.path.getName());
            if (this.currPart < this.beginPart || this.currPart > this.endPart) {
                this.noRecordsNeeded = true;
                return;
            }
            int part0 = job.getInt(PickFromCompactInputFormat.PARTITION_OF_ZERO, -1);
            boolean contain0s = false;
            long numZeros = 0L;
            if (part0 == this.currPart) {
                contain0s = true;
                numZeros = job.getLong(PickFromCompactInputFormat.NUMBER_OF_ZERO, 0L);
            }
            this.reader = new ReadWithZeros(this.currentStream, contain0s, numZeros);
        }

        private static int getIndexInTheArray(String name) {
            return Integer.parseInt(name.substring(name.indexOf("part-") + 5));
        }

        private void parseSelectedRangeString(String str) {
            String[] f1 = str.split(";");
            String[] f2 = null;
            this.partWeights = new HashMap();
            for (int i = 0; i < f1.length - 1; ++i) {
                f2 = f1[i].split(",");
                if (i == 0) {
                    this.beginPart = Integer.parseInt(f2[0]);
                }
                if (i == f1.length - 2) {
                    this.endPart = Integer.parseInt(f2[0]);
                }
                this.partWeights.put(i, Double.parseDouble(f2[1]));
            }
            f2 = f1[f1.length - 1].split(",");
            this.sumwt = Double.parseDouble(f2[0]);
            this.lbound = Double.parseDouble(f2[1]);
            this.ubound = Double.parseDouble(f2[2]);
        }

        public boolean next(MatrixIndexes key, MatrixCell value) throws IOException {
            if (this.noRecordsNeeded) {
                return false;
            }
            double qLowerD = this.sumwt * this.lbound;
            double qUpperD = this.sumwt * this.ubound;
            if (this.isFirstRecord) {
                if (!this.partWeights.containsKey(this.currPart)) {
                    return false;
                }
                this.readWt = this.partWeights.get(this.currPart);
                this.isFirstRecord = false;
            }
            double tmpWt = 0.0;
            if (this.currPart == this.beginPart || this.currPart == this.endPart) {
                boolean ret = this.reader.readNextKeyValuePairs(this.readKey, this.readValue);
                tmpWt = this.readValue.get();
                while (this.readWt + tmpWt < qLowerD) {
                    this.readWt += tmpWt;
                    ret &= this.reader.readNextKeyValuePairs(this.readKey, this.readValue);
                    tmpWt = this.readValue.get();
                }
                if (this.readWt < qLowerD && this.readWt + tmpWt >= qLowerD || this.readWt + tmpWt <= qUpperD || this.readWt < qUpperD && this.readWt + tmpWt >= qUpperD) {
                    key.setIndexes(++this.index, 1L);
                    value.setValue(this.readKey.get() * tmpWt);
                    this.readWt += tmpWt;
                    return ret;
                }
                return false;
            }
            boolean ret = this.reader.readNextKeyValuePairs(this.readKey, this.readValue);
            tmpWt = this.readValue.get();
            key.setIndexes(++this.index, 1L);
            value.setValue(this.readKey.get() * tmpWt);
            this.readWt += tmpWt;
            return ret;
        }

        public void close() throws IOException {
            IOUtilFunctions.closeSilently((Closeable)this.currentStream);
        }

        public MatrixIndexes createKey() {
            return new MatrixIndexes();
        }

        public MatrixCell createValue() {
            return new MatrixCell();
        }

        public long getPos() throws IOException {
            long currentOffset = this.currentStream == null ? 0L : this.currentStream.getPos();
            return currentOffset;
        }

        public float getProgress() throws IOException {
            float progress = (float)this.getPos() / (float)this.totLength;
            return progress >= 0.0f && progress <= 1.0f ? progress : 1.0f;
        }
    }

    private static class SortElement
    implements Comparable<SortElement> {
        double prob;
        int index;

        public SortElement(double p, int i) {
            this.prob = p;
            this.index = i;
        }

        @Override
        public int compareTo(SortElement other) {
            return Double.compare(this.prob, other.prob);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SortElement)) {
                return false;
            }
            SortElement that = (SortElement)o;
            return this.prob == that.prob;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode() should never be called on instances of this class.");
        }
    }
}

