/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.propagation;

import java.util.stream.Stream;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacy;
import org.apache.sysds.runtime.privacy.propagation.OperatorType;
import org.apache.sysds.runtime.privacy.propagation.Propagator;

public abstract class MatrixMultiplicationPropagator
implements Propagator {
    MatrixBlock input1;
    MatrixBlock input2;
    PrivacyConstraint privacyConstraint1;
    PrivacyConstraint privacyConstraint2;

    public MatrixMultiplicationPropagator() {
    }

    public MatrixMultiplicationPropagator(MatrixBlock input1, PrivacyConstraint privacyConstraint1, MatrixBlock input2, PrivacyConstraint privacyConstraint2) {
        this.setFields(input1, privacyConstraint1, input2, privacyConstraint2);
    }

    public void setFields(MatrixBlock input1, PrivacyConstraint privacyConstraint1, MatrixBlock input2, PrivacyConstraint privacyConstraint2) {
        this.input1 = input1;
        this.privacyConstraint1 = privacyConstraint1;
        this.input2 = input2;
        this.privacyConstraint2 = privacyConstraint2;
    }

    @Override
    public PrivacyConstraint propagate() {
        if (this.privacyConstraint1 != null && this.privacyConstraint1.getPrivacyLevel() == PrivacyConstraint.PrivacyLevel.Private || this.privacyConstraint2 != null && this.privacyConstraint2.getPrivacyLevel() == PrivacyConstraint.PrivacyLevel.Private) {
            return new PrivacyConstraint(PrivacyConstraint.PrivacyLevel.Private);
        }
        int r1 = this.input1.getNumRows();
        int c1 = this.input1.getNumColumns();
        int r2 = this.input2.getNumRows();
        int c2 = this.input2.getNumColumns();
        PrivacyConstraint mergedConstraint = new PrivacyConstraint();
        FineGrainedPrivacy mergedFineGrainedConstraints = mergedConstraint.getFineGrainedPrivacy();
        PrivacyConstraint.PrivacyLevel[] rowPrivacy = this.privacyConstraint1 != null && this.privacyConstraint1.getFineGrainedPrivacy() != null ? this.privacyConstraint1.getFineGrainedPrivacy().getRowPrivacy(r1, c1) : (PrivacyConstraint.PrivacyLevel[])Stream.generate(() -> PrivacyConstraint.PrivacyLevel.None).limit(r1).toArray(PrivacyConstraint.PrivacyLevel[]::new);
        PrivacyConstraint.PrivacyLevel[] colPrivacy = this.privacyConstraint2 != null && this.privacyConstraint2.getFineGrainedPrivacy() != null ? this.privacyConstraint2.getFineGrainedPrivacy().getColPrivacy(r2, c2) : (PrivacyConstraint.PrivacyLevel[])Stream.generate(() -> PrivacyConstraint.PrivacyLevel.None).limit(c2).toArray(PrivacyConstraint.PrivacyLevel[]::new);
        OperatorType[] operatorTypes1 = this.getOperatorTypesRow();
        OperatorType[] operatorTypes2 = this.getOperatorTypesCol();
        this.generateFineGrainedConstraints(mergedFineGrainedConstraints, rowPrivacy, colPrivacy, operatorTypes1, operatorTypes2);
        return mergedConstraint;
    }

    public OperatorType[] getOperatorTypesRow() {
        OperatorType[] operatorTypes = new OperatorType[this.input1.getNumRows()];
        for (int i = 0; i < this.input1.getNumRows(); ++i) {
            MatrixBlock rowSlice = this.input1.slice(i, i);
            operatorTypes[i] = this.getOperatorType(rowSlice);
        }
        return operatorTypes;
    }

    public OperatorType[] getOperatorTypesCol() {
        OperatorType[] operatorTypes = new OperatorType[this.input2.getNumColumns()];
        for (int j = 0; j < this.input2.getNumColumns(); ++j) {
            MatrixBlock colSlice = this.input2.slice(0, this.input2.getNumRows() - 1, j, j, new MatrixBlock());
            operatorTypes[j] = this.getOperatorType(colSlice);
        }
        return operatorTypes;
    }

    protected OperatorType mergeOperatorType(OperatorType input1, OperatorType input2) {
        if (input1 == OperatorType.NonAggregate || input2 == OperatorType.NonAggregate) {
            return OperatorType.NonAggregate;
        }
        return OperatorType.Aggregate;
    }

    protected OperatorType getOperatorType(MatrixBlock inputSlice) {
        if (inputSlice.getNonZeros() == 1L) {
            return OperatorType.NonAggregate;
        }
        return OperatorType.Aggregate;
    }

    protected abstract void generateFineGrainedConstraints(FineGrainedPrivacy var1, PrivacyConstraint.PrivacyLevel[] var2, PrivacyConstraint.PrivacyLevel[] var3, OperatorType[] var4, OperatorType[] var5);
}

