/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ACLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.DDCSchemeMC;
import org.apache.sysds.runtime.compress.colgroup.scheme.DDCSchemeSC;

public abstract class DDCScheme
extends ACLAScheme {
    protected IDictionary lastDict;

    protected DDCScheme(IColIndex cols) {
        super(cols);
    }

    public static DDCScheme create(ColGroupDDC g) {
        return g.getNumCols() == 1 ? new DDCSchemeSC(g) : new DDCSchemeMC(g);
    }

    public static DDCScheme create(IColIndex cols) {
        return cols.size() == 1 ? new DDCSchemeSC(cols) : new DDCSchemeMC(cols);
    }

    protected abstract Object getMap();

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("\nCols: ");
        sb.append(this.cols);
        sb.append("\nMap:  ");
        sb.append(this.getMap());
        return sb.toString();
    }
}

