/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.instructions.cp.StringObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FileFormatPropertiesHDF5;
import org.apache.sysds.runtime.io.FileFormatPropertiesLIBSVM;
import org.apache.sysds.runtime.io.ListReader;
import org.apache.sysds.runtime.io.ListWriter;
import org.apache.sysds.runtime.io.WriterHDF5;
import org.apache.sysds.runtime.io.WriterMatrixMarket;
import org.apache.sysds.runtime.io.WriterTextCSV;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageTraceable;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaData;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.meta.TensorCharacteristics;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.ProgramConverter;
import org.apache.sysds.utils.Statistics;

public class VariableCPInstruction
extends CPInstruction
implements LineageTraceable {
    private static final IDSequence _uniqueVarID = new IDSequence(true);
    private static final int CREATEVAR_FILE_NAME_VAR_POS = 3;
    private final VariableOperationCode opcode;
    private final List<CPOperand> inputs;
    private final CPOperand output;
    private final MetaData metadata;
    private final MatrixObject.UpdateType _updateType;
    private final boolean _containsPreadPrefix;
    private final String _schema;
    private final int k;
    private final FileFormatProperties _formatProperties;

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, MetaData meta, FileFormatProperties fprops, String schema, MatrixObject.UpdateType utype, String sopcode, String istr, int k) {
        super(CPInstruction.CPType.Variable, sopcode, istr);
        this.opcode = op;
        this.inputs = new ArrayList<CPOperand>();
        this.addInput(in1);
        this.addInput(in2);
        this.addInput(in3);
        this.output = out;
        this.metadata = meta;
        this._formatProperties = fprops;
        this._schema = schema;
        this._updateType = utype;
        this._containsPreadPrefix = in1 != null && in1.getName().contains("pREAD");
        this.k = k;
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, MetaData meta, FileFormatProperties fprops, String schema, MatrixObject.UpdateType utype, String sopcode, String istr) {
        this(op, in1, in2, in3, out, meta, fprops, schema, utype, sopcode, istr, 1);
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String sopcode, String istr) {
        this(op, in1, in2, in3, out, null, null, null, null, sopcode, istr, 1);
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String sopcode, String istr, int k) {
        this(op, in1, in2, in3, out, null, null, null, null, sopcode, istr, k);
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, MetaData md, MatrixObject.UpdateType updateType, String schema, String sopcode, String istr) {
        this(op, in1, in2, in3, null, md, null, schema, updateType, sopcode, istr);
    }

    private VariableCPInstruction(VariableOperationCode op, CPOperand in1, CPOperand in2, CPOperand in3, MetaData md, MatrixObject.UpdateType updateType, FileFormatProperties formatProperties, String schema, String sopcode, String istr) {
        this(op, in1, in2, in3, null, md, formatProperties, schema, updateType, sopcode, istr);
    }

    private static VariableOperationCode getVariableOperationCode(String str) {
        if (str.equalsIgnoreCase("createvar")) {
            return VariableOperationCode.CreateVariable;
        }
        if (str.equalsIgnoreCase("assignvar")) {
            return VariableOperationCode.AssignVariable;
        }
        if (str.equalsIgnoreCase("cpvar")) {
            return VariableOperationCode.CopyVariable;
        }
        if (str.equalsIgnoreCase("mvvar")) {
            return VariableOperationCode.MoveVariable;
        }
        if (str.equalsIgnoreCase("rmvar")) {
            return VariableOperationCode.RemoveVariable;
        }
        if (str.equalsIgnoreCase("rmfilevar")) {
            return VariableOperationCode.RemoveVariableAndFile;
        }
        if (str.equalsIgnoreCase(Types.OpOp1.CAST_AS_SCALAR.toString())) {
            return VariableOperationCode.CastAsScalarVariable;
        }
        if (str.equalsIgnoreCase(Types.OpOp1.CAST_AS_MATRIX.toString())) {
            return VariableOperationCode.CastAsMatrixVariable;
        }
        if (str.equalsIgnoreCase(Types.OpOp1.CAST_AS_FRAME.toString()) || str.equalsIgnoreCase("cast_as_frame")) {
            return VariableOperationCode.CastAsFrameVariable;
        }
        if (str.equalsIgnoreCase(Types.OpOp1.CAST_AS_LIST.toString())) {
            return VariableOperationCode.CastAsListVariable;
        }
        if (str.equalsIgnoreCase(Types.OpOp1.CAST_AS_DOUBLE.toString())) {
            return VariableOperationCode.CastAsDoubleVariable;
        }
        if (str.equalsIgnoreCase(Types.OpOp1.CAST_AS_INT.toString())) {
            return VariableOperationCode.CastAsIntegerVariable;
        }
        if (str.equalsIgnoreCase(Types.OpOp1.CAST_AS_BOOLEAN.toString())) {
            return VariableOperationCode.CastAsBooleanVariable;
        }
        if (str.equalsIgnoreCase("write")) {
            return VariableOperationCode.Write;
        }
        if (str.equalsIgnoreCase("read")) {
            return VariableOperationCode.Read;
        }
        if (str.equalsIgnoreCase("setfilename")) {
            return VariableOperationCode.SetFileName;
        }
        throw new DMLRuntimeException("Invalid function: " + str);
    }

    public boolean isRemoveVariable(String varName) {
        if (this.isRemoveVariable()) {
            for (CPOperand input : this.inputs) {
                if (!input.getName().equalsIgnoreCase(varName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRemoveVariableNoFile() {
        return this.opcode == VariableOperationCode.RemoveVariable;
    }

    public boolean isRemoveVariable() {
        return this.opcode == VariableOperationCode.RemoveVariable || this.opcode == VariableOperationCode.RemoveVariableAndFile;
    }

    public boolean isMoveVariable() {
        return this.opcode == VariableOperationCode.MoveVariable;
    }

    public boolean isAssignVariable() {
        return this.opcode == VariableOperationCode.AssignVariable;
    }

    public boolean isAssignOrCopyVariable() {
        return this.opcode == VariableOperationCode.AssignVariable || this.opcode == VariableOperationCode.CopyVariable;
    }

    public boolean isCreateVariable() {
        return this.opcode == VariableOperationCode.CreateVariable;
    }

    public VariableOperationCode getVariableOpcode() {
        return this.opcode;
    }

    public FileFormatProperties getFormatProperties() {
        return this._formatProperties;
    }

    public List<CPOperand> getInputs() {
        return this.inputs;
    }

    public CPOperand getInput1() {
        return this.getInput(0);
    }

    public CPOperand getInput2() {
        return this.getInput(1);
    }

    public CPOperand getInput3() {
        return this.getInput(2);
    }

    public CPOperand getInput4() {
        return this.getInput(3);
    }

    public CPOperand getInput(int index) {
        if (this.inputs.size() <= index) {
            return null;
        }
        return this.inputs.get(index);
    }

    public void addInput(CPOperand input) {
        if (input != null) {
            this.inputs.add(input);
        }
    }

    public String getOutputVariableName() {
        String ret = null;
        if (this.output != null) {
            ret = this.output.getName();
        }
        return ret;
    }

    public CPOperand getOutput() {
        return this.output;
    }

    private static int getArity(VariableOperationCode op) {
        if (op.isCast()) {
            return 3;
        }
        switch (op) {
            case Write: 
            case SetFileName: {
                return 3;
            }
        }
        return 2;
    }

    public static VariableCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        VariableOperationCode voc = VariableCPInstruction.getVariableOperationCode(opcode);
        if (voc == VariableOperationCode.CreateVariable) {
            if (parts.length < 5) {
                throw new DMLRuntimeException("Invalid number of operands in createvar instruction: " + str);
            }
        } else if (voc == VariableOperationCode.MoveVariable) {
            if (parts.length != 3 && parts.length != 4) {
                throw new DMLRuntimeException("Invalid number of operands in mvvar instruction: " + str);
            }
        } else if (voc == VariableOperationCode.Write) {
            if (parts.length != 6 && parts.length != 7 && parts.length != 9) {
                throw new DMLRuntimeException("Invalid number of operands in write instruction: " + str);
            }
        } else if (voc == VariableOperationCode.CastAsFrameVariable) {
            InstructionUtils.checkNumFields(parts, 3, 4, 5);
        } else {
            try {
                if (voc != VariableOperationCode.RemoveVariable) {
                    InstructionUtils.checkNumFields(parts, VariableCPInstruction.getArity(voc));
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException("Invalid number of fields with operation code: " + voc, e);
            }
        }
        CPOperand in1 = null;
        CPOperand in2 = null;
        CPOperand in3 = null;
        CPOperand in4 = null;
        CPOperand out = null;
        int k = 1;
        switch (voc) {
            case CreateVariable: {
                String schema;
                Types.DataType dt = Types.DataType.valueOf(parts[4]);
                Types.ValueType vt = dt == Types.DataType.MATRIX ? Types.ValueType.FP64 : Types.ValueType.STRING;
                int extSchema = dt == Types.DataType.FRAME && parts.length >= 12 ? 1 : 0;
                in1 = new CPOperand(parts[1], vt, dt);
                in2 = new CPOperand(parts[2], Types.ValueType.STRING, Types.DataType.SCALAR);
                in3 = new CPOperand(parts[3], Types.ValueType.BOOLEAN, Types.DataType.SCALAR);
                String fmt = parts[5];
                if (fmt.equalsIgnoreCase("csv") ? parts.length < 14 + extSchema || parts.length > 16 + extSchema : (fmt.equalsIgnoreCase("libsvm") ? parts.length < 12 + extSchema : (fmt.equalsIgnoreCase("hdf5") ? parts.length < 11 + extSchema : parts.length != 6 && parts.length != 11 + extSchema))) {
                    throw new DMLRuntimeException("Invalid number of operands in createvar instruction: " + str);
                }
                MetaDataFormat iimd = null;
                if (dt == Types.DataType.MATRIX || dt == Types.DataType.FRAME || dt == Types.DataType.LIST) {
                    MatrixCharacteristics mc = new MatrixCharacteristics();
                    if (parts.length != 6) {
                        if (parts.length >= 10) {
                            ((DataCharacteristics)mc).setDimension(Long.parseLong(parts[6]), Long.parseLong(parts[7]));
                            mc.setBlocksize(Integer.parseInt(parts[8]));
                            ((DataCharacteristics)mc).setNonZeros(Long.parseLong(parts[9]));
                        } else {
                            throw new DMLRuntimeException("Invalid number of operands in createvar instruction: " + str);
                        }
                    }
                    iimd = new MetaDataFormat(mc, Types.FileFormat.safeValueOf(fmt));
                } else if (dt == Types.DataType.TENSOR) {
                    TensorCharacteristics tc = new TensorCharacteristics(new long[]{1L, 1L}, 0);
                    if (parts.length != 6) {
                        if (parts.length >= 10) {
                            tc.setDim(0, Long.parseLong(parts[6]));
                            tc.setDim(1, Long.parseLong(parts[7]));
                            tc.setBlocksize(Integer.parseInt(parts[8]));
                        } else {
                            throw new DMLRuntimeException("Invalid number of operands in createvar instruction: " + str);
                        }
                    }
                    iimd = new MetaDataFormat(tc, Types.FileFormat.safeValueOf(fmt));
                }
                MatrixObject.UpdateType updateType = MatrixObject.UpdateType.COPY;
                if (parts.length >= 11) {
                    updateType = MatrixObject.UpdateType.valueOf(parts[10].toUpperCase());
                }
                String string = schema = dt == Types.DataType.FRAME && parts.length >= 12 ? parts[parts.length - 1] : null;
                if (fmt.equalsIgnoreCase("csv")) {
                    FileFormatPropertiesCSV fmtProperties = null;
                    int curPos = 11;
                    if (parts.length == 14 + extSchema) {
                        boolean hasHeader = Boolean.parseBoolean(parts[curPos]);
                        String delim = parts[curPos + 1];
                        boolean sparse = Boolean.parseBoolean(parts[curPos + 2]);
                        fmtProperties = new FileFormatPropertiesCSV(hasHeader, delim, sparse);
                    } else {
                        boolean hasHeader = Boolean.parseBoolean(parts[curPos]);
                        String delim = parts[curPos + 1];
                        boolean fill = Boolean.parseBoolean(parts[curPos + 2]);
                        double fillValue = Double.parseDouble(parts[curPos + 3]);
                        String naStrings = null;
                        if (parts.length == 16 + extSchema) {
                            naStrings = parts[curPos + 4];
                        }
                        fmtProperties = new FileFormatPropertiesCSV(hasHeader, delim, fill, fillValue, naStrings);
                    }
                    return new VariableCPInstruction(VariableOperationCode.CreateVariable, in1, in2, in3, iimd, updateType, fmtProperties, schema, opcode, str);
                }
                if (fmt.equalsIgnoreCase("libsvm")) {
                    FileFormatPropertiesLIBSVM fmtProperties = null;
                    int curPos = 11;
                    if (parts.length == 12 + extSchema) {
                        String delim = parts[curPos];
                        String indexDelim = parts[curPos + 1];
                        fmtProperties = new FileFormatPropertiesLIBSVM(delim, indexDelim);
                    } else {
                        String delim = parts[curPos];
                        String indexDelim = parts[curPos + 1];
                        boolean sparse = Boolean.parseBoolean(parts[curPos + 2]);
                        fmtProperties = new FileFormatPropertiesLIBSVM(delim, indexDelim, sparse);
                    }
                    return new VariableCPInstruction(VariableOperationCode.CreateVariable, in1, in2, in3, iimd, updateType, fmtProperties, schema, opcode, str);
                }
                if (fmt.equalsIgnoreCase("hdf5")) {
                    int curPos = 11;
                    String datasetName = parts[curPos];
                    FileFormatPropertiesHDF5 fmtProperties = new FileFormatPropertiesHDF5(datasetName);
                    return new VariableCPInstruction(VariableOperationCode.CreateVariable, in1, in2, in3, iimd, updateType, fmtProperties, schema, opcode, str);
                }
                return new VariableCPInstruction(VariableOperationCode.CreateVariable, in1, in2, in3, iimd, updateType, schema, opcode, str);
            }
            case AssignVariable: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                break;
            }
            case CopyVariable: {
                boolean withTypes = parts[1].split("\u00b7").length > 2 && parts[2].split("\u00b7").length > 2;
                in1 = withTypes ? new CPOperand(parts[1]) : new CPOperand(parts[1], Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                in2 = withTypes ? new CPOperand(parts[2]) : new CPOperand(parts[2], Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                break;
            }
            case MoveVariable: {
                in1 = new CPOperand(parts[1], Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                in2 = new CPOperand(parts[2], Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                if (parts.length <= 3) break;
                in3 = new CPOperand(parts[3], Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                break;
            }
            case RemoveVariable: {
                VariableCPInstruction rminst = new VariableCPInstruction(VariableCPInstruction.getVariableOperationCode(opcode), null, null, null, out, opcode, str);
                for (int i = 1; i < parts.length; ++i) {
                    rminst.addInput(new CPOperand(parts[i], Types.ValueType.UNKNOWN, Types.DataType.SCALAR));
                }
                return rminst;
            }
            case RemoveVariableAndFile: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                if (in2.getValueType() == Types.ValueType.BOOLEAN) break;
                throw new DMLRuntimeException("Unexpected value type for second argument in: " + str);
            }
            case CastAsFrameVariable: {
                if (parts.length == 5) {
                    in1 = new CPOperand(parts[1]);
                    in2 = new CPOperand(parts[2]);
                    out = new CPOperand(parts[3]);
                    k = Integer.parseInt(parts[4]);
                    break;
                }
            }
            case CastAsScalarVariable: 
            case CastAsMatrixVariable: 
            case CastAsListVariable: 
            case CastAsDoubleVariable: 
            case CastAsIntegerVariable: 
            case CastAsBooleanVariable: {
                in1 = new CPOperand(parts[1]);
                out = new CPOperand(parts[2]);
                k = Integer.parseInt(parts[3]);
                break;
            }
            case Write: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                in3 = new CPOperand(parts[3]);
                FileFormatProperties fprops = null;
                if (in3.getName().equalsIgnoreCase("csv")) {
                    boolean hasHeader = Boolean.parseBoolean(parts[4]);
                    String delim = parts[5];
                    boolean sparse = Boolean.parseBoolean(parts[6]);
                    fprops = new FileFormatPropertiesCSV(hasHeader, delim, sparse);
                    in4 = new CPOperand(parts[7]);
                } else if (in3.getName().equalsIgnoreCase("libsvm")) {
                    String delim = parts[4];
                    String indexDelim = parts[5];
                    boolean sparse = Boolean.parseBoolean(parts[6]);
                    fprops = new FileFormatPropertiesLIBSVM(delim, indexDelim, sparse);
                } else if (in3.getName().equalsIgnoreCase("hdf5")) {
                    String datasetName = parts[4];
                    fprops = new FileFormatPropertiesHDF5(datasetName);
                } else {
                    fprops = new FileFormatProperties();
                    in4 = new CPOperand(parts[5]);
                }
                VariableCPInstruction inst = new VariableCPInstruction(VariableCPInstruction.getVariableOperationCode(opcode), in1, in2, in3, out, null, fprops, null, null, opcode, str);
                inst.addInput(in4);
                return inst;
            }
            case Read: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2]);
                break;
            }
            case SetFileName: {
                in1 = new CPOperand(parts[1]);
                in2 = new CPOperand(parts[2], Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                in3 = new CPOperand(parts[3], Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            }
        }
        return new VariableCPInstruction(VariableCPInstruction.getVariableOperationCode(opcode), in1, in2, in3, out, opcode, str, k);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        switch (this.opcode) {
            case CreateVariable: {
                this.processCreateVariableInstruction(ec);
                break;
            }
            case AssignVariable: {
                ec.setScalarOutput(this.getInput2().getName(), ec.getScalarInput(this.getInput1()));
                break;
            }
            case CopyVariable: {
                this.processCopyInstruction(ec);
                break;
            }
            case MoveVariable: {
                this.processMoveInstruction(ec);
                break;
            }
            case RemoveVariable: {
                for (CPOperand input : this.inputs) {
                    VariableCPInstruction.processRmvarInstruction(ec, input.getName());
                }
                break;
            }
            case RemoveVariableAndFile: {
                this.processRemoveVariableAndFileInstruction(ec);
                break;
            }
            case CastAsScalarVariable: {
                this.processCastAsScalarVariableInstruction(ec);
                break;
            }
            case CastAsMatrixVariable: {
                this.processCastAsMatrixVariableInstruction(ec);
                break;
            }
            case CastAsFrameVariable: {
                this.processCastAsFrameVariableInstruction(ec);
                break;
            }
            case CastAsListVariable: {
                ListObject lobj = ec.getListObject(this.getInput1());
                if (lobj.getLength() != 1 || !(lobj.getData(0) instanceof ListObject)) {
                    ec.setVariable(this.output.getName(), lobj);
                    break;
                }
                ec.setVariable(this.output.getName(), lobj.getData(0));
                break;
            }
            case CastAsDoubleVariable: {
                ScalarObject scalarDoubleInput = ec.getScalarInput(this.getInput1());
                ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.castToDouble(scalarDoubleInput));
                break;
            }
            case CastAsIntegerVariable: {
                ScalarObject scalarLongInput = ec.getScalarInput(this.getInput1());
                ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.castToLong(scalarLongInput));
                break;
            }
            case CastAsBooleanVariable: {
                ScalarObject scalarBooleanInput = ec.getScalarInput(this.getInput1());
                ec.setScalarOutput(this.output.getName(), new BooleanObject(scalarBooleanInput.getBooleanValue()));
                break;
            }
            case Read: {
                this.processReadInstruction(ec);
                break;
            }
            case Write: {
                this.processWriteInstruction(ec);
                break;
            }
            case SetFileName: {
                this.processSetFileNameInstruction(ec);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unknown opcode: " + this.opcode);
            }
        }
    }

    private void processCreateVariableInstruction(ExecutionContext ec) {
        if (ec.containsVariable(this.getInput1())) {
            VariableCPInstruction.processRmvarInstruction(ec, this.getInput1().getName());
        }
        switch (this.getInput1().getDataType()) {
            case MATRIX: {
                String fname = this.createUniqueFilename();
                MatrixObject obj = new MatrixObject(this.getInput1().getValueType(), fname);
                this.setCacheableDataFields(obj);
                obj.setUpdateType(this._updateType);
                obj.setMarkForLinCache(true);
                ec.setVariable(this.getInput1().getName(), obj);
                if (!DMLScript.STATISTICS || !this._updateType.isInPlace()) break;
                Statistics.incrementTotalUIPVar();
                break;
            }
            case TENSOR: {
                String fname = this.createUniqueFilename();
                TensorObject obj = new TensorObject(this.getInput1().getValueType(), fname);
                this.setCacheableDataFields(obj);
                ec.setVariable(this.getInput1().getName(), obj);
                break;
            }
            case FRAME: {
                String fname = this.createUniqueFilename();
                FrameObject fobj = new FrameObject(fname);
                this.setCacheableDataFields(fobj);
                if (this._schema != null) {
                    fobj.setSchema(this._schema);
                }
                ec.setVariable(this.getInput1().getName(), fobj);
                break;
            }
            case LIST: {
                ListObject lo = ListReader.readListFromHDFS(this.getInput2().getName(), ((MetaDataFormat)this.metadata).getFileFormat().name(), this._formatProperties);
                ec.setVariable(this.getInput1().getName(), lo);
                break;
            }
            case SCALAR: {
                ec.setScalarOutput(this.getInput1().getName(), null);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected data type: " + this.getInput1().getDataType());
            }
        }
    }

    private String createUniqueFilename() {
        String fname = this.getInput2().getName();
        if (Boolean.parseBoolean(this.getInput3().getName())) {
            fname = VariableCPInstruction.getUniqueFileName(fname);
        }
        return fname;
    }

    private void setCacheableDataFields(CacheableData<?> obj) {
        obj.setMetaData((MetaData)this.metadata.clone());
        obj.setPrivacyConstraints(this.getPrivacyConstraint());
        obj.enableCleanup(!this.getInput1().getName().startsWith("pREAD"));
        obj.setFileFormatProperties(this._formatProperties);
    }

    private void processMoveInstruction(ExecutionContext ec) {
        if (this.getInput3() == null) {
            Data tgtData;
            Data srcData = ec.removeVariable(this.getInput1().getName());
            if (srcData == null) {
                throw new DMLRuntimeException("Unexpected error: could not find a data object for variable name: " + this.getInput1().getName() + ", while processing instruction ");
            }
            if ((srcData.getDataType().isMatrix() || srcData.getDataType().isFrame()) && (tgtData = ec.removeVariable(this.getInput2().getName())) != null && srcData != tgtData) {
                ec.cleanupDataObject(tgtData);
            }
            ec.setVariable(this.getInput2().getName(), srcData);
        } else {
            if (ec.getVariable(this.getInput1().getName()) == null) {
                throw new DMLRuntimeException("Unexpected error: could not find a data object for variable name:" + this.getInput1().getName() + ", while processing instruction " + this.toString());
            }
            Data object = ec.getVariable(this.getInput1().getName());
            if (this.getInput3().getName().equalsIgnoreCase("binaryblock")) {
                boolean success = false;
                success = ((CacheableData)object).moveData(this.getInput2().getName(), this.getInput3().getName());
                if (!success) {
                    throw new DMLRuntimeException("Failed to move var " + this.getInput1().getName() + " to file " + this.getInput2().getName() + ".");
                }
            } else {
                if (object instanceof MatrixObject) {
                    throw new DMLRuntimeException("Unexpected formats while copying: from matrix blocks [" + ((MatrixObject)object).getBlocksize() + "] to " + this.getInput3().getName());
                }
                if (object instanceof FrameObject) {
                    throw new DMLRuntimeException("Unexpected formats while copying: from fram object [" + ((FrameObject)object).getNumColumns() + "," + ((FrameObject)object).getNumColumns() + "] to " + this.getInput3().getName());
                }
            }
        }
    }

    private void processRemoveVariableAndFileInstruction(ExecutionContext ec) {
        boolean del = ((BooleanObject)ec.getScalarInput(this.getInput2().getName(), this.getInput2().getValueType(), true)).getBooleanValue();
        MatrixObject m = (MatrixObject)ec.removeVariable(this.getInput1().getName());
        if (!del) {
            if (m.isDirty()) {
                m.exportData();
            }
        } else {
            VariableCPInstruction.cleanDataOnHDFS(m);
        }
        if (!ec.getVariables().hasReferences(m)) {
            m.clearData(ec.getTID());
        }
    }

    private void processCastAsScalarVariableInstruction(ExecutionContext ec) {
        switch (this.getInput1().getDataType()) {
            case MATRIX: {
                MatrixBlock mBlock = ec.getMatrixInput(this.getInput1().getName());
                if (mBlock.getNumRows() != 1 || mBlock.getNumColumns() != 1) {
                    throw new DMLRuntimeException("Dimension mismatch - unable to cast matrix '" + this.getInput1().getName() + "' of dimension (" + mBlock.getNumRows() + " x " + mBlock.getNumColumns() + ") to scalar. " + mBlock);
                }
                double value = mBlock.getValue(0, 0);
                ec.releaseMatrixInput(this.getInput1().getName());
                ec.setScalarOutput(this.output.getName(), new DoubleObject(value));
                break;
            }
            case FRAME: {
                FrameBlock fBlock = ec.getFrameInput(this.getInput1().getName());
                if (fBlock.getNumRows() != 1 || fBlock.getNumColumns() != 1) {
                    throw new DMLRuntimeException("Dimension mismatch - unable to cast frame '" + this.getInput1().getName() + "' of dimension (" + fBlock.getNumRows() + " x " + fBlock.getNumColumns() + ") to scalar.");
                }
                Object value = fBlock.get(0, 0);
                ec.releaseFrameInput(this.getInput1().getName());
                ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.createScalarObject(fBlock.getSchema()[0], value));
                break;
            }
            case TENSOR: {
                TensorBlock tBlock = ec.getTensorInput(this.getInput1().getName());
                if (tBlock.getNumDims() != 2 || tBlock.getNumRows() != 1 || tBlock.getNumColumns() != 1) {
                    throw new DMLRuntimeException("Dimension mismatch - unable to cast tensor '" + this.getInput1().getName() + "' to scalar.");
                }
                Types.ValueType vt = !tBlock.isBasic() ? tBlock.getSchema()[0] : tBlock.getValueType();
                ec.setScalarOutput(this.output.getName(), ScalarObjectFactory.createScalarObject(vt, tBlock.get(new int[]{0, 0})));
                ec.releaseTensorInput(this.getInput1().getName());
                break;
            }
            case LIST: {
                ListObject list = (ListObject)ec.getVariable(this.getInput1().getName());
                ec.setVariable(this.output.getName(), list.slice(0));
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported data type in as.scalar(): " + this.getInput1().getDataType().name());
            }
        }
    }

    private void processCastAsMatrixVariableInstruction(ExecutionContext ec) {
        switch (this.getInput1().getDataType()) {
            case FRAME: {
                FrameBlock fin = ec.getFrameInput(this.getInput1().getName());
                MatrixBlock out = DataConverter.convertToMatrixBlock(fin);
                ec.releaseFrameInput(this.getInput1().getName());
                ec.setMatrixOutput(this.output.getName(), out);
                break;
            }
            case SCALAR: {
                ScalarObject scalarInput = ec.getScalarInput(this.getInput1());
                MatrixBlock out = new MatrixBlock(scalarInput.getDoubleValue());
                ec.setMatrixOutput(this.output.getName(), out);
                break;
            }
            case LIST: {
                ListObject list = (ListObject)ec.getVariable(this.getInput1().getName());
                if (list.getLength() > 1) {
                    if (!list.checkAllDataTypes(Types.DataType.SCALAR)) {
                        throw new DMLRuntimeException("as.matrix over multi-entry list only allows scalars.");
                    }
                    MatrixBlock out = new MatrixBlock(list.getLength(), 1, false);
                    for (int i = 0; i < list.getLength(); ++i) {
                        out.quickSetValue(i, 0, ((ScalarObject)list.slice(i)).getDoubleValue());
                    }
                    ec.setMatrixOutput(this.output.getName(), out);
                    break;
                }
                Data tmp = list.slice(0);
                if (tmp instanceof ScalarObject && tmp.getValueType() != Types.ValueType.STRING) {
                    MatrixBlock out = new MatrixBlock(((ScalarObject)tmp).getDoubleValue());
                    ec.setMatrixOutput(this.output.getName(), out);
                    break;
                }
                ec.setVariable(this.output.getName(), tmp);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported data type in as.matrix(): " + this.getInput1().getDataType().name());
            }
        }
    }

    private void processCastAsFrameVariableInstruction(ExecutionContext ec) {
        if (this.getInput1().getDataType() == Types.DataType.SCALAR) {
            ScalarObject scalarInput = ec.getScalarInput(this.getInput1());
            FrameBlock out = new FrameBlock(1, this.getInput1().getValueType());
            out.ensureAllocatedColumns(1);
            out.set(0, 0, scalarInput.getStringValue());
            this.setColumnNames(ec, out);
            ec.setFrameOutput(this.output.getName(), out);
        } else if (this.getInput1().getDataType() == Types.DataType.MATRIX) {
            MatrixBlock min = ec.getMatrixInput(this.getInput1().getName());
            FrameBlock out = DataConverter.convertToFrameBlock(min, this.k);
            ec.releaseMatrixInput(this.getInput1().getName());
            this.setColumnNames(ec, out);
            ec.setFrameOutput(this.output.getName(), out);
        } else {
            ListObject list = (ListObject)ec.getVariable(this.getInput1().getName());
            Data tmp = list.slice(0);
            if (this.getInput2() != null) {
                throw new RuntimeException("List does not support as.frame column names arguments");
            }
            ec.setVariable(this.output.getName(), tmp);
        }
    }

    private void setColumnNames(ExecutionContext ec, FrameBlock out) {
        if (this.getInput2() != null) {
            ListObject colNames = (ListObject)ec.getVariable(this.getInput2().getName());
            String[] names = new String[out.getNumColumns()];
            List<Data> dat = colNames.getData();
            LOG.error(dat);
            for (int i = 0; i < out.getNumColumns(); ++i) {
                names[i] = ((StringObject)dat.get(i)).getStringValue();
            }
            out.setColumnNames(names);
        }
    }

    private void processReadInstruction(ExecutionContext ec) {
        ec.setScalarOutput(this.getInput1().getName(), HDFSTool.readScalarObjectFromHDFSFile(this.getInput2().getName(), this.getInput1().getValueType()));
    }

    private void processCopyInstruction(ExecutionContext ec) {
        Data dd = ec.getVariable(this.getInput1().getName());
        if (dd == null) {
            throw new DMLRuntimeException("Unexpected error: could not find a data object for variable name:" + this.getInput1().getName() + ", while processing instruction " + this.toString());
        }
        Data input2_data = ec.removeVariable(this.getInput2().getName());
        if (input2_data != null) {
            ec.cleanupDataObject(input2_data);
        }
        ec.setVariable(this.getInput2().getName(), dd);
    }

    private void processWriteInstruction(ExecutionContext ec) {
        CacheableData mo;
        String fname = ec.getScalarInput(this.getInput2()).getStringValue();
        String fmtStr = ec.getScalarInput(this.getInput3()).getStringValue();
        Types.FileFormat fmt = Types.FileFormat.safeValueOf(fmtStr);
        if (fmt != Types.FileFormat.LIBSVM && fmt != Types.FileFormat.HDF5) {
            String desc = ec.getScalarInput(this.getInput4().getName(), Types.ValueType.STRING, this.getInput4().isLiteral()).getStringValue();
            this._formatProperties.setDescription(desc);
        }
        if (this.getInput1().getDataType() == Types.DataType.SCALAR) {
            HDFSTool.writeScalarToHDFS(ec.getScalarInput(this.getInput1()), fname);
        } else if (this.getInput1().getDataType() == Types.DataType.MATRIX) {
            if (fmt == Types.FileFormat.MM) {
                this.writeMMFile(ec, fname);
            } else if (fmt == Types.FileFormat.CSV) {
                this.writeCSVFile(ec, fname);
            } else if (fmt == Types.FileFormat.LIBSVM) {
                this.writeLIBSVMFile(ec, fname);
            } else if (fmt == Types.FileFormat.HDF5) {
                this.writeHDF5File(ec, fname);
            } else {
                mo = ec.getMatrixObject(this.getInput1().getName());
                int blen = Integer.parseInt(this.getInput4().getName());
                mo.exportData(fname, fmtStr, new FileFormatProperties(blen));
            }
            this.setPrivacyConstraint(ec.getMatrixObject(this.getInput1().getName()).getPrivacyConstraint());
        } else if (this.getInput1().getDataType() == Types.DataType.FRAME) {
            mo = ec.getFrameObject(this.getInput1().getName());
            mo.exportData(fname, fmtStr, this._formatProperties);
            this.setPrivacyConstraint(mo.getPrivacyConstraint());
        } else if (this.getInput1().getDataType() == Types.DataType.TENSOR) {
            TensorObject to = ec.getTensorObject(this.getInput1().getName());
            this.setPrivacyConstraint(to.getPrivacyConstraint());
            to.exportData(fname, fmtStr, this._formatProperties);
        } else if (this.getInput1().getDataType() == Types.DataType.LIST) {
            ListObject lo = ec.getListObject(this.getInput1().getName());
            ListWriter.writeListToHDFS(lo, fname, fmtStr, this._formatProperties);
        }
    }

    private void processSetFileNameInstruction(ExecutionContext ec) {
        Data data = ec.getVariable(this.getInput1().getName());
        if (data.getDataType() == Types.DataType.MATRIX) {
            if (!this.getInput3().getName().equalsIgnoreCase("remote")) {
                throw new DMLRuntimeException("Invalid location (" + this.getInput3().getName() + ") in SetFileName instruction: " + this.instString);
            }
        } else {
            throw new DMLRuntimeException("Invalid data type (" + this.getInput1().getDataType() + ") in SetFileName instruction: " + this.instString);
        }
        ((MatrixObject)data).setFileName(this.getInput2().getName());
    }

    public static void processRmvarInstruction(ExecutionContext ec, String varname) {
        Data dat = ec.removeVariable(varname);
        if (dat != null) {
            ec.cleanupDataObject(dat);
        }
    }

    private void writeCSVFile(ExecutionContext ec, String fname) {
        FileFormatProperties fprop;
        MatrixObject mo = ec.getMatrixObject(this.getInput1().getName());
        String outFmt = "csv";
        FileFormatProperties fileFormatProperties = fprop = this._formatProperties instanceof FileFormatPropertiesCSV ? this._formatProperties : new FileFormatPropertiesCSV();
        if (mo.isDirty()) {
            mo.exportData(fname, outFmt, fprop);
        } else {
            try {
                Types.FileFormat fmt = ((MetaDataFormat)mo.getMetaData()).getFileFormat();
                DataCharacteristics dc = mo.getMetaData().getDataCharacteristics();
                if (fmt == Types.FileFormat.CSV && !this.getInput1().getName().startsWith("pREAD")) {
                    WriterTextCSV writer = new WriterTextCSV((FileFormatPropertiesCSV)fprop);
                    writer.addHeaderToCSV(mo.getFileName(), fname, dc.getRows(), dc.getCols());
                } else {
                    mo.exportData(fname, outFmt, fprop);
                }
                HDFSTool.writeMetaDataFile(fname + ".mtd", mo.getValueType(), dc, Types.FileFormat.CSV, fprop, mo.getPrivacyConstraint());
            }
            catch (IOException e) {
                throw new DMLRuntimeException(e);
            }
        }
    }

    private void writeLIBSVMFile(ExecutionContext ec, String fname) {
        MatrixObject mo = ec.getMatrixObject(this.getInput1().getName());
        String outFmt = "libsvm";
        if (mo.isDirty()) {
            mo.exportData(fname, outFmt, this._formatProperties);
        } else {
            try {
                mo.exportData(fname, outFmt, this._formatProperties);
                HDFSTool.writeMetaDataFile(fname + ".mtd", mo.getValueType(), mo.getMetaData().getDataCharacteristics(), Types.FileFormat.LIBSVM, this._formatProperties, mo.getPrivacyConstraint());
            }
            catch (IOException e) {
                throw new DMLRuntimeException(e);
            }
        }
    }

    private void writeHDF5File(ExecutionContext ec, String fname) {
        MatrixObject mo = ec.getMatrixObject(this.getInput1().getName());
        String outFmt = "hdf5";
        if (mo.isDirty()) {
            mo.exportData(fname, outFmt, this._formatProperties);
        } else {
            try {
                Types.FileFormat fmt = ((MetaDataFormat)mo.getMetaData()).getFileFormat();
                DataCharacteristics dc = mo.getMetaData().getDataCharacteristics();
                if (fmt == Types.FileFormat.HDF5 && !this.getInput1().getName().startsWith("pREAD")) {
                    WriterHDF5 writerHDF5 = new WriterHDF5((FileFormatPropertiesHDF5)this._formatProperties);
                } else {
                    mo.exportData(fname, outFmt, this._formatProperties);
                }
                HDFSTool.writeMetaDataFile(fname + ".mtd", mo.getValueType(), dc, Types.FileFormat.HDF5, this._formatProperties, mo.getPrivacyConstraint());
            }
            catch (IOException e) {
                throw new DMLRuntimeException(e);
            }
        }
    }

    private void writeMMFile(ExecutionContext ec, String fname) {
        MatrixObject mo = ec.getMatrixObject(this.getInput1().getName());
        String outFmt = Types.FileFormat.MM.toString();
        if (mo.isDirty()) {
            mo.exportData(fname, outFmt);
        } else {
            try {
                Types.FileFormat fmt = ((MetaDataFormat)mo.getMetaData()).getFileFormat();
                DataCharacteristics dc = mo.getDataCharacteristics();
                if (fmt == Types.FileFormat.TEXT && !this.getInput1().getName().startsWith("pREAD")) {
                    WriterMatrixMarket.mergeTextcellToMatrixMarket(mo.getFileName(), fname, dc.getRows(), dc.getCols(), dc.getNonZeros());
                } else {
                    mo.exportData(fname, outFmt);
                }
            }
            catch (IOException e) {
                throw new DMLRuntimeException(e);
            }
        }
    }

    private static void cleanDataOnHDFS(MatrixObject mo) {
        try {
            String fpath = mo.getFileName();
            if (fpath != null) {
                HDFSTool.deleteFileIfExistOnHDFS(fpath);
                HDFSTool.deleteFileIfExistOnHDFS(fpath + ".mtd");
            }
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    public static Instruction prepareRemoveInstruction(long ... varName) {
        String[] tmp = new String[varName.length];
        Arrays.setAll(tmp, i -> String.valueOf(varName[i]));
        return VariableCPInstruction.prepareRemoveInstruction(tmp);
    }

    public static Instruction prepareRemoveInstruction(String ... varNames) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append("CP");
        sb.append("\u00b0");
        sb.append("rmvar");
        for (String varName : varNames) {
            sb.append("\u00b0");
            sb.append(varName);
        }
        return VariableCPInstruction.parseInstruction(sb.toString());
    }

    public static Instruction prepareCopyInstruction(String srcVar, String destVar) {
        return VariableCPInstruction.parseInstruction(InstructionUtils.concatOperands("CP", "cpvar", srcVar, destVar));
    }

    public static Instruction prepMoveInstruction(String srcVar, String destFileName, String format) {
        return VariableCPInstruction.parseInstruction(InstructionUtils.concatOperands("CP", "mvvar", srcVar, destFileName, format));
    }

    public static Instruction prepMoveInstruction(String srcVar, String destVar) {
        return VariableCPInstruction.parseInstruction(InstructionUtils.concatOperands("CP", "mvvar", srcVar, destVar));
    }

    private static String getBasicCreatevarString(String varName, String fileName, boolean fNameOverride, Types.DataType dt, String format) {
        boolean lfNameOverride = fNameOverride && !ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_TEMPORARY_FILENAMES);
        return InstructionUtils.concatOperands("CP", "createvar", varName, fileName, String.valueOf(lfNameOverride), dt.toString(), format);
    }

    public static Instruction prepCreatevarInstruction(String varName, String fileName, boolean fNameOverride, String format) {
        return VariableCPInstruction.parseInstruction(VariableCPInstruction.getBasicCreatevarString(varName, fileName, fNameOverride, Types.DataType.MATRIX, format));
    }

    public static Instruction prepCreatevarInstruction(String varName, String fileName, boolean fNameOverride, Types.DataType dt, String format, DataCharacteristics mc, MatrixObject.UpdateType update) {
        return VariableCPInstruction.parseInstruction(InstructionUtils.concatOperands(VariableCPInstruction.getBasicCreatevarString(varName, fileName, fNameOverride, dt, format), String.valueOf(mc.getRows()), String.valueOf(mc.getCols()), String.valueOf(mc.getBlocksize()), String.valueOf(mc.getNonZeros()), update.toString().toLowerCase()));
    }

    public static Instruction prepCreatevarInstruction(String varName, String fileName, boolean fNameOverride, Types.DataType dt, String format, DataCharacteristics mc, MatrixObject.UpdateType update, boolean hasHeader, String delim, boolean sparse) {
        return VariableCPInstruction.parseInstruction(InstructionUtils.concatOperands(VariableCPInstruction.getBasicCreatevarString(varName, fileName, fNameOverride, dt, format), String.valueOf(mc.getRows()), String.valueOf(mc.getCols()), String.valueOf(mc.getBlocksize()), String.valueOf(mc.getNonZeros()), update.toString().toLowerCase(), String.valueOf(hasHeader), delim, String.valueOf(sparse)));
    }

    @Override
    public void updateInstructionThreadID(String pattern, String replace) {
        if (this.opcode == VariableOperationCode.CreateVariable || this.opcode == VariableOperationCode.SetFileName) {
            this.getInput2().setName(this.getInput2().getName().replaceAll(pattern, replace));
            int iPos = StringUtils.ordinalIndexOf((CharSequence)this.instString, (CharSequence)"\u00b0", (int)3);
            int iPos2 = StringUtils.indexOf((CharSequence)this.instString, (CharSequence)"\u00b0", (int)(iPos + 1));
            StringBuilder sb = new StringBuilder();
            sb.append(this.instString.substring(0, iPos + 1));
            sb.append(ProgramConverter.saveReplaceFilenameThreadID(this.instString.substring(iPos + 1, iPos2 + 1), pattern, replace));
            sb.append(this.instString.substring(iPos2 + 1));
            this.instString = sb.toString();
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        String varname = null;
        LineageItem li = null;
        switch (this.getVariableOpcode()) {
            case CreateVariable: {
                if (!this._containsPreadPrefix) break;
            }
            case Read: {
                varname = this.getInput1().getName();
                li = new LineageItem(this.toString().replace(this.getInput1().getName(), "pREADxxx"), this.getOpcode());
                break;
            }
            case AssignVariable: {
                varname = this.getInput2().getName();
                li = new LineageItem(this.getOpcode(), new LineageItem[]{ec.getLineage().getOrCreate(this.getInput1())});
                break;
            }
            case CopyVariable: {
                if (!ec.getLineage().contains(this.getInput1())) {
                    throw new DMLRuntimeException("Could not find LineageItem for " + this.getInput1().getName());
                }
                varname = this.getInput2().getName();
                li = new LineageItem(this.getOpcode(), new LineageItem[]{ec.getLineage().get(this.getInput1())});
                break;
            }
            case Write: {
                ArrayList<LineageItem> lineages = new ArrayList<LineageItem>();
                for (CPOperand input : this.getInputs()) {
                    if (input.getName().isEmpty()) continue;
                    lineages.add(ec.getLineage().getOrCreate(input));
                }
                if (this._formatProperties != null && this._formatProperties.getDescription() != null && !this._formatProperties.getDescription().isEmpty()) {
                    lineages.add(new LineageItem(this._formatProperties.getDescription()));
                }
                varname = this.getInput1().getName();
                li = new LineageItem(this.getOpcode(), lineages.toArray(new LineageItem[0]));
                break;
            }
            case CastAsScalarVariable: 
            case CastAsMatrixVariable: 
            case CastAsFrameVariable: 
            case CastAsDoubleVariable: 
            case CastAsIntegerVariable: 
            case CastAsBooleanVariable: {
                varname = this.getOutputVariableName();
                li = new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this.getInput1()));
                break;
            }
            case CastAsListVariable: {
                varname = this.getOutputVariableName();
                ListObject lobj = ec.getListObject(this.getInput1());
                if (lobj.getLength() != 1 || !(lobj.getData(0) instanceof ListObject)) {
                    li = new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this.getInput1()));
                    break;
                }
                li = new LineageItem(this.getOpcode(), new LineageItem[]{lobj.getLineageItem(0)});
                break;
            }
        }
        return li == null ? null : Pair.of((Object)varname, li);
    }

    public boolean isVariableCastInstruction() {
        return this.opcode == VariableOperationCode.CastAsScalarVariable || this.opcode == VariableOperationCode.CastAsMatrixVariable || this.opcode == VariableOperationCode.CastAsFrameVariable || this.opcode == VariableOperationCode.CastAsIntegerVariable || this.opcode == VariableOperationCode.CastAsDoubleVariable || this.opcode == VariableOperationCode.CastAsBooleanVariable;
    }

    public static String getUniqueFileName(String fname) {
        return InstructionUtils.concatStrings(fname, "_", String.valueOf(_uniqueVarID.getNextID()));
    }

    public static enum VariableOperationCode {
        CreateVariable,
        AssignVariable,
        CopyVariable,
        MoveVariable,
        RemoveVariable,
        RemoveVariableAndFile,
        CastAsScalarVariable,
        CastAsMatrixVariable,
        CastAsFrameVariable,
        CastAsListVariable,
        CastAsDoubleVariable,
        CastAsIntegerVariable,
        CastAsBooleanVariable,
        Write,
        Read,
        SetFileName;


        public boolean isCast() {
            switch (this) {
                case CastAsScalarVariable: 
                case CastAsMatrixVariable: 
                case CastAsFrameVariable: 
                case CastAsListVariable: 
                case CastAsDoubleVariable: 
                case CastAsIntegerVariable: 
                case CastAsBooleanVariable: {
                    return true;
                }
            }
            return false;
        }
    }
}

