/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobContextImpl
implements JobContext {
    protected final JobConf conf;
    private JobID jobId;
    protected UserGroupInformation ugi;
    protected final Credentials credentials;

    public JobContextImpl(Configuration conf, JobID jobId) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.jobId = jobId;
        this.credentials = this.conf.getCredentials();
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public JobID getJobID() {
        return this.jobId;
    }

    public void setJobID(JobID jobId) {
        this.jobId = jobId;
    }

    @Override
    public int getNumReduceTasks() {
        return this.conf.getNumReduceTasks();
    }

    @Override
    public Path getWorkingDirectory() throws IOException {
        return this.conf.getWorkingDirectory();
    }

    @Override
    public Class<?> getOutputKeyClass() {
        return this.conf.getOutputKeyClass();
    }

    @Override
    public Class<?> getOutputValueClass() {
        return this.conf.getOutputValueClass();
    }

    @Override
    public Class<?> getMapOutputKeyClass() {
        return this.conf.getMapOutputKeyClass();
    }

    @Override
    public Class<?> getMapOutputValueClass() {
        return this.conf.getMapOutputValueClass();
    }

    @Override
    public String getJobName() {
        return this.conf.getJobName();
    }

    @Override
    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.inputformat.class", TextInputFormat.class);
    }

    @Override
    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.map.class", Mapper.class);
    }

    @Override
    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.combine.class", null);
    }

    @Override
    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.reduce.class", Reducer.class);
    }

    @Override
    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.outputformat.class", TextOutputFormat.class);
    }

    @Override
    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.partitioner.class", HashPartitioner.class);
    }

    @Override
    public RawComparator<?> getSortComparator() {
        return this.conf.getOutputKeyComparator();
    }

    @Override
    public String getJar() {
        return this.conf.getJar();
    }

    @Override
    public RawComparator<?> getCombinerKeyGroupingComparator() {
        return this.conf.getCombinerKeyGroupingComparator();
    }

    @Override
    public RawComparator<?> getGroupingComparator() {
        return this.conf.getOutputValueGroupingComparator();
    }

    @Override
    public boolean getJobSetupCleanupNeeded() {
        return this.conf.getBoolean("mapreduce.job.committer.setup.cleanup.needed", true);
    }

    @Override
    public boolean getTaskCleanupNeeded() {
        return this.conf.getBoolean("mapreduce.job.committer.task.cleanup.needed", true);
    }

    @Override
    public boolean getSymlink() {
        return DistributedCache.getSymlink(this.conf);
    }

    @Override
    public Path[] getArchiveClassPaths() {
        return JobContextImpl.getArchiveClassPaths(this.conf);
    }

    public static Path[] getArchiveClassPaths(Configuration conf) {
        ArrayList list = (ArrayList)conf.getStringCollection("mapreduce.job.classpath.archives");
        if (list.size() == 0) {
            return null;
        }
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    @Override
    public URI[] getCacheArchives() throws IOException {
        return JobContextImpl.getCacheArchives(this.conf);
    }

    public static URI[] getCacheArchives(Configuration conf) {
        return StringUtils.stringToURI((String[])conf.getStrings("mapreduce.job.cache.archives"));
    }

    @Override
    public URI[] getCacheFiles() throws IOException {
        return JobContextImpl.getCacheFiles(this.conf);
    }

    public static URI[] getCacheFiles(Configuration conf) {
        return StringUtils.stringToURI((String[])conf.getStrings("mapreduce.job.cache.files"));
    }

    @Override
    public Path[] getLocalCacheArchives() throws IOException {
        return JobContextImpl.getLocalCacheArchives(this.conf);
    }

    public static Path[] getLocalCacheArchives(Configuration conf) {
        return StringUtils.stringToPath((String[])conf.getStrings("mapreduce.job.cache.local.archives"));
    }

    @Override
    public Path[] getLocalCacheFiles() throws IOException {
        return JobContextImpl.getLocalCacheFiles(this.conf);
    }

    public static Path[] getLocalCacheFiles(Configuration conf) {
        return StringUtils.stringToPath((String[])conf.getStrings("mapreduce.job.cache.local.files"));
    }

    private static long[] parseTimestamps(String[] strs) {
        if (strs == null) {
            return null;
        }
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Long.parseLong(strs[i]);
        }
        return result;
    }

    public static long[] getArchiveTimestamps(Configuration conf) {
        return JobContextImpl.parseTimestamps(conf.getStrings("mapreduce.job.cache.archives.timestamps"));
    }

    public static long[] getFileTimestamps(Configuration conf) {
        return JobContextImpl.parseTimestamps(conf.getStrings("mapreduce.job.cache.files.timestamps"));
    }

    @Override
    public Path[] getFileClassPaths() {
        return JobContextImpl.getFileClassPaths(this.conf);
    }

    public static Path[] getFileClassPaths(Configuration conf) {
        ArrayList list = (ArrayList)conf.getStringCollection("mapreduce.job.classpath.files");
        if (list.size() == 0) {
            return null;
        }
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    private static String[] toTimestampStrs(long[] timestamps) {
        if (timestamps == null) {
            return null;
        }
        String[] result = new String[timestamps.length];
        for (int i = 0; i < timestamps.length; ++i) {
            result[i] = Long.toString(timestamps[i]);
        }
        return result;
    }

    @Override
    public String[] getArchiveTimestamps() {
        return JobContextImpl.toTimestampStrs(JobContextImpl.getArchiveTimestamps(this.conf));
    }

    @Override
    public String[] getFileTimestamps() {
        return JobContextImpl.toTimestampStrs(JobContextImpl.getFileTimestamps(this.conf));
    }

    @Override
    public int getMaxMapAttempts() {
        return this.conf.getMaxMapAttempts();
    }

    @Override
    public int getMaxReduceAttempts() {
        return this.conf.getMaxReduceAttempts();
    }

    @Override
    public boolean getProfileEnabled() {
        return this.conf.getProfileEnabled();
    }

    @Override
    public String getProfileParams() {
        return this.conf.getProfileParams();
    }

    @Override
    public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
        return this.conf.getProfileTaskRange(isMap);
    }

    @Override
    public String getUser() {
        return this.conf.getUser();
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JobContextImpl{");
        sb.append("jobId=").append(this.jobId);
        sb.append('}');
        return sb.toString();
    }
}

