/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.workload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.NaryOp;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.RewriteCompressedReblock;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.compress.workload.AWTreeNode;
import org.apache.sysds.runtime.compress.workload.Op;
import org.apache.sysds.runtime.compress.workload.OpMetadata;
import org.apache.sysds.runtime.compress.workload.OpNormal;
import org.apache.sysds.runtime.compress.workload.OpSided;
import org.apache.sysds.runtime.compress.workload.WTreeNode;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;
import org.apache.sysds.utils.Explain;

public class WorkloadAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)WorkloadAnalyzer.class.getName());
    public static boolean ALLOW_INTERMEDIATE_CANDIDATES = false;
    public static boolean PRUNE_COMPRESSED_INTERMEDIATES = true;
    private final Set<Hop> visited;
    private final Set<Long> compressed;
    private final Set<Long> transposed;
    private final Map<String, Long> transientCompressed;
    private final Set<Long> overlapping;
    private final DMLProgram prog;
    private final Map<Long, Op> treeLookup;
    private final Stack<Hop> stack;
    private Stack<StatementBlock> lineage = new Stack();

    public static Map<Long, WTreeRoot> getAllCandidateWorkloads(DMLProgram prog) {
        String configValue = ConfigurationManager.getDMLConfig().getTextValue("sysds.compressed.linalg.intermediate");
        ALLOW_INTERMEDIATE_CANDIDATES = configValue != null && Objects.equals(configValue.toUpperCase(), "TRUE") || configValue == null && ALLOW_INTERMEDIATE_CANDIDATES;
        List<Hop> candidates = WorkloadAnalyzer.getCandidates(prog);
        LinkedList<WorkloadAnalyzer> allWAs = new LinkedList<WorkloadAnalyzer>();
        HashMap<Long, WTreeRoot> map = new HashMap<Long, WTreeRoot>();
        for (Hop cand : candidates) {
            if (PRUNE_COMPRESSED_INTERMEDIATES && allWAs.stream().anyMatch(w -> w.containsCompressed(cand))) continue;
            WorkloadAnalyzer wa = new WorkloadAnalyzer(prog);
            WTreeRoot tree = wa.createWorkloadTreeRoot(cand);
            map.put(cand.getHopID(), tree);
            allWAs.add(wa);
        }
        return map;
    }

    private WorkloadAnalyzer(DMLProgram prog) {
        this.prog = prog;
        this.visited = new HashSet<Hop>();
        this.compressed = new HashSet<Long>();
        this.transposed = new HashSet<Long>();
        this.transientCompressed = new HashMap<String, Long>();
        this.overlapping = new HashSet<Long>();
        this.treeLookup = new HashMap<Long, Op>();
        this.stack = new Stack();
        this.lineage = new Stack();
    }

    private WorkloadAnalyzer(DMLProgram prog, Set<Long> compressed, HashMap<String, Long> transientCompressed, Set<Long> transposed, Set<Long> overlapping, Map<Long, Op> treeLookup) {
        this.prog = prog;
        this.visited = new HashSet<Hop>();
        this.compressed = compressed;
        this.transposed = transposed;
        this.transientCompressed = transientCompressed;
        this.overlapping = overlapping;
        this.treeLookup = treeLookup;
        this.stack = new Stack();
    }

    private WTreeRoot createWorkloadTreeRoot(Hop candidate) {
        WTreeRoot main = new WTreeRoot(candidate);
        this.compressed.add(candidate.getHopID());
        if (HopRewriteUtils.isTransformEncode(candidate)) {
            Hop matrix = ((FunctionOp)candidate).getOutputs().get(0);
            this.compressed.add(matrix.getHopID());
            this.transientCompressed.put(matrix.getName(), matrix.getHopID());
        }
        for (StatementBlock sb : this.prog.getStatementBlocks()) {
            this.createWorkloadTreeNodes(main, sb, this.prog, new HashSet<String>());
        }
        WorkloadAnalyzer.pruneWorkloadTree(main);
        return main;
    }

    private boolean containsCompressed(Hop hop) {
        return this.compressed.contains(hop.getHopID());
    }

    private static List<Hop> getCandidates(DMLProgram prog) {
        ArrayList<Hop> candidates = new ArrayList<Hop>();
        for (StatementBlock sb : prog.getStatementBlocks()) {
            WorkloadAnalyzer.getCandidates(sb, prog, candidates, new HashSet<String>());
        }
        return candidates;
    }

    private static boolean pruneWorkloadTree(AWTreeNode node) {
        Iterator<WTreeNode> iter = node.getChildNodes().iterator();
        while (iter.hasNext()) {
            if (!WorkloadAnalyzer.pruneWorkloadTree(iter.next())) continue;
            iter.remove();
        }
        return node.isEmpty();
    }

    private static void getCandidates(StatementBlock sb, DMLProgram prog, List<Hop> cands, Set<String> fStack) {
        if (sb == null) {
            return;
        }
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock csb : fstmt.getBody()) {
                WorkloadAnalyzer.getCandidates(csb, prog, cands, fStack);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            for (StatementBlock csb : wstmt.getBody()) {
                WorkloadAnalyzer.getCandidates(csb, prog, cands, fStack);
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            for (StatementBlock csb : istmt.getIfBody()) {
                WorkloadAnalyzer.getCandidates(csb, prog, cands, fStack);
            }
            for (StatementBlock csb : istmt.getElseBody()) {
                WorkloadAnalyzer.getCandidates(csb, prog, cands, fStack);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            for (StatementBlock csb : fstmt.getBody()) {
                WorkloadAnalyzer.getCandidates(csb, prog, cands, fStack);
            }
        } else {
            ArrayList<Hop> hops = sb.getHops();
            if (hops != null) {
                Hop.resetVisitStatus(hops);
                for (Hop hop : hops) {
                    WorkloadAnalyzer.getCandidates(hop, prog, cands, fStack);
                }
                Hop.resetVisitStatus(hops);
            }
        }
    }

    private static void getCandidates(Hop hop, DMLProgram prog, List<Hop> cands, Set<String> fStack) {
        FunctionOp fop;
        if (hop.isVisited()) {
            return;
        }
        if (ALLOW_INTERMEDIATE_CANDIDATES && RewriteCompressedReblock.satisfiesAggressiveCompressionCondition(hop) || RewriteCompressedReblock.satisfiesCompressionCondition(hop)) {
            cands.add(hop);
        }
        for (Hop c : hop.getInput()) {
            WorkloadAnalyzer.getCandidates(c, prog, cands, fStack);
        }
        if (hop instanceof FunctionOp && !fStack.contains((fop = (FunctionOp)hop).getFunctionKey())) {
            fStack.add(fop.getFunctionKey());
            WorkloadAnalyzer.getCandidates(prog.getFunctionStatementBlock(fop.getFunctionKey()), prog, cands, fStack);
            fStack.remove(fop.getFunctionKey());
        }
        hop.setVisited();
    }

    private void createWorkloadTreeNodes(AWTreeNode n, StatementBlock sb, DMLProgram prog, Set<String> fStack) {
        WTreeNode node;
        this.lineage.add(sb);
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            node = new WTreeNode(AWTreeNode.WTNodeType.FCALL, 1);
            for (StatementBlock csb : fstmt.getBody()) {
                this.createWorkloadTreeNodes(node, csb, prog, fStack);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            node = new WTreeNode(AWTreeNode.WTNodeType.WHILE, 100);
            this.createWorkloadTree(wsb.getPredicateHops(), prog, node, fStack);
            for (StatementBlock csb : wstmt.getBody()) {
                this.createWorkloadTreeNodes(node, csb, prog, fStack);
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            node = new WTreeNode(AWTreeNode.WTNodeType.IF, 1);
            this.createWorkloadTree(isb.getPredicateHops(), prog, node, fStack);
            for (StatementBlock csb : istmt.getIfBody()) {
                this.createWorkloadTreeNodes(node, csb, prog, fStack);
            }
            for (StatementBlock csb : istmt.getElseBody()) {
                this.createWorkloadTreeNodes(node, csb, prog, fStack);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            node = new WTreeNode(sb instanceof ParForStatementBlock ? AWTreeNode.WTNodeType.PARFOR : AWTreeNode.WTNodeType.FOR, fsb.getEstimateReps());
            this.createWorkloadTree(fsb.getFromHops(), prog, node, fStack);
            this.createWorkloadTree(fsb.getToHops(), prog, node, fStack);
            this.createWorkloadTree(fsb.getIncrementHops(), prog, node, fStack);
            for (StatementBlock csb : fstmt.getBody()) {
                this.createWorkloadTreeNodes(node, csb, prog, fStack);
            }
        } else {
            ArrayList<Hop> hops = sb.getHops();
            if (hops != null) {
                for (Hop hop : hops) {
                    this.createWorkloadTree(hop, prog, n, fStack);
                }
                for (Hop hop : hops) {
                    if (!(hop instanceof FunctionOp)) continue;
                    FunctionOp fop = (FunctionOp)hop;
                    if (HopRewriteUtils.isTransformEncode(fop)) break;
                    if (fStack.contains(fop.getFunctionKey())) continue;
                    fStack.add(fop.getFunctionKey());
                    FunctionStatementBlock fsb = prog.getFunctionStatementBlock(fop.getFunctionKey());
                    if (fsb == null) continue;
                    HashMap<String, Long> fCompressed = new HashMap<String, Long>();
                    String[] ins = fop.getInputVariableNames();
                    for (int i = 0; i < ins.length; ++i) {
                        String name = ins[i];
                        Long outsideID = fop.getInput(i).getHopID();
                        if (!this.compressed.contains(outsideID)) continue;
                        fCompressed.put(name, outsideID);
                    }
                    WorkloadAnalyzer fa = new WorkloadAnalyzer(prog, this.compressed, fCompressed, this.transposed, this.overlapping, this.treeLookup);
                    fa.createWorkloadTreeNodes(n, fsb, prog, fStack);
                    String[] outs = fop.getOutputVariableNames();
                    for (int i = 0; i < outs.length; ++i) {
                        Long id = fCompressed.get(outs[i]);
                        if (id == null) continue;
                        this.transientCompressed.put(outs[i], id);
                    }
                    fStack.remove(fop.getFunctionKey());
                }
            }
            this.lineage.pop();
            return;
        }
        n.addChild(node);
        this.lineage.pop();
    }

    private void createStack(Hop hop) {
        if (hop == null || this.visited.contains(hop) || WorkloadAnalyzer.isNoOp(hop)) {
            return;
        }
        this.stack.add(hop);
        for (Hop c : hop.getInput()) {
            this.createStack(c);
        }
        this.visited.add(hop);
    }

    private void createWorkloadTree(Hop hop, DMLProgram prog, AWTreeNode parent, Set<String> fStack) {
        this.createStack(hop);
        this.processStack(prog, parent, fStack);
    }

    private void processStack(DMLProgram prog, AWTreeNode parent, Set<String> fStack) {
        while (!this.stack.isEmpty()) {
            Hop hop = this.stack.pop();
            if (HopRewriteUtils.isData(hop, Types.OpOpData.PERSISTENTREAD, Types.OpOpData.TRANSIENTREAD) && this.transientCompressed.containsKey(hop.getName())) {
                this.compressed.add(hop.getHopID());
                this.treeLookup.put(hop.getHopID(), this.treeLookup.get(this.transientCompressed.get(hop.getName())));
                continue;
            }
            if (!hop.getInput().stream().anyMatch(h -> this.compressed.contains(h.getHopID()))) continue;
            this.createOp(hop, parent);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createOp(Hop hop, AWTreeNode parent) {
        block52: {
            Op o;
            block51: {
                block62: {
                    Hop o2;
                    block64: {
                        Hop o1;
                        block63: {
                            block61: {
                                block58: {
                                    boolean ol;
                                    block60: {
                                        block59: {
                                            block57: {
                                                boolean right;
                                                block56: {
                                                    block55: {
                                                        block54: {
                                                            block53: {
                                                                if (!hop.getDataType().isMatrix()) break block52;
                                                                o = null;
                                                                if (HopRewriteUtils.isData(hop, Types.OpOpData.PERSISTENTREAD, Types.OpOpData.TRANSIENTREAD)) {
                                                                    return;
                                                                }
                                                                if (!HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTWRITE, Types.OpOpData.PERSISTENTWRITE)) break block53;
                                                                this.transientCompressed.put(hop.getName(), hop.getInput(0).getHopID());
                                                                this.compressed.add(hop.getHopID());
                                                                o = new OpMetadata(hop, hop.getInput(0));
                                                                if (this.isOverlapping(hop.getInput(0))) {
                                                                    o.setOverlapping();
                                                                }
                                                                break block51;
                                                            }
                                                            if (!(hop instanceof ReorgOp) || ((ReorgOp)hop).getOp() != Types.ReOrgOp.TRANS) break block54;
                                                            this.transposed.add(hop.getHopID());
                                                            this.compressed.add(hop.getHopID());
                                                            this.transientCompressed.put(hop.getName(), hop.getHopID());
                                                            o = new OpMetadata(hop, hop.getInput(0));
                                                            if (this.isOverlapping(hop.getInput(0))) {
                                                                o.setOverlapping();
                                                            }
                                                            break block51;
                                                        }
                                                        if (!(hop instanceof AggUnaryOp)) break block55;
                                                        if (this.isOverlapping(hop.getInput().get(0)) && !HopRewriteUtils.isAggUnaryOp(hop, Types.AggOp.SUM, Types.AggOp.MEAN) || HopRewriteUtils.isAggUnaryOp(hop, Types.AggOp.TRACE)) {
                                                            this.setDecompressionOnAllInputs(hop, parent);
                                                            return;
                                                        }
                                                        boolean compressedOut = false;
                                                        Hop parentHop = hop.getInput(0);
                                                        if (HopRewriteUtils.isBinary(parentHop, Types.OpOp2.EQUAL, Types.OpOp2.NOTEQUAL, Types.OpOp2.LESS, Types.OpOp2.LESSEQUAL, Types.OpOp2.GREATER, Types.OpOp2.GREATEREQUAL)) {
                                                            Hop leftIn = parentHop.getInput(0);
                                                            Hop rightIn = parentHop.getInput(1);
                                                            if (HopRewriteUtils.isAggUnaryOp(leftIn, Types.AggOp.MIN, Types.AggOp.MAX) || HopRewriteUtils.isAggUnaryOp(rightIn, Types.AggOp.MIN, Types.AggOp.MAX) || this.checkTransientRead(hop, leftIn) || this.checkTransientRead(hop, rightIn)) {
                                                                compressedOut = true;
                                                            }
                                                        }
                                                        o = new OpNormal(hop, compressedOut);
                                                        break block51;
                                                    }
                                                    if (!(hop instanceof UnaryOp)) break block56;
                                                    if (!HopRewriteUtils.isUnary(hop, Types.OpOp1.MULT2, Types.OpOp1.MINUS1_MULT, Types.OpOp1.MINUS_RIGHT, Types.OpOp1.CAST_AS_MATRIX)) {
                                                        if (this.isOverlapping(hop.getInput(0))) {
                                                            this.treeLookup.get(hop.getInput(0).getHopID()).setDecompressing();
                                                            return;
                                                        }
                                                        break block51;
                                                    } else if (HopRewriteUtils.isUnary(hop, Types.OpOp1.DETECTSCHEMA)) {
                                                        o = new OpNormal(hop, false);
                                                    }
                                                    break block51;
                                                }
                                                if (!(hop instanceof AggBinaryOp)) break block57;
                                                AggBinaryOp agbhop = (AggBinaryOp)hop;
                                                List<Hop> in = agbhop.getInput();
                                                boolean transposedLeft = this.transposed.contains(in.get(0).getHopID());
                                                boolean transposedRight = this.transposed.contains(in.get(1).getHopID());
                                                boolean left = this.compressed.contains(in.get(0).getHopID()) || this.transientCompressed.containsKey(in.get(0).getName());
                                                OpSided ret = new OpSided(hop, left, right = this.compressed.contains(in.get(1).getHopID()) || this.transientCompressed.containsKey(in.get(1).getName()), transposedLeft, transposedRight);
                                                if (ret.isRightMM()) {
                                                    this.overlapping.add(hop.getHopID());
                                                    ret.setOverlapping();
                                                    if (!ret.isCompressedOutput()) {
                                                        ret.setDecompressing();
                                                    }
                                                }
                                                o = ret;
                                                break block51;
                                            }
                                            if (!(hop instanceof BinaryOp)) break block58;
                                            if (!HopRewriteUtils.isBinary(hop, Types.OpOp2.CBIND)) break block59;
                                            List<Hop> in = hop.getInput();
                                            o = new OpNormal(hop, true);
                                            if (this.isOverlapping(in.get(0)) || this.isOverlapping(in.get(1))) {
                                                this.overlapping.add(hop.getHopID());
                                                o.setOverlapping();
                                            }
                                            o.setDecompressing();
                                            break block51;
                                        }
                                        if (HopRewriteUtils.isBinary(hop, Types.OpOp2.RBIND)) {
                                            this.setDecompressionOnAllInputs(hop, parent);
                                            return;
                                        }
                                        if (!HopRewriteUtils.isBinary(hop, Types.OpOp2.APPLY_SCHEMA)) break block60;
                                        o = new OpNormal(hop, true);
                                        break block51;
                                    }
                                    List<Hop> in = hop.getInput();
                                    boolean ol0 = this.isOverlapping(in.get(0));
                                    boolean ol1 = this.isOverlapping(in.get(1));
                                    boolean bl = ol = ol0 || ol1;
                                    if (in.get(1).getDim1() == 1L || in.get(1).isScalar() || in.get(0).isScalar()) {
                                        if (ol && HopRewriteUtils.isBinary(hop, Types.OpOp2.PLUS, Types.OpOp2.MULT, Types.OpOp2.DIV, Types.OpOp2.MINUS)) {
                                            this.overlapping.add(hop.getHopID());
                                            o = new OpNormal(hop, true);
                                            o.setOverlapping();
                                        } else {
                                            if (ol) {
                                                if (in.get(0) == null) return;
                                                Op oo = this.treeLookup.get(in.get(0).getHopID());
                                                if (oo == null) return;
                                                oo.setDecompressing();
                                                return;
                                            }
                                            o = new OpNormal(hop, true);
                                        }
                                        if (!HopRewriteUtils.isBinarySparseSafe(hop)) {
                                            o.setDensifying();
                                        }
                                        break block51;
                                    } else {
                                        if (HopRewriteUtils.isBinaryMatrixColVectorOperation(hop)) {
                                            Hop leftIn = hop.getInput(0);
                                            Hop rightIn = hop.getInput(1);
                                            if (HopRewriteUtils.isBinary(hop, Types.OpOp2.DIV) && rightIn instanceof AggUnaryOp && leftIn == rightIn.getInput(0)) {
                                                o = new OpNormal(hop, true);
                                                break block51;
                                            } else {
                                                this.setDecompressionOnAllInputs(hop, parent);
                                                return;
                                            }
                                        }
                                        if (HopRewriteUtils.isBinaryMatrixMatrixOperation(hop) || HopRewriteUtils.isBinaryMatrixMatrixOperationWithSharedInput(hop)) {
                                            this.setDecompressionOnAllInputs(hop, parent);
                                            return;
                                        }
                                        if (!ol0 && !ol1) {
                                            String ex = "Setting decompressed because input Binary Op dimensions is unknown:\n" + Explain.explain(hop);
                                            LOG.warn((Object)ex);
                                            this.setDecompressionOnAllInputs(hop, parent);
                                            return;
                                        }
                                        this.setDecompressionOnAllInputs(hop, parent);
                                        return;
                                    }
                                }
                                if (!(hop instanceof IndexingOp)) break block61;
                                boolean isOverlapping = this.isOverlapping(hop.getInput(0));
                                o = new OpNormal(hop, true);
                                if (isOverlapping) {
                                    this.overlapping.add(hop.getHopID());
                                    o.setOverlapping();
                                }
                                break block51;
                            }
                            if (HopRewriteUtils.isTernary(hop, Types.OpOp3.MINUS_MULT, Types.OpOp3.PLUS_MULT, Types.OpOp3.QUANTILE, Types.OpOp3.CTABLE)) {
                                this.setDecompressionOnAllInputs(hop, parent);
                                return;
                            }
                            if (!HopRewriteUtils.isTernary(hop, Types.OpOp3.IFELSE)) break block62;
                            o1 = hop.getInput(1);
                            o2 = hop.getInput(2);
                            if (!this.isCompressed(o1) || !this.isCompressed(o2)) break block63;
                            o = new OpMetadata(hop, o1);
                            if (this.isOverlapping(o1) || this.isOverlapping(o2)) {
                                o.setOverlapping();
                            }
                            break block51;
                        }
                        if (!this.isCompressed(o1)) break block64;
                        o = new OpMetadata(hop, o1);
                        if (this.isOverlapping(o1)) {
                            o.setOverlapping();
                        }
                        break block51;
                    }
                    if (this.isCompressed(o2)) {
                        o = new OpMetadata(hop, o2);
                        if (this.isOverlapping(o2)) {
                            o.setOverlapping();
                        }
                        break block51;
                    } else {
                        this.setDecompressionOnAllInputs(hop, parent);
                    }
                    break block51;
                }
                if (hop instanceof ParameterizedBuiltinOp) {
                    if (!HopRewriteUtils.isParameterizedBuiltinOp(hop, Types.ParamBuiltinOp.REPLACE, Types.ParamBuiltinOp.TRANSFORMAPPLY)) {
                        LOG.warn((Object)("Unknown ParameterizedBuiltinOp Hop:" + hop.getClass().getSimpleName() + "\n" + Explain.explain(hop)));
                        this.setDecompressionOnAllInputs(hop, parent);
                        return;
                    }
                    o = new OpNormal(hop, true);
                } else {
                    if (hop instanceof NaryOp) {
                        this.setDecompressionOnAllInputs(hop, parent);
                        return;
                    }
                    if (hop instanceof ReorgOp) {
                        this.setDecompressionOnAllInputs(hop, parent);
                        return;
                    }
                    LOG.warn((Object)("Unknown Matrix Hop:" + hop.getClass().getSimpleName() + "\n" + Explain.explain(hop)));
                    this.setDecompressionOnAllInputs(hop, parent);
                    return;
                }
            }
            o = o != null ? o : new OpNormal(hop, RewriteCompressedReblock.satisfiesSizeConstraintsForCompression(hop));
            this.treeLookup.put(hop.getHopID(), o);
            parent.addOp(o);
            if (!o.isCompressedOutput()) return;
            this.compressed.add(hop.getHopID());
            return;
        }
        if (hop.getDataType().isFrame()) {
            Op o = null;
            if (HopRewriteUtils.isData(hop, Types.OpOpData.PERSISTENTREAD, Types.OpOpData.TRANSIENTREAD)) {
                return;
            }
            if (HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTWRITE, Types.OpOpData.PERSISTENTWRITE)) {
                this.transientCompressed.put(hop.getName(), hop.getInput(0).getHopID());
                this.compressed.add(hop.getHopID());
                o = new OpMetadata(hop, hop.getInput(0));
                if (this.isOverlapping(hop.getInput(0))) {
                    o.setOverlapping();
                }
            } else if (HopRewriteUtils.isUnary(hop, Types.OpOp1.DETECTSCHEMA)) {
                o = new OpNormal(hop, false);
            } else if (HopRewriteUtils.isBinary(hop, Types.OpOp2.APPLY_SCHEMA)) {
                o = new OpNormal(hop, true);
            } else {
                if (!(hop instanceof AggUnaryOp)) {
                    LOG.warn((Object)("Unknown Frame Hop:" + hop.getClass().getSimpleName() + "\n" + Explain.explain(hop)));
                    this.setDecompressionOnAllInputs(hop, parent);
                    return;
                }
                o = new OpNormal(hop, false);
            }
            o = o != null ? o : new OpNormal(hop, RewriteCompressedReblock.satisfiesSizeConstraintsForCompression(hop));
            this.treeLookup.put(hop.getHopID(), o);
            parent.addOp(o);
            if (!o.isCompressedOutput()) return;
            this.compressed.add(hop.getHopID());
            return;
        }
        if (HopRewriteUtils.isTransformEncode(hop)) {
            Hop matrix = ((FunctionOp)hop).getOutputs().get(0);
            this.compressed.add(matrix.getHopID());
            this.transientCompressed.put(matrix.getName(), matrix.getHopID());
            parent.addOp(new OpNormal(hop, true));
            return;
        }
        if (hop instanceof FunctionOp && ((FunctionOp)hop).getFunctionNamespace().equals(".builtinNS")) {
            parent.addOp(new OpNormal(hop, false));
            return;
        }
        if (!(hop instanceof AggUnaryOp)) {
            LOG.warn((Object)("Unknown Matrix or Frame Hop:" + hop.getClass().getSimpleName() + "\n" + hop.getDataType() + "\n" + Explain.explain(hop)));
            parent.addOp(new OpNormal(hop, false));
            return;
        }
        if (!(this.isOverlapping(hop.getInput().get(0)) && !HopRewriteUtils.isAggUnaryOp(hop, Types.AggOp.SUM, Types.AggOp.MEAN) || HopRewriteUtils.isAggUnaryOp(hop, Types.AggOp.TRACE))) {
            OpNormal o = new OpNormal(hop, false);
            this.treeLookup.put(hop.getHopID(), o);
            parent.addOp(o);
            return;
        }
        this.setDecompressionOnAllInputs(hop, parent);
    }

    private boolean checkTransientRead(Hop hop, Hop input) {
        if (HopRewriteUtils.isData(input, Types.OpOpData.TRANSIENTREAD)) {
            String varName = input.getName();
            StatementBlock csb = this.lineage.peek();
            StatementBlock parentStatement = (StatementBlock)this.lineage.get(this.lineage.size() - 2);
            if (parentStatement instanceof WhileStatementBlock) {
                WhileStatementBlock wsb = (WhileStatementBlock)parentStatement;
                WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
                ArrayList<StatementBlock> stmts = wstmt.getBody();
                boolean foundCurrent = false;
                for (int i = stmts.size() - 1; i >= 0; --i) {
                    StatementBlock sb = stmts.get(i);
                    if (foundCurrent && sb.variablesUpdated().containsVariable(varName)) {
                        for (Hop cand : sb.getHops()) {
                            if (!HopRewriteUtils.isData(cand, Types.OpOpData.TRANSIENTWRITE) || !cand.getName().equals(varName) || !HopRewriteUtils.isAggUnaryOp(cand.getInput(0), Types.AggOp.MIN, Types.AggOp.MAX)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (sb != csb) continue;
                    foundCurrent = true;
                }
            }
        }
        return false;
    }

    private boolean isCompressed(Hop hop) {
        return this.compressed.contains(hop.getHopID());
    }

    private void setDecompressionOnAllInputs(Hop hop, AWTreeNode parent) {
        if (parent instanceof WTreeRoot) {
            ((WTreeRoot)parent).setDecompressing();
        }
        for (Hop h : hop.getInput()) {
            Op oln;
            Op ol = this.treeLookup.get(h.getHopID());
            if (ol == null) continue;
            while (ol instanceof OpMetadata && (oln = this.treeLookup.get(((OpMetadata)ol).getParent().getHopID())) != null) {
                ol = oln;
            }
            ol.setDecompressing();
        }
    }

    private boolean isOverlapping(Hop hop) {
        Op o = this.treeLookup.get(hop.getHopID());
        if (o != null) {
            return o.isOverlapping();
        }
        return false;
    }

    private static boolean isNoOp(Hop hop) {
        return hop instanceof LiteralOp || HopRewriteUtils.isUnary(hop, Types.OpOp1.NROW, Types.OpOp1.NCOL);
    }
}

