/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.draw3d.geometry.BoundingBoxImpl;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IParaxialBoundingBox;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class ParaxialBoundingBoxImpl
extends BoundingBoxImpl
implements ParaxialBoundingBox {
    public void update(IBoundingBox i_bounds3D, IMatrix4f i_matrix) {
        if (i_bounds3D == null) {
            throw new NullPointerException("i_bounds3D must not be null");
        }
        if (i_matrix == null) {
            throw new NullPointerException("i_matrix must not be null");
        }
        Vector3f boundsLoc = Math3DCache.getVector3f();
        Vector3f boundsSize = Math3DCache.getVector3f();
        Vector3f pBoundsP0 = Math3DCache.getVector3f();
        Vector3f pBoundsP1 = Math3DCache.getVector3f();
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            i_bounds3D.getLocation(boundsLoc);
            i_bounds3D.getSize(boundsSize);
            tmp.set(boundsLoc);
            tmp.transform(i_matrix);
            pBoundsP0.set(tmp);
            pBoundsP1.set(tmp);
            tmp.set(boundsLoc.getX() + boundsSize.getX(), boundsLoc.getY() + 0.0f, boundsLoc.getZ() + 0.0f);
            this.updatePs(tmp, i_matrix, pBoundsP0, pBoundsP1);
            tmp.set(boundsLoc.getX() + 0.0f, boundsLoc.getY() + boundsSize.getY(), boundsLoc.getZ() + 0.0f);
            this.updatePs(tmp, i_matrix, pBoundsP0, pBoundsP1);
            tmp.set(boundsLoc.getX() + boundsSize.getX(), boundsLoc.getY() + boundsSize.getY(), boundsLoc.getZ() + 0.0f);
            this.updatePs(tmp, i_matrix, pBoundsP0, pBoundsP1);
            tmp.set(boundsLoc.getX() + 0.0f, boundsLoc.getY() + 0.0f, boundsLoc.getZ() + boundsSize.getZ());
            this.updatePs(tmp, i_matrix, pBoundsP0, pBoundsP1);
            tmp.set(boundsLoc.getX() + boundsSize.getX(), boundsLoc.getY() + 0.0f, boundsLoc.getZ() + boundsSize.getZ());
            this.updatePs(tmp, i_matrix, pBoundsP0, pBoundsP1);
            tmp.set(boundsLoc.getX() + 0.0f, boundsLoc.getY() + boundsSize.getY(), boundsLoc.getZ() + boundsSize.getZ());
            this.updatePs(tmp, i_matrix, pBoundsP0, pBoundsP1);
            tmp.set(boundsLoc.getX() + boundsSize.getX(), boundsLoc.getY() + boundsSize.getY(), boundsLoc.getZ() + boundsSize.getZ());
            this.updatePs(tmp, i_matrix, pBoundsP0, pBoundsP1);
            this.setLocation(pBoundsP0);
            Math3D.sub(pBoundsP1, pBoundsP0, pBoundsP1);
            this.setSize(pBoundsP1);
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(boundsLoc, boundsSize, pBoundsP0, pBoundsP1, tmp);
            throw throwable;
        }
        Math3DCache.returnVector3f(boundsLoc, boundsSize, pBoundsP0, pBoundsP1, tmp);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float intersectRay(IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        float f;
        Iterator iterator;
        Vector3f start = Math3DCache.getVector3f();
        Vector3f end = Math3DCache.getVector3f();
        Vector3f planePoint = Math3DCache.getVector3f();
        Vector3f intersection = Math3DCache.getVector3f();
        try {
            this.getLocation(start);
            this.getEnd(end);
            boolean inside = Math3D.in(start.getX(), end.getX(), i_rayOrigin.getX()) && Math3D.in(start.getY(), end.getY(), i_rayOrigin.getY()) && Math3D.in(start.getZ(), end.getZ(), i_rayOrigin.getZ());
            LinkedList<Side> candidates = new LinkedList<Side>();
            float cos = Math3D.dot(Side.FRONT.getNormal(), i_rayDirection);
            if (inside) {
                cos *= -1.0f;
            }
            if (cos < 0.0f) {
                candidates.add(Side.FRONT);
            } else if (cos > 0.0f) {
                candidates.add(Side.BACK);
            }
            cos = Math3D.dot(Side.LEFT.getNormal(), i_rayDirection);
            if (inside) {
                cos *= -1.0f;
            }
            if (cos < 0.0f) {
                candidates.add(Side.LEFT);
            } else if (cos > 0.0f) {
                candidates.add(Side.RIGHT);
            }
            cos = Math3D.dot(Side.TOP.getNormal(), i_rayDirection);
            if (inside) {
                cos *= -1.0f;
            }
            if (cos < 0.0f) {
                candidates.add(Side.TOP);
            } else if (cos > 0.0f) {
                candidates.add(Side.BOTTOM);
            }
            iterator = candidates.iterator();
            boolean bl = true;
            while (true) {
                if (bl && !(bl = false)) {
                    if (true) break block17;
                }
                Side candidate = (Side)((Object)iterator.next());
                IVector3f planeNormal = candidate.getNormal();
                candidate.getPoint(this, planePoint);
                float d = Math3D.rayIntersectsPlane(i_rayOrigin, i_rayDirection, planePoint, planeNormal);
                if (Float.isNaN(d) || !(d > 0.0f)) break block17;
                intersection.set(i_rayDirection);
                intersection.scale(d);
                Math3D.add(i_rayOrigin, intersection, intersection);
                if (!candidate.contains(this, intersection)) break block17;
                f = d;
                break;
            }
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(start, end, planePoint, intersection);
            throw throwable;
        }
        {
            block17: {
                Math3DCache.returnVector3f(start, end, planePoint, intersection);
                return f;
            }
            if (iterator.hasNext()) continue;
        }
        Math3DCache.returnVector3f(start, end, planePoint, intersection);
        return Float.NaN;
    }

    public boolean union(IParaxialBoundingBox i_paraxialBoundingBox) {
        boolean bl;
        if (i_paraxialBoundingBox == null) {
            throw new NullPointerException("i_paraxialBoundingBox must not be null");
        }
        Vector3f myPos = Math3DCache.getVector3f();
        Vector3f myEnd = Math3DCache.getVector3f();
        Vector3f myOldEnd = Math3DCache.getVector3f();
        Vector3f theirPos = Math3DCache.getVector3f();
        Vector3f theirEnd = Math3DCache.getVector3f();
        try {
            this.getLocation(myPos);
            i_paraxialBoundingBox.getLocation(theirPos);
            i_paraxialBoundingBox.getEnd(theirEnd);
            this.getEnd(myEnd);
            myOldEnd.set(myEnd);
            Math3D.min(myPos, theirPos, this.m_position);
            Math3D.max(myOldEnd, theirEnd, myEnd);
            this.setEnd(myEnd);
            bl = !myPos.equals(this.m_position) || !myOldEnd.equals(myEnd);
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(myPos, myEnd, myOldEnd, theirPos, theirEnd);
            throw throwable;
        }
        Math3DCache.returnVector3f(myPos, myEnd, myOldEnd, theirPos, theirEnd);
        return bl;
    }

    private void updatePs(Vector3f io_tmp, IMatrix4f i_modelMatrix, Vector3f io_p0, Vector3f io_p1) {
        io_tmp.transform(i_modelMatrix);
        Math3D.min(io_p0, io_tmp, io_p0);
        Math3D.max(io_p1, io_tmp, io_p1);
    }

    public boolean contains(IVector3f i_point) {
        boolean bl;
        Vector3f start = Math3DCache.getVector3f();
        Vector3f end = Math3DCache.getVector3f();
        try {
            this.getLocation(start);
            this.getEnd(end);
            bl = Math3D.in(start.getX(), end.getX(), i_point.getX()) && Math3D.in(start.getY(), end.getY(), i_point.getY()) && Math3D.in(start.getZ(), end.getZ(), i_point.getZ());
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(start, end);
            throw throwable;
        }
        Math3DCache.returnVector3f(start, end);
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Side {
        BACK,
        BOTTOM,
        FRONT,
        LEFT,
        RIGHT,
        TOP;

        private static final Vector3f N_BACK;
        private static final Vector3f N_BOTTOM;
        private static final Vector3f N_FRONT;
        private static final Vector3f N_LEFT;
        private static final Vector3f N_RIGHT;
        private static final Vector3f N_TOP;

        static {
            N_BACK = new Vector3fImpl(-1.0f, 0.0f, 0.0f);
            N_BOTTOM = new Vector3fImpl(0.0f, 0.0f, -1.0f);
            N_FRONT = new Vector3fImpl(1.0f, 0.0f, 0.0f);
            N_LEFT = new Vector3fImpl(0.0f, -1.0f, 0.0f);
            N_RIGHT = new Vector3fImpl(0.0f, 1.0f, 0.0f);
            N_TOP = new Vector3fImpl(0.0f, 0.0f, 1.0f);
        }

        /*
         * Exception decompiling
         */
        public boolean contains(IParaxialBoundingBox i_box, IVector3f i_point) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public IVector3f getNormal() {
            switch (this) {
                case LEFT: {
                    return N_LEFT;
                }
                case BACK: {
                    return N_BACK;
                }
                case BOTTOM: {
                    return N_BOTTOM;
                }
                case FRONT: {
                    return N_FRONT;
                }
                case RIGHT: {
                    return N_RIGHT;
                }
                case TOP: {
                    return N_TOP;
                }
            }
            return null;
        }

        public void getPoint(IParaxialBoundingBox i_box, Vector3f o_result) {
            switch (this) {
                case BACK: 
                case BOTTOM: 
                case LEFT: {
                    i_box.getLocation(o_result);
                    break;
                }
                case FRONT: 
                case RIGHT: 
                case TOP: {
                    i_box.getEnd(o_result);
                }
            }
        }
    }
}

