/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.cli.CLIInfo;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class CLIUtil {
    public static final String JSON_OPTION = "--json";
    private static final String INSTALLER_DIR = "installerWorkDir";
    private static final Map<PlatformUtil.OperatingSystem, String> cwctlMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final Map<PlatformUtil.OperatingSystem, String> appsodyMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final CLIInfo codewindInfo;
    private static final CLIInfo appsodyInfo;
    private static final CLIInfo[] cliInfos;

    public static Process runCWCTL(String cmd, String ... options) throws IOException {
        for (int i = 0; i < cliInfos.length; ++i) {
            if (cliInfos[i] == null) continue;
            cliInfos[i].setInstallPath(CLIUtil.getCLIExecutable(cliInfos[i]));
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(codewindInfo.getInstallPath());
        cmdList.add(cmd);
        if (options != null) {
            for (String option : options) {
                cmdList.add(option);
            }
        }
        String[] command = cmdList.toArray(new String[cmdList.size()]);
        ProcessBuilder builder = new ProcessBuilder(command);
        if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.MAC) {
            String pathVar = System.getenv("PATH");
            pathVar = "/usr/local/bin:" + pathVar;
            Map<String, String> env = builder.environment();
            env.put("PATH", pathVar);
        }
        return builder.start();
    }

    public static String getCWCTLExecutable() throws IOException {
        return CLIUtil.getCLIExecutable(codewindInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCLIExecutable(CLIInfo operation) throws IOException {
        String installPath = operation.getInstallPath();
        if (installPath != null && new File(installPath).exists()) {
            return installPath;
        }
        PlatformUtil.OperatingSystem os = PlatformUtil.getOS(System.getProperty("os.name"));
        Map<PlatformUtil.OperatingSystem, String> osPathMap = operation.getOSPathMap();
        if (osPathMap == null) {
            String msg = "Failed to get the list of operating specific paths for installing the executable " + operation.getInstallName();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String relPath = osPathMap.get((Object)os);
        if (relPath == null) {
            String msg = "Failed to get the relative path for the install executable " + operation.getInstallName();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String installerDir = CLIUtil.getCLIInstallDir();
        String execName = relPath.substring(relPath.lastIndexOf(47) + 1);
        String execPath = installerDir + File.separator + execName;
        if (!FileUtil.makeDir(installerDir)) {
            String msg = "Failed to make the directory for the installer utility: " + installerDir;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        InputStream stream = null;
        try {
            stream = FileLocator.openStream((Bundle)CodewindCorePlugin.getDefault().getBundle(), (IPath)new Path(relPath), (boolean)false);
            FileUtil.copyFile(stream, execPath);
            if (PlatformUtil.getOS() != PlatformUtil.OperatingSystem.WINDOWS) {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                File file = new File(execPath);
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            String string = execPath;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getCLIInstallDir() {
        IPath stateLoc = CodewindCorePlugin.getDefault().getStateLocation();
        return stateLoc.append(INSTALLER_DIR).toOSString();
    }

    static {
        cwctlMap.put(PlatformUtil.OperatingSystem.LINUX, "binaries/linux/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.MAC, "binaries/darwin/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.WINDOWS, "binaries/windows/cwctl.exe");
        appsodyMap.put(PlatformUtil.OperatingSystem.LINUX, "binaries/linux/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.MAC, "binaries/darwin/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.WINDOWS, "binaries/windows/appsody.exe");
        codewindInfo = new CLIInfo("Codewind", cwctlMap);
        appsodyInfo = new CLIInfo("Appsody", appsodyMap);
        cliInfos = new CLIInfo[]{codewindInfo, appsodyInfo};
    }
}

