"use strict";
/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const we = require("./WatchEventEntry");
/**
 * Simple representation of a single change: the file/dir path that changed,
 * what type of change, and when. These are then consumed by the batch
 * processing utility.
 */
class ChangedFileEntry {
    constructor(path, type, timestamp, directory) {
        if (!path || !type || timestamp < 0) {
            throw new Error("Invalid parameter '" + path + "' '" + type + "' '" + timestamp + "'");
        }
        this._eventType = type;
        this._path = path;
        this._timestamp = timestamp;
        this._directory = directory;
    }
    toJson() {
        const result = {
            directory: this._directory,
            path: this._path,
            timestamp: this._timestamp,
            type: we.eventTypetoString(this._eventType),
        };
        return result;
    }
    get timestamp() {
        return this._timestamp;
    }
    get eventType() {
        return this._eventType;
    }
    get path() {
        return this._path;
    }
    get directory() {
        return this._directory;
    }
}
exports.ChangedFileEntry = ChangedFileEntry;
