/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { PostQueueChunkGroup } from "./PostQueueChunkGroup";
/**
 * A large number of file changes will be split into 'bite-sized pieces' called
 * chunks. Each chunk communicates a subset of the full change list.
 *
 * Instances of this class are immutable.
 */
export declare class PostQueueChunk {
    private readonly _projectId;
    private readonly _timestamp;
    private readonly _base64Compressed;
    /** The ID of a chunk will be 1 <= id <= chunkTotal */
    private readonly _chunkId;
    /** The total # of chunks that will e sent for this project id and timestamp. */
    private readonly _chunkTotal;
    private readonly _parentGroup;
    constructor(projectId: string, timestamp: number, base64Compressed: string, chunkId: number, chunkTotal: number, parentGroup: PostQueueChunkGroup);
    readonly projectId: string;
    readonly timestamp: number;
    readonly base64Compressed: string;
    readonly chunkId: number;
    readonly chunkTotal: number;
    readonly parentGroup: PostQueueChunkGroup;
}
