/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.Field;
import org.eclipse.comma.expressions.expression.Pair;
import org.eclipse.comma.expressions.expression.QUANTIFIER;
import org.eclipse.comma.expressions.expression.impl.TypeReferenceImpl;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.CommaUtilities;

public class EVariable {
    public final EVariableType type;
    public final String subtype;
    public final Object value;

    public EVariable(EVariableType type, Object value, String subtype) {
        this.type = type;
        this.subtype = subtype;
        this.value = value;
    }

    public EVariable clone(Object newValue) {
        return new EVariable(this.type, newValue, this.subtype);
    }

    private static Object getDefaultValue(EVariableType type) {
        if (type == EVariableType.STRING) {
            return "";
        }
        if (type == EVariableType.BOOL) {
            return true;
        }
        if (type == EVariableType.INT) {
            return 0L;
        }
        if (type == EVariableType.REAL) {
            return 0.0;
        }
        if (type == EVariableType.ENUM) {
            return null;
        }
        if (type == EVariableType.ANY) {
            return null;
        }
        if (type == EVariableType.RECORD) {
            return null;
        }
        if (type == EVariableType.VECTOR) {
            return null;
        }
        if (type == EVariableType.MAP) {
            return null;
        }
        if (type == EVariableType.CONNECTION) {
            return null;
        }
        throw new RuntimeException("Not supported");
    }

    public static EVariable fromType(Object type) {
        EVariableType variableType = null;
        String subType = null;
        if (type instanceof EnumTypeDecl) {
            variableType = EVariableType.ENUM;
            subType = CommaUtilities.getFullyQualifiedName((NamedElement)((EnumTypeDecl)type)).toString();
        } else if (type instanceof RecordTypeDecl) {
            variableType = EVariableType.RECORD;
            subType = CommaUtilities.getFullyQualifiedName((NamedElement)((RecordTypeDecl)type)).toString();
        } else if (type instanceof VectorTypeDecl) {
            variableType = EVariableType.VECTOR;
            subType = CommaUtilities.getFullyQualifiedName((NamedElement)((VectorTypeDecl)type)).toString();
        } else if (type instanceof MapTypeDecl) {
            variableType = EVariableType.MAP;
            subType = CommaUtilities.getFullyQualifiedName((NamedElement)((MapTypeDecl)type)).toString();
        } else {
            if (type instanceof TypeReferenceImpl) {
                return EVariable.fromType(((TypeReferenceImpl)type).getType());
            }
            if (type instanceof SimpleTypeDecl) {
                SimpleTypeDecl simpelType = ((SimpleTypeDecl)type).getBase();
                if (simpelType == null) {
                    simpelType = (SimpleTypeDecl)type;
                }
                String simpleType = simpelType.getName().toUpperCase();
                try {
                    variableType = simpleType.equals("ID") ? EVariableType.CONNECTION : EVariableType.valueOf(simpleType);
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("Type '%s' not supported", simpleType));
                }
            } else {
                throw new RuntimeException("Not supported");
            }
        }
        return new EVariable(variableType, EVariable.getDefaultValue(variableType), subType);
    }

    public static EVariable fromExpression(Expression expression, EVariableCollection variables) {
        return EVariable.fromExpression(expression, variables, null);
    }

    public static EVariable fromExpression(Expression expression, EVariableCollection variables, BiFunction<Expression, EVariableCollection, EVariable> notSupportedCallback) {
        if (expression instanceof ExpressionEnumLiteral) {
            ExpressionEnumLiteral e = (ExpressionEnumLiteral)expression;
            return new EVariable(EVariableType.ENUM, e.getLiteral().getName(), CommaUtilities.getFullyQualifiedName((NamedElement)e.getType()).toString());
        }
        if (expression instanceof ExpressionVariable) {
            ExpressionVariable e = (ExpressionVariable)expression;
            String name = e.getVariable().getName();
            return variables.get(name);
        }
        if (expression instanceof ExpressionConstantInt) {
            ExpressionConstantInt e = (ExpressionConstantInt)expression;
            return new EVariable(EVariableType.INT, e.getValue(), null);
        }
        if (expression instanceof ExpressionConstantReal) {
            ExpressionConstantReal e = (ExpressionConstantReal)expression;
            return new EVariable(EVariableType.REAL, e.getValue(), null);
        }
        if (expression instanceof ExpressionConstantString) {
            ExpressionConstantString e = (ExpressionConstantString)expression;
            return new EVariable(EVariableType.STRING, e.getValue(), null);
        }
        if (expression instanceof ExpressionConstantBool) {
            ExpressionConstantBool e = (ExpressionConstantBool)expression;
            return new EVariable(EVariableType.BOOL, e.isValue(), null);
        }
        if (expression instanceof ExpressionAny) {
            return new EVariable(EVariableType.ANY, null, null);
        }
        if (expression instanceof ExpressionRecord) {
            ExpressionRecord e = (ExpressionRecord)expression;
            LinkedHashMap<String, EVariable> map = new LinkedHashMap<String, EVariable>();
            for (Field field : e.getFields()) {
                map.put(field.getRecordField().getName(), EVariable.fromExpression(field.getExp(), null, notSupportedCallback));
            }
            return new EVariable(EVariableType.RECORD, map, CommaUtilities.getFullyQualifiedName((NamedElement)e.getType()).toString());
        }
        if (expression instanceof ExpressionVector) {
            ExpressionVector e = (ExpressionVector)expression;
            Vector<EVariable> vec = new Vector<EVariable>();
            for (Expression exp : e.getElements()) {
                vec.add(EVariable.fromExpression(exp, null, notSupportedCallback));
            }
            return new EVariable(EVariableType.VECTOR, vec, CommaUtilities.getFullyQualifiedName((NamedElement)e.getTypeAnnotation().getType().getType()).toString());
        }
        if (expression instanceof ExpressionMap) {
            ExpressionMap e = (ExpressionMap)expression;
            LinkedHashMap<EVariable, EVariable> map = new LinkedHashMap<EVariable, EVariable>();
            for (Pair p : e.getPairs()) {
                EVariable key = EVariable.fromExpression(p.getKey(), variables, notSupportedCallback);
                EVariable value = EVariable.fromExpression(p.getValue(), variables, notSupportedCallback);
                map.put(key, value);
            }
            return new EVariable(EVariableType.MAP, map, CommaUtilities.getFullyQualifiedName((NamedElement)e.getTypeAnnotation().getType().getType()).toString());
        }
        if (expression instanceof ExpressionAddition) {
            EVariable left = EVariable.fromExpression(((ExpressionAddition)expression).getLeft(), variables, notSupportedCallback);
            EVariable right = EVariable.fromExpression(((ExpressionAddition)expression).getRight(), variables, notSupportedCallback);
            return EVariable.computeVariable(left, right, expression);
        }
        if (expression instanceof ExpressionSubtraction) {
            EVariable left = EVariable.fromExpression(((ExpressionSubtraction)expression).getLeft(), variables, notSupportedCallback);
            EVariable right = EVariable.fromExpression(((ExpressionSubtraction)expression).getRight(), variables, notSupportedCallback);
            return EVariable.computeVariable(left, right, expression);
        }
        if (expression instanceof ExpressionMultiply) {
            EVariable left = EVariable.fromExpression(((ExpressionMultiply)expression).getLeft(), variables, notSupportedCallback);
            EVariable right = EVariable.fromExpression(((ExpressionMultiply)expression).getRight(), variables, notSupportedCallback);
            return EVariable.computeVariable(left, right, expression);
        }
        if (expression instanceof ExpressionDivision) {
            EVariable left = EVariable.fromExpression(((ExpressionDivision)expression).getLeft(), variables, notSupportedCallback);
            EVariable right = EVariable.fromExpression(((ExpressionDivision)expression).getRight(), variables, notSupportedCallback);
            return EVariable.computeVariable(left, right, expression);
        }
        if (expression instanceof ExpressionMapRW) {
            ExpressionMapRW e = (ExpressionMapRW)expression;
            EVariable map = EVariable.fromExpression(e.getMap(), variables, notSupportedCallback);
            EVariable key = EVariable.fromExpression(e.getKey(), variables, notSupportedCallback);
            if (e.getValue() == null) {
                for (Map.Entry<EVariable, EVariable> entry : map.getValueMap().entrySet()) {
                    if (!entry.getKey().value.equals(key.value)) continue;
                    return entry.getValue();
                }
                if (e.getKey() instanceof ExpressionConstantString) {
                    return new EVariable(EVariableType.STRING, EVariable.getDefaultValue(EVariableType.STRING), null);
                }
                if (e.getKey() instanceof ExpressionConstantBool) {
                    return new EVariable(EVariableType.BOOL, EVariable.getDefaultValue(EVariableType.BOOL), null);
                }
                if (e.getKey() instanceof ExpressionConstantInt) {
                    return new EVariable(EVariableType.INT, EVariable.getDefaultValue(EVariableType.INT), null);
                }
                if (e.getKey() instanceof ExpressionConstantReal) {
                    return new EVariable(EVariableType.REAL, EVariable.getDefaultValue(EVariableType.REAL), null);
                }
                throw new Error(String.format("Key not in map and no default value for '%s'", e.getKey().toString()));
            }
            EVariable value = EVariable.fromExpression(e.getValue(), variables, notSupportedCallback);
            LinkedHashMap<EVariable, EVariable> newMap = new LinkedHashMap<EVariable, EVariable>();
            for (Map.Entry<EVariable, EVariable> entry : map.getValueMap().entrySet()) {
                if (entry.getKey().value.equals(key.value)) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            newMap.put(key, value);
            return new EVariable(map.type, newMap, map.subtype);
        }
        if (expression instanceof ExpressionRecordAccess) {
            ExpressionRecordAccess e = (ExpressionRecordAccess)expression;
            EVariable map = EVariable.fromExpression(e.getRecord(), variables, notSupportedCallback);
            String field = e.getField().getName();
            return map.getValueRecord().get(field);
        }
        if (expression instanceof ExpressionFunctionCall) {
            ExpressionFunctionCall e = (ExpressionFunctionCall)expression;
            if (e.getFunctionName().equals("size")) {
                EVariable vector = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                return new EVariable(EVariableType.INT, vector.getValueVector().size(), null);
            }
            if (e.getFunctionName().equals("contains")) {
                EVariable vector = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                EVariable containsItem = EVariable.fromExpression((Expression)e.getArgs().get(1), variables, notSupportedCallback);
                boolean contains = false;
                for (EVariable item : vector.getValueVector()) {
                    if (!item.value.equals(containsItem.value) || item.type != containsItem.type) continue;
                    contains = true;
                }
                return new EVariable(EVariableType.BOOL, contains, null);
            }
            if (e.getFunctionName().equals("isEmtpy")) {
                EVariable vector = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                return new EVariable(EVariableType.BOOL, vector.getValueVector().size() == 0, null);
            }
            if (e.getFunctionName().equals("add")) {
                EVariable vector = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                EVariable toAdd = EVariable.fromExpression((Expression)e.getArgs().get(1), variables, notSupportedCallback);
                Vector<EVariable> newValue = new Vector<EVariable>(vector.getValueVector());
                newValue.add(toAdd);
                return vector.clone(newValue);
            }
            if (e.getFunctionName().equals("abs")) {
                EVariable value = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                if (value.type == EVariableType.INT) {
                    return new EVariable(EVariableType.INT, Math.abs(value.getValueInt()), null);
                }
                return new EVariable(EVariableType.REAL, Math.abs(value.getValueReal()), null);
            }
            if (e.getFunctionName().equals("asReal")) {
                EVariable value = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                if (value.type == EVariableType.INT) {
                    return new EVariable(EVariableType.REAL, value.getValueInt(), null);
                }
                return new EVariable(EVariableType.REAL, value.getValueReal(), null);
            }
            if (e.getFunctionName().equals("deleteKey")) {
                EVariable map = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                EVariable key = EVariable.fromExpression((Expression)e.getArgs().get(1), variables, notSupportedCallback);
                LinkedHashMap<EVariable, EVariable> newMap = new LinkedHashMap<EVariable, EVariable>();
                for (Map.Entry<EVariable, EVariable> entry : map.getValueMap().entrySet()) {
                    if (entry.getKey().value.equals(key.value)) continue;
                    newMap.put(entry.getKey(), entry.getValue());
                }
                return new EVariable(map.type, newMap, map.subtype);
            }
            if (e.getFunctionName().equals("hasKey")) {
                EVariable map = EVariable.fromExpression((Expression)e.getArgs().get(0), variables, notSupportedCallback);
                EVariable key = EVariable.fromExpression((Expression)e.getArgs().get(1), variables, notSupportedCallback);
                boolean hasValue = false;
                for (Map.Entry<EVariable, EVariable> entry : map.getValueMap().entrySet()) {
                    if (!entry.getKey().value.equals(key.value)) continue;
                    hasValue = true;
                    break;
                }
                return new EVariable(EVariableType.BOOL, hasValue, null);
            }
        } else if (expression instanceof ExpressionQuantifier) {
            ExpressionQuantifier e = (ExpressionQuantifier)expression;
            if (e.getQuantifier() == QUANTIFIER.DELETE) {
                EVariable collection = EVariable.fromExpression(e.getCollection(), variables, notSupportedCallback);
                List newValue = collection.getValueVector().stream().filter(v -> {
                    EVariableCollection localVariables = variables.clone();
                    localVariables.add(e.getIterator().getName(), (EVariable)v);
                    return !EVariable.fromExpression(e.getCondition(), localVariables, notSupportedCallback).getValueBool();
                }).collect(Collectors.toList());
                return collection.clone(new Vector(newValue));
            }
            if (e.getQuantifier() == QUANTIFIER.EXISTS) {
                EVariable collection = EVariable.fromExpression(e.getCollection(), variables, notSupportedCallback);
                boolean exists = collection.getValueVector().stream().anyMatch(v -> {
                    EVariableCollection localVariables = variables.clone();
                    localVariables.add(e.getIterator().getName(), (EVariable)v);
                    return EVariable.fromExpression(e.getCondition(), localVariables, notSupportedCallback).getValueBool();
                });
                return new EVariable(EVariableType.BOOL, exists, null);
            }
            if (e.getQuantifier() == QUANTIFIER.FORALL) {
                EVariable collection = EVariable.fromExpression(e.getCollection(), variables, notSupportedCallback);
                boolean allMatch = collection.getValueVector().stream().allMatch(v -> {
                    EVariableCollection localVariables = variables.clone();
                    localVariables.add(e.getIterator().getName(), (EVariable)v);
                    return EVariable.fromExpression(e.getCondition(), localVariables, notSupportedCallback).getValueBool();
                });
                return new EVariable(EVariableType.BOOL, allMatch, null);
            }
        } else {
            if (expression instanceof ExpressionModulo) {
                EVariable left = EVariable.fromExpression(((ExpressionModulo)expression).getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(((ExpressionModulo)expression).getRight(), variables, notSupportedCallback);
                return EVariable.computeVariable(left, right, expression);
            }
            if (expression instanceof ExpressionMinimum) {
                EVariable left = EVariable.fromExpression(((ExpressionMinimum)expression).getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(((ExpressionMinimum)expression).getRight(), variables, notSupportedCallback);
                return EVariable.computeVariable(left, right, expression);
            }
            if (expression instanceof ExpressionMaximum) {
                EVariable left = EVariable.fromExpression(((ExpressionMaximum)expression).getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(((ExpressionMaximum)expression).getRight(), variables, notSupportedCallback);
                return EVariable.computeVariable(left, right, expression);
            }
            if (expression instanceof ExpressionPower) {
                EVariable left = EVariable.fromExpression(((ExpressionPower)expression).getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(((ExpressionPower)expression).getRight(), variables, notSupportedCallback);
                return EVariable.computeVariable(left, right, expression);
            }
            if (expression instanceof ExpressionLess) {
                ExpressionLess e = (ExpressionLess)expression;
                EVariable left = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(e.getRight(), variables, notSupportedCallback);
                return new EVariable(EVariableType.BOOL, EVariable.compareVariables(left, right, (Expression)e), null);
            }
            if (expression instanceof ExpressionGreater) {
                ExpressionGreater e = (ExpressionGreater)expression;
                EVariable left = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(e.getRight(), variables, notSupportedCallback);
                return new EVariable(EVariableType.BOOL, EVariable.compareVariables(left, right, (Expression)e), null);
            }
            if (expression instanceof ExpressionLeq) {
                ExpressionLeq e = (ExpressionLeq)expression;
                EVariable left = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(e.getRight(), variables, notSupportedCallback);
                return new EVariable(EVariableType.BOOL, EVariable.compareVariables(left, right, (Expression)e), null);
            }
            if (expression instanceof ExpressionGeq) {
                ExpressionGeq e = (ExpressionGeq)expression;
                EVariable left = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(e.getRight(), variables, notSupportedCallback);
                return new EVariable(EVariableType.BOOL, EVariable.compareVariables(left, right, (Expression)e), null);
            }
            if (expression instanceof ExpressionEqual) {
                ExpressionEqual e = (ExpressionEqual)expression;
                EVariable left = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(e.getRight(), variables, notSupportedCallback);
                if (left.type == right.type) {
                    return new EVariable(EVariableType.BOOL, left.value.equals(right.value), null);
                }
            } else if (expression instanceof ExpressionNEqual) {
                ExpressionNEqual e = (ExpressionNEqual)expression;
                EVariable left = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback);
                EVariable right = EVariable.fromExpression(e.getRight(), variables, notSupportedCallback);
                if (left.type == right.type) {
                    return new EVariable(EVariableType.BOOL, !left.value.equals(right.value), null);
                }
            } else if (expression instanceof ExpressionVariable) {
                ExpressionVariable e = (ExpressionVariable)expression;
                EVariable variable = EVariable.fromExpression((Expression)e, variables, notSupportedCallback);
                if (variable.type == EVariableType.BOOL) {
                    return new EVariable(EVariableType.BOOL, variable.getValueBool(), null);
                }
            } else {
                if (expression instanceof ExpressionAnd) {
                    ExpressionAnd e = (ExpressionAnd)expression;
                    boolean result = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback).getValueBool() && EVariable.fromExpression(e.getRight(), variables, notSupportedCallback).getValueBool();
                    return new EVariable(EVariableType.BOOL, result, null);
                }
                if (expression instanceof ExpressionOr) {
                    ExpressionOr e = (ExpressionOr)expression;
                    boolean result = EVariable.fromExpression(e.getLeft(), variables, notSupportedCallback).getValueBool() || EVariable.fromExpression(e.getRight(), variables, notSupportedCallback).getValueBool();
                    return new EVariable(EVariableType.BOOL, result, null);
                }
                if (expression instanceof ExpressionNot) {
                    ExpressionNot e = (ExpressionNot)expression;
                    boolean result = !EVariable.fromExpression(e.getSub(), variables, notSupportedCallback).getValueBool();
                    return new EVariable(EVariableType.BOOL, result, null);
                }
                if (expression instanceof ExpressionMinus) {
                    ExpressionMinus e = (ExpressionMinus)expression;
                    EVariable result = EVariable.fromExpression(e.getSub(), variables, notSupportedCallback);
                    if (result.type == EVariableType.INT) {
                        return result.clone(result.getValueInt() * -1L);
                    }
                    if (result.type == EVariableType.REAL) {
                        return result.clone(result.getValueReal() * -1.0);
                    }
                } else {
                    if (expression instanceof ExpressionPlus) {
                        ExpressionPlus e = (ExpressionPlus)expression;
                        EVariable result = EVariable.fromExpression(e.getSub(), variables, notSupportedCallback);
                        return result.clone(result.value);
                    }
                    if (expression instanceof ExpressionBracket) {
                        ExpressionBracket e = (ExpressionBracket)expression;
                        return EVariable.fromExpression(e.getSub(), variables, notSupportedCallback);
                    }
                }
            }
        }
        if (notSupportedCallback != null) {
            return notSupportedCallback.apply(expression, variables);
        }
        throw new RuntimeException("Not supported");
    }

    private static boolean compareVariables(EVariable left, EVariable right, Expression e) {
        if (left.type == EVariableType.INT && right.type == EVariableType.INT) {
            if (e instanceof ExpressionLess) {
                return left.getValueInt() < right.getValueInt();
            }
            if (e instanceof ExpressionGreater) {
                return left.getValueInt() > right.getValueInt();
            }
            if (e instanceof ExpressionLeq) {
                return left.getValueInt() <= right.getValueInt();
            }
            if (e instanceof ExpressionGeq) {
                return left.getValueInt() >= right.getValueInt();
            }
        } else if (left.type == EVariableType.REAL && right.type == EVariableType.REAL) {
            if (e instanceof ExpressionLess) {
                return left.getValueReal() < right.getValueReal();
            }
            if (e instanceof ExpressionGreater) {
                return left.getValueReal() > right.getValueReal();
            }
            if (e instanceof ExpressionLeq) {
                return left.getValueReal() <= right.getValueReal();
            }
            if (e instanceof ExpressionGeq) {
                return left.getValueReal() >= right.getValueReal();
            }
        }
        throw new RuntimeException("Not supported");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EVariable computeVariable(EVariable left, EVariable right, Expression e) {
        void var3_19;
        Object var3_3 = null;
        if (left.type == EVariableType.INT && right.type == EVariableType.INT) {
            if (e instanceof ExpressionAddition) {
                Long l = left.getValueInt() + right.getValueInt();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionSubtraction) {
                Long l = left.getValueInt() - right.getValueInt();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionMultiply) {
                Long l = left.getValueInt() * right.getValueInt();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionDivision) {
                Long l = left.getValueInt() / right.getValueInt();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionModulo) {
                Long l = Math.floorMod(left.getValueInt(), right.getValueInt());
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionMinimum) {
                Long l = Math.min(left.getValueInt(), right.getValueInt());
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionMaximum) {
                Long l = Math.max(left.getValueInt(), right.getValueInt());
                return new EVariable(left.type, var3_19, left.subtype);
            } else {
                if (!(e instanceof ExpressionPower)) throw new RuntimeException("Not supported");
                Long l = (long)Math.pow(left.getValueInt(), right.getValueInt());
            }
            return new EVariable(left.type, var3_19, left.subtype);
        } else {
            if (left.type != EVariableType.REAL || right.type != EVariableType.REAL) throw new RuntimeException("Not supported");
            if (e instanceof ExpressionAddition) {
                Double d = left.getValueReal() + right.getValueReal();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionSubtraction) {
                Double d = left.getValueReal() - right.getValueReal();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionMultiply) {
                Double d = left.getValueReal() * right.getValueReal();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionDivision) {
                Double d = left.getValueReal() / right.getValueReal();
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionMinimum) {
                Double d = Math.min(left.getValueReal(), right.getValueReal());
                return new EVariable(left.type, var3_19, left.subtype);
            } else if (e instanceof ExpressionMaximum) {
                Double d = Math.max(left.getValueReal(), right.getValueReal());
                return new EVariable(left.type, var3_19, left.subtype);
            } else {
                if (!(e instanceof ExpressionPower)) throw new RuntimeException("Not supported");
                Double d = Math.pow(left.getValueReal(), right.getValueReal());
            }
        }
        return new EVariable(left.type, var3_19, left.subtype);
    }

    public long getValueInt() {
        if (this.type != EVariableType.INT) {
            throw new RuntimeException(String.format("Value not a INT but %s", this.type.toString()));
        }
        return (Long)this.value;
    }

    public EConnection getValueConnection() {
        if (this.type != EVariableType.CONNECTION) {
            throw new RuntimeException(String.format("Value not a CONNECTION but %s", this.type.toString()));
        }
        return (EConnection)this.value;
    }

    public double getValueReal() {
        if (this.type != EVariableType.REAL) {
            throw new RuntimeException(String.format("Value not a REAL but %s", this.type.toString()));
        }
        return (Double)this.value;
    }

    public boolean getValueBool() {
        if (this.type != EVariableType.BOOL) {
            throw new RuntimeException(String.format("Value not a BOOL but %s", this.type.toString()));
        }
        return (Boolean)this.value;
    }

    public String getValueString() {
        if (this.type != EVariableType.STRING) {
            throw new RuntimeException(String.format("Value not a STRING but %s", this.type.toString()));
        }
        return (String)this.value;
    }

    public Vector<EVariable> getValueVector() {
        if (this.type != EVariableType.VECTOR) {
            throw new RuntimeException(String.format("Value not a VECTOR but %s", this.type.toString()));
        }
        return (Vector)this.value;
    }

    public Map<String, EVariable> getValueRecord() {
        if (this.type != EVariableType.RECORD) {
            throw new RuntimeException(String.format("Value not a RECORD but %s", this.type.toString()));
        }
        return (Map)this.value;
    }

    public Map<EVariable, EVariable> getValueMap() {
        if (this.type != EVariableType.MAP) {
            throw new RuntimeException(String.format("Value not a MAP but %s", this.type.toString()));
        }
        return (Map)this.value;
    }

    public boolean equals(Object obj) {
        if (this.type == EVariableType.RECORD || this.type == EVariableType.MAP || this.type == EVariableType.VECTOR) {
            throw new RuntimeException("Not implemented");
        }
        EVariable other = (EVariable)obj;
        return this.type == other.type && Objects.equals(this.subtype, other.subtype) && Objects.equals(this.value, other.value);
    }
}

