/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.component.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.VariableDeclBlock;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentModel;
import org.eclipse.comma.behavior.component.component.ComponentPackage;
import org.eclipse.comma.behavior.component.component.ComponentPart;
import org.eclipse.comma.behavior.component.component.Connection;
import org.eclipse.comma.behavior.component.component.EventReception;
import org.eclipse.comma.behavior.component.component.ExpressionConnectionState;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.FunctionalConstraintsBlock;
import org.eclipse.comma.behavior.component.component.PortAwareEvent;
import org.eclipse.comma.behavior.component.component.PortReference;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.component.validation.AbstractComponentValidator;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinitionPackage;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.NamespaceImport;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ComponentValidator
extends AbstractComponentValidator {
    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
        } else {
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            if (!(IteratorExtensions.head((Iterator)r.getAllContents()) instanceof InterfaceDefinition) && !(IteratorExtensions.head((Iterator)r.getAllContents()) instanceof ComponentModel)) {
                this.error("The imported resource has to be interface or component model.", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
            }
        }
    }

    @Check
    public void checkConnectionPortsInterfaces(Connection c) {
        Signature _interface_1;
        boolean _tripleNotEquals;
        if (c.getFirstEnd().getPort() == null || c.getSecondEnd().getPort() == null) {
            return;
        }
        Signature _interface = c.getFirstEnd().getPort().getInterface();
        boolean bl = _tripleNotEquals = _interface != (_interface_1 = c.getSecondEnd().getPort().getInterface());
        if (_tripleNotEquals) {
            this.error("A connection can not connect ports of different interfaces.", c, (EStructuralFeature)ComponentPackage.Literals.CONNECTION__FIRST_END);
        }
    }

    @Check
    public void checkConnectionDistinctEnds(Connection c) {
        ComponentPart _part_1;
        boolean _tripleEquals;
        ComponentPart _part = c.getFirstEnd().getPart();
        boolean bl = _tripleEquals = _part == (_part_1 = c.getSecondEnd().getPart());
        if (_tripleEquals) {
            this.error("A connection can not connect ports from the same component instance", c, (EStructuralFeature)ComponentPackage.Literals.CONNECTION__FIRST_END);
        }
    }

    @Check
    public void checkConnectionPortDirections(Connection c) {
        if (c.getFirstEnd().getPort() == null || c.getSecondEnd().getPort() == null) {
            return;
        }
        if (c.getFirstEnd().getPart() == null || c.getSecondEnd().getPart() == null) {
            boolean _tripleNotEquals;
            Port _port = c.getFirstEnd().getPort();
            Port _port_1 = c.getSecondEnd().getPort();
            boolean bl = _tripleNotEquals = Boolean.valueOf(_port instanceof ProvidedPort) != Boolean.valueOf(_port_1 instanceof ProvidedPort);
            if (_tripleNotEquals) {
                this.error("Ports must be of the same direction", c.getFirstEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
                this.error("Ports must be of the same direction", c.getSecondEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
            }
        } else {
            Port _port_3;
            boolean _equals;
            Port _port_2 = c.getFirstEnd().getPort();
            boolean bl = _equals = _port_2 instanceof ProvidedPort == (_port_3 = c.getSecondEnd().getPort()) instanceof ProvidedPort;
            if (_equals) {
                this.error("Ports must be of different direction", c.getFirstEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
                this.error("Ports must be of different direction", c.getSecondEnd(), (EStructuralFeature)ComponentPackage.Literals.PORT_REFERENCE__PORT);
            }
        }
    }

    @Check
    public void checkDistinctConnections(Component c) {
        EList<Connection> _connections = c.getConnections();
        for (Connection conn1 : _connections) {
            EList<Connection> _connections_1 = c.getConnections();
            for (Connection conn2 : _connections_1) {
                if (conn1 == conn2 || !ComponentUtilities.sameEnds(conn1, conn2)) continue;
                this.error("There is another connection with the same ends", (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__CONNECTIONS, c.getConnections().indexOf((Object)conn2));
            }
        }
    }

    @Check
    public void checkBoundaryPortsConnections(Component c) {
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            boolean _greaterThan;
            int _size = ComponentUtilities.getConnectionsForEnd(c, null, p).size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            this.error("Boundary port may have at most one connection", (EObject)p, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkPartPortsConnections(Component c) {
        EList<ComponentPart> _parts = c.getParts();
        for (ComponentPart part : _parts) {
            EList _ports = part.getComponentType().getPorts();
            for (Port port : _ports) {
                List<Connection> connections = ComponentUtilities.getConnectionsForEnd(c, part, port);
                if (port instanceof RequiredPort && connections.size() > 1) {
                    String _name = part.getName();
                    String _plus = "Required part port " + _name;
                    String _plus_1 = String.valueOf(_plus) + "::";
                    String _name_1 = port.getName();
                    String _plus_2 = String.valueOf(_plus_1) + _name_1;
                    String _plus_3 = String.valueOf(_plus_2) + " can be connected at most once";
                    this.error(_plus_3, (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__CONNECTIONS, c.getConnections().indexOf((Object)connections.get(0)));
                }
                if (!(port instanceof ProvidedPort) || connections.size() <= 1) continue;
                for (Connection conn : connections) {
                    PortReference otherEnd = ComponentUtilities.otherEnd(conn, part, port);
                    if (otherEnd.getPart() != null && !(otherEnd.getPort() instanceof ProvidedPort)) continue;
                    String _name_2 = part.getName();
                    String _plus_4 = "Provided part port " + _name_2;
                    String _plus_5 = String.valueOf(_plus_4) + "::";
                    String _name_3 = port.getName();
                    String _plus_6 = String.valueOf(_plus_5) + _name_3;
                    String _plus_7 = String.valueOf(_plus_6) + " can be connected to a single boundary port or to required part ports";
                    this.error(_plus_7, (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__CONNECTIONS, c.getConnections().indexOf((Object)conn));
                }
            }
        }
    }

    @Check
    public void checkDuplicatedPortNames(Component c) {
        this.checkForNameDuplications((Iterable)c.getPorts(), "port", null, new String[]{"port"});
    }

    @Check
    public void checkDuplicatedPartNames(Component c) {
        this.checkForNameDuplications((Iterable)c.getParts(), "part", null, new String[]{"part"});
    }

    @Check
    public void checkDuplicatedFuncConstraintNames(FunctionalConstraintsBlock fcb) {
        this.checkForNameDuplications((Iterable)fcb.getFunctionalConstraints(), "constraint", null, new String[]{"constraint"});
    }

    @Check
    public void checkDuplicatedStateNamesFunctionalConstraint(StateBasedFunctionalConstraint fc) {
        this.checkForNameDuplications((Iterable)fc.getStates(), "state", null, new String[]{"state"});
    }

    @Check
    public void checkInitialState(StateBasedFunctionalConstraint fc) {
        boolean _equals;
        boolean _greaterThan;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        Iterable initialStates = IterableExtensions.filter(fc.getStates(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)initialStates);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.error("More than one initial state", (EObject)fc, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            return;
        }
        int _size_1 = IterableExtensions.size((Iterable)initialStates);
        boolean bl2 = _equals = _size_1 == 0;
        if (_equals) {
            this.error("Missing initial state", (EObject)fc, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkUsedEventsList(StateBasedFunctionalConstraint fc) {
        EList<EventPattern> _usedEvents = fc.getUsedEvents();
        for (EventPattern ev1 : _usedEvents) {
            EList<EventPattern> _usedEvents_1 = fc.getUsedEvents();
            for (EventPattern ev2 : _usedEvents_1) {
                boolean _isSubsumedBy;
                boolean _notEquals;
                boolean bl = _notEquals = !Objects.equal((Object)ev1, (Object)ev2);
                if (!_notEquals || !(_isSubsumedBy = ComponentUtilities.isSubsumedBy(ev1, ev2))) continue;
                this.warning("The event is duplicated or subsumed by another event", (EObject)fc, (EStructuralFeature)ComponentPackage.Literals.STATE_BASED_FUNCTIONAL_CONSTRAINT__USED_EVENTS, fc.getUsedEvents().indexOf((Object)ev1));
            }
        }
    }

    @Check
    public void checkEventReceptions(StateBasedFunctionalConstraint fc) {
        List _allContentsOfType = EcoreUtil2.getAllContentsOfType((EObject)fc, EventReception.class);
        for (final EventReception er : _allContentsOfType) {
            boolean _not;
            Functions.Function1<EventPattern, Boolean> _function = new Functions.Function1<EventPattern, Boolean>(){

                public Boolean apply(EventPattern e) {
                    return ComponentUtilities.isSubsumedBy(er.getEvent(), e);
                }
            };
            boolean _exists = IterableExtensions.exists(fc.getUsedEvents(), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            this.error("Event is not declared in used events list", (EObject)er, (EStructuralFeature)ComponentPackage.Literals.EVENT_RECEPTION__EVENT);
        }
    }

    @Check
    public void checkUnusedVarsFunctionalConstraint(final FunctionalConstraint fc) {
        ArrayList variables = new ArrayList();
        variables.addAll(fc.getVars());
        Functions.Function1<ExpressionVariable, Variable> _function = new Functions.Function1<ExpressionVariable, Variable>(){

            public Variable apply(ExpressionVariable it) {
                return it.getVariable();
            }
        };
        variables.removeAll(ListExtensions.map((List)EcoreUtil2.getAllContentsOfType((EObject)fc, ExpressionVariable.class), (Functions.Function1)_function));
        Consumer<Variable> _function_1 = new Consumer<Variable>(){

            @Override
            public void accept(Variable it) {
                ComponentValidator.this.warning("Unused variable.", (EStructuralFeature)ActionsPackage.Literals.VARIABLE_DECL_BLOCK__VARS, fc.getVars().indexOf((Object)it));
            }
        };
        variables.forEach(_function_1);
    }

    @Check
    public void checkTypingEventReception(EventReception er) {
        boolean _not;
        boolean _tripleEquals;
        Expression _condition = er.getCondition();
        boolean bl = _tripleEquals = _condition == null;
        if (_tripleEquals) {
            return;
        }
        TypeObject t = this.typeOf(er.getCondition());
        boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.boolType);
        boolean bl2 = _not = !_subTypeOf;
        if (_not) {
            this.error("Type mismatch: the type of the condition must be boolean", (EStructuralFeature)ComponentPackage.Literals.EVENT_RECEPTION__CONDITION);
        }
    }

    @Check
    public void checkTypingPredicateFunctionalConstraint(PredicateFunctionalConstraint fc) {
        boolean _not;
        TypeObject t = this.typeOf(fc.getExpression());
        boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.boolType);
        boolean bl = _not = !_subTypeOf;
        if (_not) {
            this.error("Type mismatch: the type of the expression must be boolean", (EStructuralFeature)ComponentPackage.Literals.PREDICATE_FUNCTIONAL_CONSTRAINT__EXPRESSION);
        }
    }

    @Check
    public void checkConnectionVariableInPort(PortAwareEvent ev) {
        boolean _tripleNotEquals;
        ExpressionVariable _idVar = ev.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            boolean _not;
            TypeObject t = this.typeOf((Expression)ev.getIdVar());
            boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("The type of the variable must be id", (EStructuralFeature)ComponentPackage.Literals.PORT_AWARE_EVENT__ID_VAR);
            }
        }
    }

    @Check
    public void checkConnectionVariableInExpr(ExpressionConnectionState expr) {
        boolean _tripleNotEquals;
        ExpressionVariable _idVar = expr.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            boolean _not;
            TypeObject t = this.typeOf((Expression)expr.getIdVar());
            boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.idType);
            boolean bl2 = _not = !_subTypeOf;
            if (_not) {
                this.error("The type of the variable must be id", (EStructuralFeature)ComponentPackage.Literals.EXPRESSION_CONNECTION_STATE__ID_VAR);
            }
        }
    }

    @Check
    public void checkForIdType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("id")) {
            boolean _not;
            EObject _eContainer = t.eContainer().eContainer();
            boolean bl = _not = !(_eContainer instanceof VariableDeclBlock);
            if (_not) {
                this.error("Usage of type id is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
            }
        }
    }

    @Check
    public void checkCommandInReply(CommandReply cr) {
        boolean _not;
        boolean _tripleEquals;
        CommandEvent _command = cr.getCommand();
        boolean bl = _tripleEquals = _command == null;
        if (_tripleEquals) {
            return;
        }
        boolean _contains = cr.getPort().getInterface().getCommands().contains((Object)cr.getCommand().getEvent());
        boolean bl2 = _not = !_contains;
        if (_not) {
            String _name = cr.getPort().getName();
            String _plus = "Command not defined in the interface of the reply's port " + _name;
            this.error(_plus, (EStructuralFeature)ActionsPackage.Literals.COMMAND_REPLY__COMMAND);
        } else if (cr.eContainer() instanceof EventReception && !cr.getParameters().isEmpty()) {
            InterfaceEvent _event = cr.getCommand().getEvent();
            this.checkReplyAgainstCommand((Command)_event, cr);
        }
    }

    public TypeObject typeOf(Expression exp) {
        Object _xifexpression = null;
        _xifexpression = exp != null && (exp instanceof ExpressionInterfaceState || exp instanceof ExpressionConnectionState) ? this.boolType : super.typeOf(exp);
        return _xifexpression;
    }

    @Check
    public void checkDuplications(ComponentModel compDef) {
        if (compDef.getName() == null && IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)compDef.getImports(), NamespaceImport.class))) {
            return;
        }
        Multimap multiMap = this.getGlobalDeclarations((EObject)compDef, TypesPackage.eINSTANCE.getTypeDecl());
        this.placePredefinedTypes(multiMap);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported type " + _string;
            this.error(_plus, (EObject)compDef.getComponent(), (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)compDef, InterfaceDefinitionPackage.Literals.INTERFACE);
        Set _entrySet_1 = multiMap.asMap().entrySet();
        for (Map.Entry entry_1 : _entrySet_1) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry_1.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry_1.getKey()).toString();
            String _plus = "Duplicate imported interface " + _string;
            this.error(_plus, (EObject)compDef.getComponent(), (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkEventPattern(EventPattern ev) {
        if (ev instanceof PortAwareEvent) {
            boolean _equals;
            boolean _tripleEquals;
            ComponentPart _part = ((PortAwareEvent)ev).getPart();
            boolean bl = _tripleEquals = _part == null;
            if (_tripleEquals) {
                return;
            }
            Component parent = (Component)EcoreUtil2.getContainerOfType((EObject)ev, Component.class);
            List<Connection> connections = ComponentUtilities.getConnectionsForEnd(parent, ((PortAwareEvent)ev).getPart(), ((PortAwareEvent)ev).getPort());
            int _size = connections.size();
            boolean bl2 = _equals = _size == 1;
            if (_equals) {
                boolean _tripleEquals_1;
                Connection conn = connections.get(0);
                PortReference otherEnd = ComponentUtilities.otherEnd(conn, ((PortAwareEvent)ev).getPart(), ((PortAwareEvent)ev).getPort());
                ComponentPart _part_1 = otherEnd.getPart();
                boolean bl3 = _tripleEquals_1 = _part_1 == null;
                if (_tripleEquals_1) {
                    String _name = otherEnd.getPort().getName();
                    String _plus = "Use an event pattern that refers to boundary port " + _name;
                    this.error(_plus, (EObject)ev, (EStructuralFeature)ComponentPackage.Literals.PORT_SELECTOR__PORT);
                }
            }
        }
    }

    @Check
    public void checkUnconnectedPorts(Component c) {
        boolean _isEmpty = c.getParts().isEmpty();
        if (_isEmpty) {
            return;
        }
        EList _ports = c.getPorts();
        for (Port port : _ports) {
            boolean _isEmpty_1 = ComponentUtilities.getConnectionsForEnd(c, null, port).isEmpty();
            if (!_isEmpty_1) continue;
            this.warning("The port is unconnected.", (EObject)c, (EStructuralFeature)BehaviorPackage.Literals.BLOCK__PORTS, c.getPorts().indexOf((Object)port));
        }
        EList<ComponentPart> _parts = c.getParts();
        for (ComponentPart part : _parts) {
            EList _ports_1 = part.getComponentType().getPorts();
            for (Port p : _ports_1) {
                boolean _isEmpty_2 = ComponentUtilities.getConnectionsForEnd(c, part, p).isEmpty();
                if (!_isEmpty_2) continue;
                String _name = p.getName();
                String _plus = "Port " + _name;
                String _plus_1 = String.valueOf(_plus) + " is unconnected.";
                this.warning(_plus_1, (EObject)c, (EStructuralFeature)ComponentPackage.Literals.COMPONENT__PARTS, c.getParts().indexOf((Object)part));
            }
        }
    }
}

