/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.simulator;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.EnvConfig;
import org.eclipse.comma.petrinet.PetrinetBuilder;
import org.eclipse.xtext.scoping.IScopeProvider;

public class SimulatorGenerator {
    public static String generateForComponent(Component component, List<EnvConfig> environment, IScopeProvider scopeProvider, String plantumlJar) throws URISyntaxException {
        String petrinetCode = PetrinetBuilder.forComponent((Component)component, environment, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.NOT_INTERACTIVE);
        return SimulatorGenerator.generate(petrinetCode, plantumlJar);
    }

    public static String generateForInterface(Interface itf, Parameters parameters, IScopeProvider scopeProvider, String plantumlJar) throws URISyntaxException {
        String petrinetCode = PetrinetBuilder.forInterface((Interface)itf, (Parameters)parameters, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.NOT_INTERACTIVE);
        return SimulatorGenerator.generate(petrinetCode, plantumlJar);
    }

    private static String generate(String petrinetCode, String plantumlJar) throws URISyntaxException {
        String code = "SELF_CONTAINED = True\n" + PetrinetBuilder.getModelCode() + PetrinetBuilder.getWalkerCode();
        code = String.valueOf(code) + petrinetCode + "\n\n";
        Path javaExecutable = Paths.get(System.getProperty("java.home"), "bin", "java");
        code = String.valueOf(code) + "## Parameters\n";
        code = String.valueOf(code) + String.format("JAVA = r'%s'\n", javaExecutable);
        code = String.valueOf(code) + String.format("PLANTUML = r'%s'\n", plantumlJar);
        code = String.valueOf(code) + "\n";
        code = String.valueOf(code) + "## simulator.py\n" + SimulatorGenerator.getResourceText("/simulator.py") + "\n\n";
        return code;
    }

    private static String getResourceText(String resource) {
        InputStream stream = SimulatorGenerator.class.getResourceAsStream(resource);
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }
}

