/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.eventmanager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ebam.eventmanager.manager.ConfigurationManagerReader;
import org.eclipse.ebam.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerConfiguration {
    private static Logger logger = LoggerFactory.getLogger(EventManagerConfiguration.class);
    private String confFilePath = "/conf/configuration.xml";
    private String mailConfFilePath = "/conf/mail.xml";
    private String content = null;
    private String contentM = null;
    private String launchThread = null;
    private String timeoutConf = null;
    private String smtphost = null;
    private String smtpport = null;
    private String from = null;
    private String user = null;
    private String pass = null;

    private EventManagerConfiguration() {
        InputStream isM;
        InputStream is;
        URL configFile = ConfigurationManagerReader.getFileURL(this.confFilePath);
        try {
            is = configFile.openStream();
        }
        catch (IOException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            this.content = sb.toString();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(this.content);
            this.timeoutConf = XmlUtils.extractByConfFile((StringBuffer)strBufferContent, (String)"//CONF/TIMEOUT", (String)"STRING");
            this.launchThread = XmlUtils.extractByConfFile((StringBuffer)strBufferContent, (String)"//CONF/SEND_ALARM_THREAD", (String)"STRING");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            logger.error("ParserConfigurationException", (Throwable)e);
            e.printStackTrace();
        }
        URL mailConfigFile = ConfigurationManagerReader.getFileURL(this.mailConfFilePath);
        try {
            isM = mailConfigFile.openStream();
        }
        catch (IOException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            return;
        }
        BufferedReader brM = new BufferedReader(new InputStreamReader(isM));
        StringBuilder sbM = new StringBuilder();
        String lineM = null;
        try {
            while ((lineM = brM.readLine()) != null) {
                sbM.append(lineM);
            }
            brM.close();
            this.contentM = sbM.toString();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(this.contentM);
            this.smtphost = XmlUtils.extractByConfFile((StringBuffer)strBufferContent, (String)"//MAIL/PROFILES/PROFILE/@smtphost", (String)"STRING");
            this.smtpport = XmlUtils.extractByConfFile((StringBuffer)strBufferContent, (String)"//MAIL/PROFILES/PROFILE/@smtpport", (String)"STRING");
            this.from = XmlUtils.extractByConfFile((StringBuffer)strBufferContent, (String)"//MAIL/PROFILES/PROFILE/@from", (String)"STRING");
            this.user = XmlUtils.extractByConfFile((StringBuffer)strBufferContent, (String)"//MAIL/PROFILES/PROFILE/@user", (String)"STRING");
            this.pass = XmlUtils.extractByConfFile((StringBuffer)strBufferContent, (String)"//MAIL/PROFILES/PROFILE/@password", (String)"STRING");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            logger.error("ParserConfigurationException", (Throwable)e);
            e.printStackTrace();
        }
    }

    public String getLaunchThread() {
        return this.launchThread;
    }

    public void setLaunchThread(String launchThread) {
        this.launchThread = launchThread;
    }

    public String getTimeoutConf() {
        return this.timeoutConf;
    }

    public void setTimeoutConf(String timeoutConf) {
        this.timeoutConf = timeoutConf;
    }

    public String getSmtphost() {
        return this.smtphost;
    }

    public void setSmtphost(String smtphost) {
        this.smtphost = smtphost;
    }

    public String getSmtpport() {
        return this.smtpport;
    }

    public void setSmtpport(String smtpport) {
        this.smtpport = smtpport;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public static EventManagerConfiguration getInstance() {
        return Singleton.INSTANCE;
    }

    /* synthetic */ EventManagerConfiguration(EventManagerConfiguration eventManagerConfiguration) {
        this();
    }

    private static class Singleton {
        private static final EventManagerConfiguration INSTANCE = new EventManagerConfiguration(null);

        private Singleton() {
        }
    }
}

