/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

import org.eclipse.ebam.emf.interfaces.IMessageTransaction;
import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.MessageEngine;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class MessageTransactions extends EMF implements IMessageTransaction{

	/**
	 * Logger.
	 */
	private static Logger logger = LoggerFactory
			.getLogger(MessageTransactions.class);




	/**
	 * Used to retrieve the name if the engine to fwd the message type
	 */
	// Da verificare
	public List<SbiDomain> getSbiDomainsbyMessageId(Integer idType) throws Exception {
		List<SbiDomain> result = new ArrayList<SbiDomain>();
	
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em.createQuery("select m from MessageEngine m "
					+ "where m.messageId = :messageID");
			query.setParameter("messageID", idType);
			List<MessageEngine> mengine = query.getResultList();
			if (mengine != null){
				for (MessageEngine me : mengine){
						result.add(me.getSbiDomain()); 
						logger.debug("Sbi Domain value: "+ me.getSbiDomain().getValueNm());
						}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;
		}
	}
	
	
	
	
	/**
	 * Method that executes database query to extract <code>DataAttribute</code>
	 * with xpath expression for specific message type.
	 * 
	 * @param msgType
	 *            messageId
	 * @return <code>DataAttribute</code>
	 * @throws Exception
	 *             error on select
	 */
	@SuppressWarnings( { "finally", "unchecked" })
	public final List<DataAttribute> getDataAttributeByMsgId(
			final Integer msgType) throws Exception {
		List<DataAttribute> dataAttr = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em.createQuery("select e from DataAttribute e "
					+ "where e.message.messageId = :messageID");
			query.setParameter("messageID", msgType);
			dataAttr = (List<DataAttribute>) query.getResultList();

		} catch (Exception e) {
			//logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return dataAttr;
		}
	}

	/**
	 * Method that executes database query to extract message id by message
	 * name.
	 * 
	 * @param msgTypeName
	 *            name
	 * @return <code>Integer</code> messageId
	 * @throws Exception
	 *             error on select
	 */
	@SuppressWarnings("finally")
	public final Integer getMsgIdByName(final String msgTypeName)
			throws Exception {
		Integer msgId = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em.createQuery("select m.messageId from "
					+ "Message m where m.name = :name");
			query.setParameter("name", msgTypeName);
			msgId = (Integer) query.getSingleResult();

		} catch (NoResultException e) {
			//logger.debug(e.getMessage(), e);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return msgId;
		}
	}

	/**
	 * Method that executes database query to extract <code>Message</code> by
	 * message type.
	 * 
	 * @param msgType
	 *            message type
	 * @param serviceName
	 *            service name
	 * @return <code>Message</code>
	 * @throws Exception
	 *             error on select
	 */

	@SuppressWarnings("finally")
	public final Message getMessageByType(final String msgType,
			final String serviceName) throws Exception {
		Message msg = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			
			Query query = em
					.createQuery("select e from Message "
							+ "e where e.name = :name and e.service.name = :serviceName ");

			query.setParameter("name", msgType);
			query.setParameter("serviceName", serviceName);

			msg = (Message) query.getSingleResult();
			

			
		} catch (NoResultException e) {
			//logger.debug(e.getMessage(), e);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		} finally {
			em.close();
			return msg;
		}
	}





	/**
	 * Method that executes database query to the id of the typeMessage 
	 * using the xml root of the message
	 * 
	 * 
	 * @param label
	 *            to search
	 * @param serviceID
	 *            service id
	 * @return <code>ServiceInstance</code>
	 * @throws Exception
	 *             error
	 */
	public Message getMessageByXmlRoot(String root) throws Exception {

		Message message = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em
					.createQuery("select e from Message e "
							+ "where e.rootElement = :root");
			query.setParameter("root", root);
			message = (Message) query.getSingleResult();
		} catch (NoResultException e) {
			//logger.debug(e.getMessage(), e);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		} finally {
			em.close();
			return message;
		}
	}
}
