/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the cep_rules database table.
 * 
 */
@Entity
@Table(name="EBAM_RULES")
public class Rule implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="RULE_ID")
	private Integer cepRuleId;

	@Temporal( TemporalType.TIMESTAMP)
	@Column(name="END_DATE")
	private Date endDate;

	@Column(name="EXPRESSION")
	private String expression;
	
	@Column(name="SERVICE")
	private String service;

	@Temporal( TemporalType.TIMESTAMP)
	@Column(name="START_DATE")
	private Date startDate;

	//bi-directional many-to-one association to Domain
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="ROLE_TYPE_ID")
	private SbiDomain sbiDomain;

	//bi-directional many-to-one association to Event
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="EVENT_ID")
	private Event event;
	
	//bi-directional many-to-one association to Event
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="THRESHOLD_ID")
	private SbiThreshold threshold;

	public Rule() {
	}

	public int getCepRuleId() {
		return this.cepRuleId;
	}

	public void setCepRuleId(int cepRuleId) {
		this.cepRuleId = cepRuleId;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getExpression() {
		return this.expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}
	public String getService() {
		return this.service;
	}

	public void setService(String service) {
		this.service = service;
	}
	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public SbiDomain getSbiDomain() {
		return this.sbiDomain;
	}

	public void setSbiDomain(SbiDomain sbiDomain) {
		this.sbiDomain = sbiDomain;
	}

	public Event getEvent() {
		return this.event;
	}

	public void setEvent(Event event) {
		this.event = event;
	}	

	public SbiThreshold getThreshold() {
		return this.threshold;
	}

	public void setThreshold(SbiThreshold threshold) {
		this.threshold = threshold;
	}

}