/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.adapters;

import java.util.Map;
import org.eclipse.ebam.adapters.AdapterConfiguration;
import org.eclipse.ebam.adapters.IAdapter;
import org.eclipse.ebam.adapters.IAdapterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFactory {
    private static Logger logger = LoggerFactory.getLogger(AdapterFactory.class);
    private static AdapterConfiguration configuration;

    public static IAdapter createAdapter(IAdapterManager manager, String adapterName, boolean keyMode, String key, boolean appendMode, String fileNameFromKey) {
        logger.debug("IN");
        configuration = AdapterConfiguration.getInstance();
        IAdapter adapter = null;
        Map<String, String> adapterData = configuration.getLogAdapters().get(adapterName);
        String factory = adapterData.get("factory");
        try {
            Class<?> c = Class.forName(factory);
            IAdapter a = (IAdapter)c.newInstance();
            a.init(manager, adapterName, adapterData, keyMode, key, appendMode, fileNameFromKey);
            adapter = a;
        }
        catch (ClassNotFoundException e) {
            logger.error("ClassNotFoundException: " + adapterName, (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("InstantiationException: " + adapterName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("IllegalAccessException: " + adapterName, (Throwable)e);
        }
        logger.debug("OUT");
        return adapter;
    }
}

