/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.cache;

import java.util.List;
import org.eclipse.ebam.cache.IMsgCaching;
import org.eclipse.ebam.cache.MsgReadUtils;
import org.eclipse.ebam.emf.interfaces.ICacheTransaction;
import org.eclipse.ebam.emf.interfaces.IJournalTransactions;
import org.eclipse.ebam.emf.interfaces.IMessageTransaction;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.Journal;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.MessageContent;
import org.eclipse.ebam.model.entities.MessageEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgCaching
implements IMsgCaching {
    private static Logger logger = LoggerFactory.getLogger(MsgCaching.class);
    private IMessageTransaction mt = null;
    private IJournalTransactions t = null;
    private ICacheTransaction cacheTransaction = null;

    public MsgCaching(IMessageTransaction m, IJournalTransactions j, ICacheTransaction c) {
        this.mt = m;
        this.t = j;
        this.cacheTransaction = c;
    }

    public final boolean savetoCache(IEbamMessage message) {
        boolean saved;
        block6: {
            saved = false;
            String msgType = MsgReadUtils.extractMsgType(message);
            String serviceName = MsgReadUtils.extractService(message);
            logger.debug("Message type:: " + msgType);
            logger.debug("Service name:: " + serviceName);
            Message messageTypeBean = null;
            try {
                messageTypeBean = this.mt.getMessageByType(msgType, serviceName);
                if (messageTypeBean == null) break block6;
                Journal j = MsgReadUtils.createJournaleFromMessage(message, messageTypeBean, this.cacheTransaction);
                try {
                    List<MessageContent> messageContents = MsgReadUtils.createRelevantData(j, message, messageTypeBean, this.mt);
                    saved = this.cacheTransaction.saveJournal(j, messageContents);
                    List target = messageTypeBean.getMessageEngine();
                    if (target != null) {
                        for (MessageEngine engine : target) {
                            message.addTargetEngine(engine.getSbiDomain().getValueNm());
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error("ERROR CREATING JOURNAL", (Throwable)ex);
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return saved;
    }
}

