/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine.utils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.eclipse.ebam.emf.interfaces.IMessageTransaction;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Journal;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.MessageContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgReadUtils {
    private static Logger logger = LoggerFactory.getLogger(MsgReadUtils.class);
    private static IMessageTransaction msgTransaction = null;

    public static void setMsgTransaction(IMessageTransaction msgTransaction) {
        MsgReadUtils.msgTransaction = msgTransaction;
    }

    public static String extractByQuery(IEbamMessage message, String xpath, String dataType) {
        Document doc = null;
        String data = null;
        String content = message.getMsg();
        content = content.substring(content.indexOf(";") + 1);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(content);
            ByteArrayInputStream bais = new ByteArrayInputStream(strBufferContent.toString().getBytes("UTF-8"));
            InputSource inputSource = new InputSource(bais);
            doc = db.parse(inputSource);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (dataType == null || dataType.equals("") || dataType.equalsIgnoreCase("STRING")) {
                XObject tmp = XPathAPI.eval(doc, (String)xpath);
                if (tmp != null) {
                    data = tmp.toString();
                }
            } else if (dataType != null && dataType.equalsIgnoreCase("LIST")) {
                Node n;
                data = "";
                NodeIterator nl = XPathAPI.selectNodeIterator((Node)doc, (String)xpath);
                while ((n = nl.nextNode()) != null) {
                    data = String.valueOf(data) + n.getTextContent() + " ";
                }
            }
            if (xpath != null && !xpath.contains("password")) {
                logger.debug("Info readed: " + xpath + "=" + data);
            }
        }
        catch (TransformerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    public final boolean persistMsg(IEbamMessage message, String msgType) {
        boolean isSaved = false;
        return isSaved;
    }

    public final List<MessageContent> createRelevantData(Journal j, IEbamMessage message, Message messageTypeBean) {
        ArrayList<MessageContent> result = null;
        try {
            List dataAttrs;
            Integer msgId = messageTypeBean.getMessageId();
            if (msgId != null && (dataAttrs = msgTransaction.getDataAttributeByMsgId(msgId)) != null && dataAttrs.size() != 0) {
                result = new ArrayList<MessageContent>();
                int i = 0;
                while (i < dataAttrs.size()) {
                    DataAttribute dataAttr = (DataAttribute)dataAttrs.get(i);
                    String relevantData = MsgReadUtils.extractByQuery(message, dataAttr.getExpression(), dataAttr.getDataType());
                    if (relevantData != null && !relevantData.equals("")) {
                        MessageContent msgContent = new MessageContent();
                        msgContent.setDataAttribute(dataAttr);
                        msgContent.setJournal(j);
                        msgContent.setName(dataAttr.getName());
                        msgContent.setValue(relevantData);
                        result.add(msgContent);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

