/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.filesystem.writer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import org.eclipse.ebpm.connectors.filesystem.adapters.IFileAdapter;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemWriterConnector
extends AbstractSpagicConnector {
    public static final String PROPERTY_DIRECTORY = "directory";
    public static final String PROPERTY_OUTPUT = "output";
    public static final String OUTPUT_BODY = "body";
    public static final String OUTPUT_ATTACHMENTS = "attachments";
    private static final String filePrefix = "spagic-";
    private static final String fileSuffix = ".xml";
    protected Logger logger = LoggerFactory.getLogger(FileSystemWriterConnector.class);
    private boolean autoCreateDirectory = true;
    private File directory;
    private String output;
    private ConcurrentHashMap<String, IFileAdapter> marshalers = new ConcurrentHashMap();
    private String marshalerId;

    public void init() {
        String directoryString = this.propertyConfigurator.getString(PROPERTY_DIRECTORY);
        this.directory = new File(directoryString);
        this.output = this.propertyConfigurator.getString(PROPERTY_OUTPUT, OUTPUT_BODY);
        this.marshalerId = this.propertyConfigurator.getString("marshaller", "DEFAULT");
    }

    public void start() throws Exception {
        super.start();
        if (this.directory == null) {
            throw new RuntimeException("You must specify the directory");
        }
        if (this.autoCreateDirectory) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new RuntimeException("The directory property must be a directory but was: " + this.directory);
        }
    }

    public void stop() throws Exception {
        super.stop();
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean run(Exchange exchange, Message inMessage, Message outMessage) throws Exception {
        BufferedWriter bw = null;
        File newFile = null;
        boolean success = false;
        try {
            try {
                if (this.output.equalsIgnoreCase(OUTPUT_BODY)) {
                    IFileAdapter adapter = this.marshalers.get(this.marshalerId);
                    String name = adapter.getOutputFileName(exchange, inMessage);
                    newFile = name == null ? File.createTempFile(filePrefix, fileSuffix, this.directory) : new File(this.directory, name);
                    if (!newFile.getParentFile().exists() && this.autoCreateDirectory) {
                        newFile.getParentFile().mkdirs();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Writing to file: " + newFile.getCanonicalPath());
                    }
                    bw = new BufferedWriter(new FileWriter(newFile, false));
                    adapter.writeMessage(exchange, inMessage, bw);
                } else {
                    Map attachments = inMessage.getAttachments();
                    for (String key : attachments.keySet()) {
                        int len;
                        DataHandler dh = (DataHandler)attachments.get(key);
                        File f = new File(this.directory, key);
                        InputStream inputStream = dh.getInputStream();
                        FileOutputStream out = new FileOutputStream(f);
                        byte[] buf = new byte[1024];
                        while ((len = inputStream.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                        ((OutputStream)out).close();
                        inputStream.close();
                    }
                }
                success = true;
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (Exception genericException) {
                throw new IllegalStateException(genericException.getMessage(), genericException);
            }
        }
        finally {
            inMessage.finalizeAttachments();
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    this.logger.error("Caught exception while closing stream on error: " + e, (Throwable)e);
                }
            }
            if (!success && newFile != null) {
                try {
                    this.logger.debug("An error occurred while writing file " + newFile.getCanonicalPath() + ", deleting the invalid file");
                    if (!newFile.delete()) {
                        this.logger.warn("Unable to delete the file " + newFile.getCanonicalPath() + " after an error had occurred");
                    }
                }
                catch (IOException e) {
                    this.logger.error("Caught exception while closing stream on error: " + e, (Throwable)e);
                }
            }
        }
        return success;
    }

    public void setMarshaler(IFileAdapter adapter) {
        this.marshalers.put(adapter.getAdapterId(), adapter);
    }

    public void unsetMarshaler(IFileAdapter marshaler) {
        this.marshalers.remove(marshaler.getAdapterId());
    }
}

