/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.dynapp;

import java.io.File;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;
import org.eclipse.ebpm.dirwatcher.DirectoryPoller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandler
implements BundleListener {
    protected Logger logger = LoggerFactory.getLogger(ApplicationHandler.class);
    private String applicationId = null;
    private String applicationName = null;
    private String path = null;
    private boolean absolute = false;
    private String spagicHome = null;
    private BundleContext context = null;
    private Timer bundleTimerService = null;
    private ConcurrentHashMap<String, Bundle> bundles = new ConcurrentHashMap();
    private String spagicHomeLocation = null;

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public ApplicationHandler(BundleContext context, String spagicHome, Element el) {
        this.context = context;
        this.applicationId = el.attributeValue("id");
        this.applicationName = el.attributeValue("name");
        this.path = el.attributeValue("path");
        this.spagicHome = spagicHome;
        String pathType = el.attributeValue("type");
        if (pathType.equalsIgnoreCase("absolute")) {
            this.setAbsolute(true);
        }
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSpagicHomeLocation() {
        return this.spagicHomeLocation;
    }

    public void setSpagicHomeLocation(String spagicHomeLocation) {
        this.spagicHomeLocation = spagicHomeLocation;
    }

    public String getApplicationBundlesHome() {
        if (this.isAbsolute()) {
            return String.valueOf(this.path) + File.separator + "bundles";
        }
        return String.valueOf(this.spagicHome) + File.separator + this.path + File.separator + "bundles";
    }

    public void start() {
        this.context.addBundleListener((BundleListener)this);
        final ApplicationHandler appHandler = this;
        DirectoryPoller bundlesPollingTask = new DirectoryPoller(this.getApplicationBundlesHome(), "jar"){

            public void fireEvent(File file, String action) {
                ApplicationHandler.this.logger.debug("ApplicationHandler[" + ApplicationHandler.this.applicationId + "]::Bundles Thread -> File [" + file.getPath() + "] has been [" + action + "]");
                if (action.equalsIgnoreCase("delete")) {
                    ApplicationHandler.this.logger.debug("ApplicationHandler[" + ApplicationHandler.this.applicationId + "]::Bundles Thread -> File [" + file.getPath() + "] Uninstalling BUNDLE");
                    appHandler.uninstallBundle(file);
                } else if (action.equalsIgnoreCase("add")) {
                    ApplicationHandler.this.logger.debug("ApplicationHandler[" + ApplicationHandler.this.applicationId + "]::Bundles Thread -> File [" + file.getPath() + "] Installing BUNDLE");
                    appHandler.installBundle(file);
                } else if (action.equalsIgnoreCase("modify")) {
                    ApplicationHandler.this.logger.debug("ApplicationHandler[" + ApplicationHandler.this.applicationId + "]::Bundles Thread -> File [" + file.getPath() + "] Refreshing BUNDLE");
                    appHandler.refreshBundle(file);
                }
            }
        };
        this.bundleTimerService = new Timer();
        this.bundleTimerService.schedule((TimerTask)bundlesPollingTask, new Date(), 5000L);
    }

    public void installBundle(File f) {
        Bundle bundle = null;
        try {
            String bundleURI = f.toURI().toURL().toString();
            bundle = this.context.installBundle(bundleURI);
            this.bundles.put(bundleURI, bundle);
            bundle.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void uninstallBundle(File f) {
        try {
            String bundleURI = f.toURI().toURL().toString();
            Bundle b = this.bundles.get(bundleURI);
            if (b != null) {
                b.stop();
                b.uninstall();
                this.bundles.remove(bundleURI);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshBundle(File f) {
        this.uninstallBundle(f);
        this.installBundle(f);
    }

    public void stop() {
        this.context.removeBundleListener((BundleListener)this);
        try {
            this.bundleTimerService.cancel();
            for (Bundle b : this.bundles.values()) {
                b.stop();
                b.uninstall();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bundles.clear();
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            for (Bundle b : this.bundles.values()) {
                try {
                    if (b.getState() == 32) continue;
                    b.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

