/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core.servicedefinitions.extensionprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.ebpm.core.servicedefinitions.extensionprovider.IServiceDefinition;
import org.eclipse.ebpm.service.model.IComboProvider;
import org.eclipse.ebpm.service.model.ServiceModelHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractServiceDefinition
implements IServiceDefinition {
    public static final String CONNECTORS = "/scrappy/connectors/connector";
    public static final String SERVICES = "/scrappy/services/service";
    public static final String DEFINITIONS = "/scrappy/definitions/def";
    public static final String COMBOPROVIDERS = "/scrappy/combo-providers/combo-provider";
    public static final String DEPLOYSCHEMAS = "/scrappy/deploy-schemas/deploy-schema";
    private Document serviceDefDocument;
    private Map<String, IComboProvider> comboProviderFactoryContribution;

    public Document getServiceDefDocument() {
        return this.serviceDefDocument;
    }

    public void setServiceDefDocument(Document serviceDefDocument) {
        this.serviceDefDocument = serviceDefDocument;
    }

    public Map<String, IComboProvider> getComboProviderFactoryContribution() {
        return this.comboProviderFactoryContribution;
    }

    public void setComboProviderFactoryContribution(Map<String, IComboProvider> comboProviderFactoryContribution) {
        this.comboProviderFactoryContribution = comboProviderFactoryContribution;
    }

    public List<Node> getNodeList(String path) {
        if (this.serviceDefDocument == null) {
            return null;
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(ServiceModelHelper.getNsContext());
        NodeList nodes = null;
        try {
            nodes = (NodeList)xPath.evaluate(path, this.serviceDefDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        ArrayList<Node> result = new ArrayList<Node>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            result.add(nodes.item(i));
            ++i;
        }
        return result;
    }

    @Override
    public List<Node> getDeploySchemas() {
        return this.getNodeList(DEPLOYSCHEMAS);
    }

    @Override
    public List<Node> getComboProviders() {
        return this.getNodeList(COMBOPROVIDERS);
    }

    @Override
    public List<Node> getConnectors() {
        return this.getNodeList(CONNECTORS);
    }

    @Override
    public List<Node> getDefinitions() {
        return this.getNodeList(DEFINITIONS);
    }

    @Override
    public List<Node> getServices() {
        return this.getNodeList(SERVICES);
    }
}

