/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.xmlutil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.DocumentSource;
import org.eclipse.ebpm.xmlutil.MapNamespaceContext;

public class DOM4JUtils {
    public static Document dom_to_dom4j(org.w3c.dom.Document domDocument) {
        DOMReader xmlReader = new DOMReader();
        return xmlReader.read(domDocument);
    }

    public static org.w3c.dom.Document dom4j_to_dom(Document domDocument) throws DocumentException {
        DOMWriter xmlWriter = new DOMWriter();
        return xmlWriter.write(domDocument);
    }

    public static NamespaceContext getNamespaceContext(Document dom4JDocument) {
        ArrayList namespaces = new ArrayList();
        DOM4JUtils.retrieveNamespace(dom4JDocument.getRootElement(), namespaces);
        HashMap<String, String> nsMap = new HashMap<String, String>();
        for (Namespace ns : namespaces) {
            nsMap.put(ns.getPrefix(), ns.getURI());
        }
        MapNamespaceContext mapNamespaceContext = new MapNamespaceContext(nsMap);
        return mapNamespaceContext;
    }

    public static NamespaceContext getNamespaceContext(org.w3c.dom.Document domDocument) {
        Document dom4Jdocument = DOM4JUtils.dom_to_dom4j(domDocument);
        return DOM4JUtils.getNamespaceContext(dom4Jdocument);
    }

    private static void retrieveNamespace(Element el, List l) {
        l.addAll(el.declaredNamespaces());
        if (!DOM4JUtils.isLeaf(el)) {
            List childs = el.elements();
            for (Element e : childs) {
                DOM4JUtils.retrieveNamespace(e, l);
            }
        }
    }

    public static boolean isLeaf(Element elem) {
        return elem.elements().size() == 0;
    }

    private static Source getDOM4JSourceFromStringBody(String body) throws Exception {
        Document doc = DocumentHelper.parseText((String)body);
        DocumentSource ds = new DocumentSource(doc);
        return ds;
    }

    public static org.dom4j.QName toDOM4JQName(QName qName) {
        org.dom4j.QName dom4JQName = org.dom4j.QName.get((String)qName.getLocalPart(), (Namespace)new Namespace(qName.getPrefix(), qName.getNamespaceURI()));
        return dom4JQName;
    }
}

