/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.xsdvalidator;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.eclipse.ebpm.components.xsdvalidator.ValidateComponentSAXErrorHandler;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.util.resources.IResource;

public class ValidateComponent
extends BaseSpagicService {
    public static final String FAULT_FLOW = "FAULT_FLOW";
    public static final String FAULT_WITH_EXCEPTION = "FAULT_WITH_EXCEPTION";
    private Schema schema;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Source schemaSource;
    private boolean includeStackTraceInError = false;
    private String faultHandlingMethod = null;
    private IResource schemaResource = null;

    public void init() {
        try {
            this.includeStackTraceInError = this.propertyConfigurator.getBoolean("includeStackTraceInError");
            this.faultHandlingMethod = this.propertyConfigurator.getBoolean("isSendFaultsToTarget", Boolean.valueOf(false)) != false ? FAULT_FLOW : FAULT_WITH_EXCEPTION;
            this.schemaResource = this.propertyConfigurator.getResource("schema");
            SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
            this.schemaSource = new StreamSource(this.schemaResource.openStream());
            this.schema = factory.newSchema(this.schemaSource);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(" Cannot instantiate Validate Component", e);
        }
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        Validator validator = this.schema.newValidator();
        ValidateComponentSAXErrorHandler errorHandler = new ValidateComponentSAXErrorHandler("ERROR", "urn:eng:spagic3", this.includeStackTraceInError);
        validator.setErrorHandler(errorHandler);
        DOMResult result = new DOMResult();
        Document dom4jDocument = DocumentHelper.parseText((String)in.getBodyText());
        DOMSource src = new DOMSource(this.transformtoDOM(dom4jDocument));
        validator.validate(src, result);
        if (errorHandler.mustStop()) {
            if (!this.faultHandlingMethod.equalsIgnoreCase(FAULT_FLOW)) {
                throw new Exception("Failed to validate against schema: " + this.schema);
            }
            out.setBody(errorHandler.messagesToXML());
            return true;
        }
        out.setBody(in.getBody());
        return true;
    }

    public org.w3c.dom.Document transformtoDOM(Document doc) throws DocumentException {
        DOMWriter writer = new DOMWriter();
        return writer.write(doc);
    }
}

