/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.util.stax;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.eclipse.ebpm.soap.util.stax.ExtendedNamespaceContext;

public class ExtendedXMLStreamReader
extends StreamReaderDelegate {
    private SimpleNamespaceContext context = new SimpleNamespaceContext();

    public ExtendedXMLStreamReader(XMLStreamReader delegate) {
        super(delegate);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    @Override
    public int next() throws XMLStreamException {
        int next = super.next();
        if (next == 1) {
            this.context = new SimpleNamespaceContext(this.context, this.getNamespaces());
        } else if (next == 2) {
            this.context = this.context.getParent();
        }
        return next;
    }

    private Map<String, String> getNamespaces() {
        HashMap<String, String> ns = new HashMap<String, String>();
        int i = 0;
        while (i < this.getNamespaceCount()) {
            ns.put(this.getNamespacePrefix(i), this.getNamespaceURI(i));
            ++i;
        }
        return ns;
    }

    public static class SimpleNamespaceContext
    implements ExtendedNamespaceContext {
        private SimpleNamespaceContext parent;
        private Map<String, String> namespaces;

        public SimpleNamespaceContext() {
            this.namespaces = new HashMap<String, String>();
        }

        public SimpleNamespaceContext(SimpleNamespaceContext parent, Map<String, String> namespaces) {
            this.parent = parent;
            this.namespaces = namespaces;
        }

        public SimpleNamespaceContext getParent() {
            return this.parent;
        }

        @Override
        public Collection<String> getPrefixes() {
            HashSet<String> prefixes = new HashSet<String>();
            SimpleNamespaceContext context = this;
            while (context != null) {
                prefixes.addAll(context.namespaces.keySet());
                context = context.parent;
            }
            return prefixes;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String uri = this.namespaces.get(prefix);
            if (uri == null && this.parent != null) {
                uri = this.parent.getNamespaceURI(prefix);
            }
            return uri;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            SimpleNamespaceContext context = this;
            while (context != null) {
                for (Map.Entry<String, String> entry : context.namespaces.entrySet()) {
                    if (!entry.getValue().equals(namespaceURI)) continue;
                    return entry.getKey();
                }
                context = context.parent;
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            HashSet<String> prefixes = new HashSet<String>();
            SimpleNamespaceContext context = this;
            while (context != null) {
                for (Map.Entry<String, String> entry : context.namespaces.entrySet()) {
                    if (!entry.getValue().equals(namespaceURI)) continue;
                    prefixes.add(entry.getKey());
                }
                context = context.parent;
            }
            return prefixes.iterator();
        }
    }
}

