/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.ws.addressing;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.bindings.soap.interceptors.SoapOutInterceptor;
import org.eclipse.ebpm.soap.bindings.soap.model.wsdl1.Wsdl1SoapMessage;
import org.eclipse.ebpm.soap.bindings.soap.model.wsdl1.Wsdl1SoapOperation;
import org.eclipse.ebpm.soap.util.DomUtil;
import org.eclipse.ebpm.soap.ws.addressing.AbstractWsAddressingInterceptor;
import org.eclipse.ebpm.soap.ws.addressing.WsAddressingPolicy;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WsAddressingOutInterceptor
extends AbstractWsAddressingInterceptor {
    public WsAddressingOutInterceptor(WsAddressingPolicy policy, boolean server) {
        super(policy, server);
        this.addBefore(SoapOutInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) {
        QName[] qNameArray = message.getSoapHeaders().keySet().toArray(new QName[0]);
        int n = qNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            QName hdr = qNameArray[n2];
            if (this.isWSANamespace(hdr.getNamespaceURI())) {
                message.getSoapHeaders().remove(hdr);
            }
            ++n2;
        }
        String namespace = "http://www.w3.org/2005/08/addressing";
        if (this.isServer()) {
            Message request = (Message)message.get("request.message");
            if (request == null) {
                throw new Fault("Request message not bound on this message");
            }
            for (QName hdr : request.getSoapHeaders().keySet()) {
                if (!this.isWSANamespace(hdr.getNamespaceURI())) continue;
                namespace = hdr.getNamespaceURI();
                if (!"MessageID".equals(hdr.getLocalPart())) continue;
                QName idQName = new QName(namespace, "RelatesTo");
                String id = DomUtil.getElementText(DomUtil.getFirstChildElement(request.getSoapHeaders().get(hdr)));
                DocumentFragment fragment = this.createTextFragment(idQName, id);
                message.getSoapHeaders().put(idQName, fragment);
            }
        }
        QName idQName = new QName(namespace, "MessageID");
        String id = message.getContent(Exchange.class).getId();
        DocumentFragment fragment = this.createTextFragment(idQName, id);
        message.getSoapHeaders().put(idQName, fragment);
        QName actionQName = new QName(namespace, "Action");
        Wsdl1SoapMessage msg = this.getMessage(message);
        Wsdl1SoapOperation op = this.getOperation(message);
        Binding bnd = message.get(Binding.class);
        if (bnd == null) {
            throw new IllegalStateException("Binding not defined on this message");
        }
        String sep = bnd.getInterfaceName().getNamespaceURI().contains("/") ? "/" : ":";
        String action = String.valueOf(bnd.getInterfaceName().getNamespaceURI()) + sep + bnd.getInterfaceName().getLocalPart() + sep + op.getName().getLocalPart() + sep + msg.getMessageName();
        fragment = this.createTextFragment(actionQName, action);
        message.getSoapHeaders().put(actionQName, fragment);
    }

    @Override
    public Collection<URI> getRoles() {
        return Collections.emptyList();
    }

    @Override
    public Collection<QName> getUnderstoodHeaders() {
        return Collections.emptyList();
    }

    protected DocumentFragment createTextFragment(QName element, String text) {
        Document doc = DomUtil.createDocument();
        DocumentFragment fragment = doc.createDocumentFragment();
        Element el = DomUtil.createElement(fragment, element);
        Text txt = doc.createTextNode(text);
        el.appendChild(txt);
        return fragment;
    }

    protected Wsdl1SoapOperation getOperation(Message message) {
        Operation operation = message.get(Operation.class);
        if (operation == null) {
            throw new Fault("Operation not bound on this message");
        }
        if (!(operation instanceof Wsdl1SoapOperation)) {
            throw new Fault("Message is not bound to a WSDL 1.1 SOAP operation");
        }
        return (Wsdl1SoapOperation)operation;
    }

    protected Wsdl1SoapMessage getMessage(Message message) {
        org.eclipse.ebpm.soap.api.model.Message msg = message.get(org.eclipse.ebpm.soap.api.model.Message.class);
        if (msg == null) {
            throw new Fault("Message not bound on this message");
        }
        if (!(msg instanceof Wsdl1SoapMessage)) {
            throw new Fault("Message is not bound to a WSDL 1.1 SOAP operation message");
        }
        return (Wsdl1SoapMessage)msg;
    }
}

