/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
implements javax.sql.DataSource {
    private Logger logger = LoggerFactory.getLogger(DataSource.class);
    private javax.sql.DataSource internalDS = null;
    private String id = null;
    private BasicDataSourceFactory bdf = new BasicDataSourceFactory();

    protected void activate(ComponentContext componentContext) {
        try {
            PropertyConfigurator propertyConfigurator = new PropertyConfigurator(componentContext.getProperties());
            this.id = propertyConfigurator.getString("id");
            this.internalDS = BasicDataSourceFactory.createDataSource((Properties)propertyConfigurator.asProperties());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot istantiate DataSource", e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.internalDS.getConnection();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new SQLException(e);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.internalDS.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.internalDS.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.internalDS.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.internalDS.setLogWriter(logWriter);
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.internalDS.setLoginTimeout(loginTimeout);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Not Implemented");
    }

    public String getDriverClassName() {
        return ((BasicDataSource)this.internalDS).getDriverClassName();
    }

    public String getUsername() {
        return ((BasicDataSource)this.internalDS).getUsername();
    }

    public String getUrl() {
        return ((BasicDataSource)this.internalDS).getUrl();
    }

    public String getPassword() {
        return ((BasicDataSource)this.internalDS).getPassword();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Thread[" + Thread.currentThread().getId() + "], Datasource [" + this.id + "], Num Active [" + ((BasicDataSource)this.internalDS).getNumActive() + "], Num Idle [" + ((BasicDataSource)this.internalDS).getNumIdle() + "]");
        return sb.toString();
    }
}

