/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.util.properties;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.Dom4JDriver;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ebpm.util.properties.MandatoryPropertyNotFoundException;
import org.eclipse.ebpm.util.resources.IResource;
import org.eclipse.ebpm.util.resources.Resource;

public class PropertyConfigurator {
    private Properties properties;

    public PropertyConfigurator(Properties properties) {
        this.properties = properties;
    }

    public PropertyConfigurator(Dictionary<String, String> propertiesDictionary) {
        this.properties = new Properties();
        if (propertiesDictionary != null && propertiesDictionary.size() > 0) {
            Enumeration<String> keysOfDictionary = propertiesDictionary.keys();
            String key = null;
            while (keysOfDictionary.hasMoreElements()) {
                key = keysOfDictionary.nextElement();
                this.properties.put(key, propertiesDictionary.get(key));
            }
        }
    }

    public Integer getInteger(String propertyName) throws MandatoryPropertyNotFoundException {
        String o = this.getPropertyGeneric(propertyName);
        if (this.isValidStr(o)) {
            return Integer.valueOf(o);
        }
        throw new MandatoryPropertyNotFoundException(propertyName);
    }

    public Long getLong(String propertyName) throws MandatoryPropertyNotFoundException {
        String o = this.getPropertyGeneric(propertyName);
        if (this.isValidStr(o)) {
            return Long.valueOf(o);
        }
        throw new MandatoryPropertyNotFoundException(propertyName);
    }

    public String getString(String propertyName) throws MandatoryPropertyNotFoundException {
        String o = this.getPropertyGeneric(propertyName);
        if (!this.isValidStr(o)) {
            throw new MandatoryPropertyNotFoundException(propertyName);
        }
        return o;
    }

    public Boolean getBoolean(String propertyName) throws MandatoryPropertyNotFoundException {
        String o = this.getPropertyGeneric(propertyName);
        if (o != null) {
            return Boolean.valueOf(o);
        }
        throw new MandatoryPropertyNotFoundException(propertyName);
    }

    public Integer getInteger(String propertyName, Integer defaultInteger) {
        String o = this.getPropertyGeneric(propertyName);
        if (this.isValidStr(o)) {
            return Integer.valueOf(o);
        }
        return defaultInteger;
    }

    public Long getLong(String propertyName, Long defaultLong) {
        String o = this.getPropertyGeneric(propertyName);
        if (this.isValidStr(o)) {
            return Long.valueOf(o);
        }
        return defaultLong;
    }

    public String getString(String propertyName, String defaultString) {
        String o = this.getPropertyGeneric(propertyName);
        if (!this.isValidStr(o)) {
            return defaultString;
        }
        return o;
    }

    public Boolean getBoolean(String propertyName, Boolean defaultBoolean) {
        String o = this.getPropertyGeneric(propertyName);
        if (this.isValidStr(o)) {
            return Boolean.valueOf(o);
        }
        return defaultBoolean;
    }

    protected String getPropertyGeneric(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties asProperties() {
        return this.properties;
    }

    public IResource getResource(String propertyName) {
        String o = this.getPropertyGeneric(propertyName);
        if (!this.isValidStr(o)) {
            throw new MandatoryPropertyNotFoundException(propertyName);
        }
        return new Resource(o);
    }

    public IResource getResource(String propertyName, String defaultValue) {
        String o = this.getPropertyGeneric(propertyName);
        if (this.isValidStr(o)) {
            return new Resource(o);
        }
        if (defaultValue != null) {
            return new Resource(defaultValue);
        }
        return null;
    }

    public Map<String, Properties> getXMapProperty(String propertyName) {
        String o = this.getPropertyGeneric(propertyName);
        if (!this.isValidStr(o)) {
            throw new MandatoryPropertyNotFoundException(propertyName);
        }
        XStream xStream = new XStream((HierarchicalStreamDriver)new Dom4JDriver());
        return (Map)xStream.fromXML(o);
    }

    public List<Properties> getXListProperty(String propertyName) {
        String o = this.getPropertyGeneric(propertyName);
        if (o == null) {
            throw new MandatoryPropertyNotFoundException(propertyName);
        }
        XStream xStream = new XStream();
        return (List)xStream.fromXML(o);
    }

    public boolean isValidStr(String str) {
        return str == null ? false : str.trim().length() > 0;
    }
}

