/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.ftp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.eclipse.ebpm.connectors.ftp.FTPClientPool;
import org.eclipse.ebpm.connectors.ftp.marshaler.FileMarshaler;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpSenderComponent
extends AbstractSpagicConnector {
    protected Logger log = LoggerFactory.getLogger(FtpSenderComponent.class);
    public static final String DEFAULT_MARSHALER = "DEFAULT";
    public static final String PROPERTY_MARSHALER = "marshaler";
    public static final String PROPERTY_UNIQUEFILENAME = "uniqueFileName";
    public static final String PROPERTY_OVERWRITE = "overwrite";
    public static final String PROPERTY_URI = "uri";
    public static final String PROPERTY_UPLOADSUFFIX = "uploadSuffix";
    public static final String PROPERTY_CHECKDUPLICATES = "checkDuplicates";
    public static final String PROPERTY_FOLDER = "folder";
    private FTPClientPool clientPool;
    private String uniqueFileName;
    private boolean overwrite;
    private URI uri;
    private String uploadSuffix;
    private boolean checkDuplicates = true;
    private ConcurrentHashMap<String, FileMarshaler> marshalers = new ConcurrentHashMap();
    private String marshalerId;

    public void init() {
        this.marshalerId = this.propertyConfigurator.getString(PROPERTY_MARSHALER, null);
        try {
            this.clientPool = this.createClientPool();
            this.clientPool.setBinaryMode(this.propertyConfigurator.getBoolean("binaryMode", Boolean.valueOf(true)));
            this.clientPool.setUsername(this.propertyConfigurator.getString("username", "anonymous"));
            this.clientPool.setPassword(this.propertyConfigurator.getString("password", null));
            if (this.propertyConfigurator.getBoolean("passiveMode", null) != null) {
                this.clientPool.setPassiveMode(this.propertyConfigurator.getBoolean("passiveMode"));
            }
            this.clientPool.setHost(this.propertyConfigurator.getString("host"));
            this.clientPool.setPort(this.propertyConfigurator.getInteger("port", Integer.valueOf(21)));
            this.setClientPool(this.clientPool);
        }
        catch (Exception e) {
            this.log.error("Error creating FTPClientPool", (Throwable)e);
        }
        this.setUniqueFileName(this.propertyConfigurator.getString(PROPERTY_UNIQUEFILENAME, "Spagic_"));
        this.setOverwrite(this.propertyConfigurator.getBoolean(PROPERTY_OVERWRITE, Boolean.valueOf(false)));
        try {
            URI uri = this.createUri(this.clientPool, this.propertyConfigurator.getString(PROPERTY_FOLDER, ""));
            this.setUri(uri);
        }
        catch (URISyntaxException e) {
            this.log.error("Error creating URI", (Throwable)e);
        }
        this.setUploadSuffix(this.propertyConfigurator.getString(PROPERTY_UPLOADSUFFIX, ".xml"));
        this.setCheckDuplicates(this.propertyConfigurator.getBoolean(PROPERTY_CHECKDUPLICATES, Boolean.valueOf(true)));
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshalers.put(marshaler.getMarshalerId(), marshaler);
    }

    public void unsetMarshaler(FileMarshaler marshaler) {
        this.marshalers.remove(marshaler.getMarshalerId());
    }

    public FileMarshaler getMarshaler() {
        if (!this.marshalers.containsKey(DEFAULT_MARSHALER)) {
            this.log.error("Default Marshaler not found");
            return null;
        }
        if (this.marshalerId == null) {
            this.log.info("Using Default Marshaler");
            return this.marshalers.get(DEFAULT_MARSHALER);
        }
        if (!this.marshalers.containsKey(this.marshalerId)) {
            this.log.info("Marshaler with id \"" + this.marshalerId + "\" not found. Using Default Marshaler");
            return this.marshalers.get(DEFAULT_MARSHALER);
        }
        return this.marshalers.get(this.marshalerId);
    }

    private URI createUri(FTPClientPool clientPool, String folder) throws URISyntaxException {
        if (clientPool.getUsername().equalsIgnoreCase("anonymous")) {
            clientPool.setPassword("anonymous@anonymous.com");
        }
        String ftpUri = "ftp://" + clientPool.getUsername() + (clientPool.getPassword() != null ? ":" + clientPool.getPassword() : "") + "@" + clientPool.getHost() + ":" + clientPool.getPort() + "/" + folder;
        URI uri = new URI(ftpUri);
        return uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public boolean isCheckDuplicates() {
        return this.checkDuplicates;
    }

    public void setCheckDuplicates(boolean checkDuplicates) {
        this.checkDuplicates = checkDuplicates;
    }

    public FTPClientPool getClientPool() {
        return this.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public String getUniqueFileName() {
        return this.uniqueFileName;
    }

    public void setUniqueFileName(String uniqueFileName) {
        this.uniqueFileName = uniqueFileName;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getUploadSuffix() {
        return this.uploadSuffix;
    }

    public void setUploadSuffix(String uploadSuffix) {
        this.uploadSuffix = uploadSuffix;
    }

    protected FTPClientPool createClientPool() throws Exception {
        FTPClientPool pool = new FTPClientPool();
        pool.afterPropertiesSet();
        return pool;
    }

    protected FTPClient borrowClient() throws Exception {
        try {
            return (FTPClient)this.getClientPool().borrowClient();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected void returnClient(FTPClient client) {
        if (client != null) {
            try {
                this.getClientPool().returnClient((SocketClient)client);
            }
            catch (Exception e) {
                this.log.error("Failed to return client to pool: " + e, (Throwable)e);
            }
        }
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
    }

    public boolean run(Exchange exchange, Message inMessage, Message outMessage) throws Exception {
        FTPClient client = null;
        try {
            client = this.borrowClient();
            if (this.uri != null && this.uri.getPath() != null && !client.changeWorkingDirectory(this.uri.getPath())) {
                this.log.warn("Unable to change ftp directory to '" + this.uri.getPath() + "'");
            }
            OutputStream out = null;
            String uploadName = null;
            String fileName2 = null;
            try {
                List names = this.getMarshaler().getOutputNames(exchange, inMessage);
                for (String fileName2 : names) {
                    if (fileName2 == null) {
                        UUID id = UUID.randomUUID();
                        uploadName = this.uniqueFileName != null ? (this.uploadSuffix == null ? String.valueOf(this.uniqueFileName) + id.toString() : String.valueOf(this.uniqueFileName) + id.toString() + this.uploadSuffix) : (this.uploadSuffix == null ? id.toString() : String.valueOf(id.toString()) + this.uploadSuffix);
                        out = client.storeFileStream(uploadName);
                    } else {
                        if (this.checkDuplicates && client.listFiles(fileName2).length > 0) {
                            if (this.overwrite) {
                                client.deleteFile(fileName2);
                            } else {
                                throw new IOException("Can not send " + fileName2 + " : file already exists and overwrite has not been enabled");
                            }
                        }
                        uploadName = this.uploadSuffix == null ? fileName2 : String.valueOf(fileName2) + this.uploadSuffix;
                        out = client.storeFileStream(uploadName);
                    }
                    if (out == null) {
                        throw new IOException("No output stream available for output name: " + uploadName + ". Maybe the file already exists?");
                    }
                    this.getMarshaler().writeMessage(exchange, inMessage, fileName2, out, uploadName);
                }
            }
            finally {
                inMessage.finalizeAttachments();
                if (out != null) {
                    try {
                        out.close();
                        client.completePendingCommand();
                        if (fileName2 != null && !fileName2.equals(uploadName) && !client.rename(uploadName, fileName2)) {
                            throw new IOException("File " + uploadName + " could not be renamed to " + fileName2);
                        }
                    }
                    catch (IOException e) {
                        this.log.error("Caught exception while closing stream on error: " + e, (Throwable)e);
                    }
                }
                this.returnClient(client);
            }
        }
        catch (Exception e) {
            this.log.error("Error: ", (Throwable)e);
        }
        return true;
    }
}

