/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail.custom.marshaller;

import java.util.Enumeration;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.eclipse.ebpm.connectors.mail.custom.marshaller.PECTransferObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PECMimeMessage {
    protected Logger log = LoggerFactory.getLogger(PECMimeMessage.class);
    public static final int ACCETTAZIONE = 1;
    public static final int PRESA_IN_CARICO = 2;
    public static final int AVVENUTA_CONSEGNA = 3;
    public static final int POSTA_CERTIFICATA = 4;
    public static final int ERRORE_CONSEGNA = 5;
    public static final int ANOMALIA = 6;
    public static final int NESSUN_TIPO_SPECIFICATO = 0;
    private Message pecMsg;
    private String UIDL = "";

    public PECMimeMessage(Message pecMsg) {
        this.pecMsg = pecMsg;
    }

    private int getPECMessageType() throws MessagingException {
        Enumeration e1 = this.pecMsg.getAllHeaders();
        while (e1.hasMoreElements()) {
            Header header = (Header)e1.nextElement();
            this.log.debug(String.valueOf(header.getName()) + ": " + header.getValue());
            if (header.getName().startsWith("X-Ricevuta")) {
                if (header.getValue().equals("accettazione")) {
                    return 1;
                }
                if (header.getValue().equals("presa-in-carico")) {
                    return 2;
                }
                if (header.getValue().equals("avvenuta-consegna")) {
                    return 3;
                }
                if (!header.getValue().equals("errore-consegna")) continue;
                return 5;
            }
            if (!header.getName().startsWith("X-Trasporto")) continue;
            if (header.getValue().equals("errore")) {
                return 6;
            }
            if (!header.getValue().equals("posta-certificata")) continue;
            return 4;
        }
        return 0;
    }

    public PECTransferObject parse() throws Exception {
        PECTransferObject pecTO = new PECTransferObject();
        try {
            this.log.debug("getOriginalMessage->start");
            this.log.debug("getOriginalMessage->Parse the PEC Multipart Message");
            Multipart multiPart = (Multipart)this.pecMsg.getContent();
            pecTO.setType(this.getPECMessageType());
            this.log.debug("getOriginalMessage-> Parsed [" + multiPart.getCount() + "] MIME Part");
            if (multiPart.getCount() != 2) {
                throw new Exception("This MIME Message has [" + multiPart.getCount() + "] Parts, PEC Message must have exactly 2 Part");
            }
            this.log.debug("getOriginalMessage-> Parsing the 0 Part");
            BodyPart bodyPart = multiPart.getBodyPart(0);
            this.log.debug("getOriginalMessage-> Part[0] Content Type + " + bodyPart.getContentType());
            if (bodyPart.getContentType() == null || !bodyPart.getContentType().startsWith("multipart/mixed;")) {
                throw new Exception("Mime Part [0] must be of type multipart/mixed");
            }
            this.log.debug("getOriginalMessage-> Parsing the Body As Multipart Itself");
            MimePartDataSource multipartDataSource = new MimePartDataSource((MimePart)bodyPart);
            MimeMultipart bodyMultiPart = new MimeMultipart((DataSource)multipartDataSource);
            this.log.debug("getOriginalMessage-> bodyMultiPart is built, parsing it");
            BodyPart partOfBody = null;
            String disposition = null;
            int idx = 0;
            while (idx < bodyMultiPart.getCount()) {
                this.log.debug("getOriginalMessage-> Reading the [" + idx + "] Part of the Body");
                partOfBody = bodyMultiPart.getBodyPart(idx);
                disposition = partOfBody.getDisposition();
                this.log.debug("getOriginalMessage-> Part [" + idx + "] has Disposition [" + disposition + "]");
                if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
                    this.log.debug("getOriginalMessage-> Part [" + idx + "] Attached File [" + partOfBody.getFileName() + "]");
                    if (partOfBody.getFileName() != null && partOfBody.getFileName().endsWith(".eml")) {
                        pecTO.setOriginalMessage(new MimeMessage(null, partOfBody.getInputStream()));
                    } else if (partOfBody.getFileName() != null && partOfBody.getFileName().endsWith("daticert.xml")) {
                        SAXReader reader = new SAXReader(false);
                        Document document = reader.read(partOfBody.getInputStream());
                        pecTO.setDatiCert(document.asXML());
                    }
                }
                ++idx;
            }
            return pecTO;
        }
        catch (Exception ex) {
            this.log.error("Exception Occurred ", (Throwable)ex);
            throw new Exception(" Not Valid PEC Message", ex);
        }
    }

    public String getUIDL() {
        return this.UIDL;
    }

    public void setUIDL(String UIDL) {
        this.UIDL = UIDL;
    }

    public Message getPecMsg() {
        return this.pecMsg;
    }

    public void setPecMsg(Message pecMsg) {
        this.pecMsg = pecMsg;
    }
}

