/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipComponent
extends BaseSpagicService {
    public static final String PROPERTY_COPY_ATTACHMENTS = "copyAttachments";
    public static final String PROPERTY_ATTACHMENTS_REGEX = "attachmentsRegEx";
    protected final int BUFFER = 2048;
    protected Logger logger = LoggerFactory.getLogger(UnzipComponent.class);
    protected String attachmentsRegEx = null;

    public void init() {
        try {
            this.setCopyAttachments(this.propertyConfigurator.getBoolean(PROPERTY_COPY_ATTACHMENTS));
            this.attachmentsRegEx = this.propertyConfigurator.getString(PROPERTY_ATTACHMENTS_REGEX, null);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Cannot instantiate Unzip Component", e);
        }
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        block8: {
            Pattern regexPattern = null;
            if (this.attachmentsRegEx != null) {
                regexPattern = Pattern.compile(this.attachmentsRegEx);
            }
            try {
                StringBuffer sb = new StringBuffer();
                Map attachments = in.getAttachments();
                int unzippedFiles = 0;
                sb.append("<ATTACHMENTS>");
                for (String attachmentKey : attachments.keySet()) {
                    ZipEntry entry;
                    DataHandler dh = (DataHandler)attachments.get(attachmentKey);
                    this.logger.debug("Datahandler name: " + dh.getName());
                    this.logger.debug("Datasource name: " + dh.getDataSource().getName());
                    boolean matches = true;
                    if (regexPattern != null) {
                        Matcher m = regexPattern.matcher(dh.getName());
                        matches = m.matches();
                    }
                    if (!matches) continue;
                    ZipInputStream zis = new ZipInputStream(dh.getInputStream());
                    BufferedOutputStream dest = null;
                    while ((entry = zis.getNextEntry()) != null) {
                        int count;
                        this.logger.debug("Extracting: " + entry.getName());
                        byte[] data = new byte[2048];
                        File tempFile = File.createTempFile("spagic-", null);
                        tempFile.deleteOnExit();
                        FileOutputStream fos = new FileOutputStream(tempFile);
                        dest = new BufferedOutputStream(fos, 2048);
                        while ((count = zis.read(data, 0, 2048)) != -1) {
                            dest.write(data, 0, count);
                        }
                        dest.flush();
                        dest.close();
                        FileDataSource fds = new FileDataSource(tempFile);
                        DataHandler newdh = new DataHandler((DataSource)fds);
                        out.addAttachment(entry.getName(), (Object)newdh);
                        sb.append("<ATTACHMENT>");
                        sb.append(entry.getName());
                        sb.append("</ATTACHMENT>");
                        ++unzippedFiles;
                    }
                    zis.close();
                }
                sb.append("</ATTACHMENTS>");
                if (unzippedFiles != 0) {
                    out.setBody(sb.toString());
                    break block8;
                }
                this.fail(exchange, new RuntimeException("No files unzipped"));
                return false;
            }
            catch (Throwable th) {
                this.logger.error("Error unzipping files", th);
                this.fail(exchange, new RuntimeException(th.getMessage()));
            }
        }
        return true;
    }
}

