/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Version;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)Check.java\t1.165 07/03/27")
public class Check {
    protected static final Context.Key<Check> checkKey = new Context.Key();
    private final Name.Table names;
    private final Log log;
    private final Symtab syms;
    private final Infer infer;
    private final Target target;
    private final Source source;
    private final Types types;
    private final boolean skipAnnotations;
    private Lint lint;
    boolean allowGenerics;
    boolean allowAnnotations;
    boolean complexInference;
    public Map<Name, Symbol.ClassSymbol> compiled = new HashMap<Name, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private Validator validator = new Validator();
    Warner overrideWarner = new Warner();

    public static Check instance(Context context) {
        Check check = context.get(checkKey);
        if (check == null) {
            check = new Check(context);
        }
        return check;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        Options options = Options.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.lint = Lint.instance(context);
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowAnnotations = source.allowAnnotations();
        this.complexInference = options.get("-complexinference") != null;
        this.skipAnnotations = options.get("skipAnnotations") != null;
        boolean bl = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean bl2 = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        boolean bl3 = source.enforceMandatoryWarnings();
        this.deprecationHandler = new MandatoryWarningHandler(this.log, bl, bl3, "deprecated");
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, bl2, bl3, "unchecked");
    }

    Lint setLint(Lint lint) {
        Lint lint2 = this.lint;
        this.lint = lint;
        return lint2;
    }

    void warnDeprecated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            this.deprecationHandler.report(diagnosticPosition, "has.been.deprecated", symbol, symbol.location());
        }
    }

    public void warnUnchecked(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(diagnosticPosition, string, objectArray);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
    }

    public Type completionError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.CompletionFailure completionFailure) {
        this.log.error(diagnosticPosition, "cant.access", completionFailure.sym, completionFailure.errmsg);
        if (completionFailure instanceof ClassReader.BadClassFile) {
            throw new Abort();
        }
        return this.syms.errType;
    }

    Type typeError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Object object, Type type, Type type2) {
        this.log.error(diagnosticPosition, "prob.found.req", object, type, type2);
        return this.syms.errType;
    }

    Type typeError(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Type type, Type type2, Object object) {
        this.log.error(diagnosticPosition, "prob.found.req.1", string, type, type2, object);
        return this.syms.errType;
    }

    Type typeTagError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Object object, Object object2) {
        this.log.error(diagnosticPosition, "type.found.req", object2, object);
        return this.syms.errType;
    }

    void earlyRefError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        this.log.error(diagnosticPosition, "cant.ref.before.ctor.called", symbol);
    }

    void duplicateError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (!symbol.type.isErroneous()) {
            this.log.error(diagnosticPosition, "already.defined", symbol, symbol.location());
        }
    }

    void varargsDuplicateError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        if (!symbol.type.isErroneous() && !symbol2.type.isErroneous()) {
            this.log.error(diagnosticPosition, "array.and.varargs", symbol, symbol2, symbol2.location());
        }
    }

    void checkTransparentVar(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol, Scope scope) {
        if (scope.next != null) {
            Scope.Entry entry = scope.next.lookup(varSymbol.name);
            while (entry.scope != null && entry.sym.owner == varSymbol.owner) {
                if (entry.sym.kind == 4 && (entry.sym.owner.kind & 0x14) != 0 && varSymbol.name != this.names.error) {
                    this.duplicateError(diagnosticPosition, entry.sym);
                    return;
                }
                entry = entry.next();
            }
        }
    }

    void checkTransparentClass(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol, Scope scope) {
        if (scope.next != null) {
            Scope.Entry entry = scope.next.lookup(classSymbol.name);
            while (entry.scope != null && entry.sym.owner == classSymbol.owner) {
                if (entry.sym.kind == 2 && (entry.sym.owner.kind & 0x14) != 0 && classSymbol.name != this.names.error) {
                    this.duplicateError(diagnosticPosition, entry.sym);
                    return;
                }
                entry = entry.next();
            }
        }
    }

    boolean checkUniqueClassName(JCDiagnostic.DiagnosticPosition diagnosticPosition, Name name, Scope scope) {
        Object object = scope.lookup(name);
        while (((Scope.Entry)object).scope == scope) {
            if (((Scope.Entry)object).sym.kind == 2 && ((Scope.Entry)object).sym.name != this.names.error) {
                this.duplicateError(diagnosticPosition, ((Scope.Entry)object).sym);
                return false;
            }
            object = ((Scope.Entry)object).next();
        }
        object = scope.owner;
        while (object != null) {
            if (((Symbol)object).kind == 2 && ((Symbol)object).name == name && ((Symbol)object).name != this.names.error) {
                this.duplicateError(diagnosticPosition, (Symbol)object);
                return true;
            }
            object = ((Symbol)object).owner;
        }
        return true;
    }

    Name localClassName(Symbol.ClassSymbol classSymbol) {
        int n = 1;
        Name name;
        while (this.compiled.get(name = this.names.fromString("" + classSymbol.owner.enclClass().flatname + this.target.syntheticNameChar() + n + classSymbol.name)) != null) {
            ++n;
        }
        return name;
    }

    Type checkType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        if (type2.tag == 19) {
            return type2;
        }
        if (type.tag == 16) {
            return this.instantiatePoly(diagnosticPosition, (Type.ForAll)type, type2, this.convertWarner(diagnosticPosition, type, type2));
        }
        if (type2.tag == 18) {
            return type;
        }
        if (this.types.isAssignable(type, type2, this.convertWarner(diagnosticPosition, type, type2))) {
            return type;
        }
        if (type.tag <= 7 && type2.tag <= 7) {
            return this.typeError(diagnosticPosition, JCDiagnostic.fragment("possible.loss.of.precision", new Object[0]), type, type2);
        }
        if (type.isSuperBound()) {
            this.log.error(diagnosticPosition, "assignment.from.super-bound", type);
            return this.syms.errType;
        }
        if (type2.isExtendsBound()) {
            this.log.error(diagnosticPosition, "assignment.to.extends-bound", type2);
            return this.syms.errType;
        }
        return this.typeError(diagnosticPosition, JCDiagnostic.fragment("incompatible.types", new Object[0]), type, type2);
    }

    Type instantiatePoly(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type.ForAll forAll, Type type, Warner warner) {
        if (type == Infer.anyPoly && this.complexInference) {
            return forAll;
        }
        if (type == Infer.anyPoly || type.tag == 18) {
            Type type2 = forAll.qtype.tag <= 9 ? forAll.qtype : this.syms.objectType;
            return this.instantiatePoly(diagnosticPosition, forAll, type2, warner);
        }
        if (type.tag == 19) {
            return type;
        }
        try {
            return this.infer.instantiateExpr(forAll, type, warner);
        }
        catch (Infer.NoInstanceException noInstanceException) {
            if (noInstanceException.isAmbiguous) {
                JCDiagnostic jCDiagnostic = noInstanceException.getDiagnostic();
                this.log.error(diagnosticPosition, "undetermined.type" + (jCDiagnostic != null ? ".1" : ""), forAll, jCDiagnostic);
                return this.syms.errType;
            }
            JCDiagnostic jCDiagnostic = noInstanceException.getDiagnostic();
            return this.typeError(diagnosticPosition, JCDiagnostic.fragment("incompatible.types" + (jCDiagnostic != null ? ".1" : ""), jCDiagnostic), forAll, type);
        }
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        if (type.tag == 16) {
            this.instantiatePoly(diagnosticPosition, (Type.ForAll)type, type2, this.castWarner(diagnosticPosition, type, type2));
            return type2;
        }
        if (this.types.isCastable(type, type2, this.castWarner(diagnosticPosition, type, type2))) {
            return type2;
        }
        return this.typeError(diagnosticPosition, JCDiagnostic.fragment("inconvertible.types", new Object[0]), type, type2);
    }

    boolean isTypeVar(Type type) {
        return type.tag == 14 || type.tag == 11 && this.isTypeVar(this.types.elemtype(type));
    }

    private void checkExtends(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type.TypeVar typeVar) {
        if (type.isUnbound()) {
            return;
        }
        if (type.tag != 15) {
            type = this.types.upperBound(type);
            List<Type> list = this.types.getBounds(typeVar);
            while (list.nonEmpty()) {
                if (!this.types.isSubtype(type, (Type)list.head)) {
                    this.log.error(diagnosticPosition, "not.within.bounds", type);
                    return;
                }
                list = list.tail;
            }
        } else if (type.isExtendsBound()) {
            if (!this.types.isCastable(typeVar.getUpperBound(), this.types.upperBound(type), Warner.noWarnings)) {
                this.log.error(diagnosticPosition, "not.within.bounds", type);
            }
        } else if (type.isSuperBound() && this.types.notSoftSubtype(this.types.lowerBound(type), typeVar.getUpperBound())) {
            this.log.error(diagnosticPosition, "not.within.bounds", type);
        }
    }

    Type checkNonVoid(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.tag == 9) {
            this.log.error(diagnosticPosition, "void.not.allowed.here", new Object[0]);
            return this.syms.errType;
        }
        return type;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.tag != 10 && type.tag != 19) {
            return this.typeTagError(diagnosticPosition, JCDiagnostic.fragment("type.req.class", new Object[0]), type.tag == 14 ? JCDiagnostic.fragment("type.parameter", type) : type);
        }
        return type;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, boolean bl) {
        type = this.checkClassType(diagnosticPosition, type);
        if (bl && type.isParameterized()) {
            List<Type> list = type.getTypeArguments();
            while (list.nonEmpty()) {
                if (((Type)list.head).tag == 15) {
                    return this.typeTagError(diagnosticPosition, Log.getLocalizedString("type.req.exact", new Object[0]), list.head);
                }
                list = list.tail;
            }
        }
        return type;
    }

    Type checkReifiableReferenceType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 19) {
            return this.typeTagError(diagnosticPosition, JCDiagnostic.fragment("type.req.class.array", new Object[0]), type);
        }
        if (!this.types.isReifiable(type)) {
            this.log.error(diagnosticPosition, "illegal.generic.type.for.instof", new Object[0]);
            return this.syms.errType;
        }
        return type;
    }

    Type checkRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        switch (type.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                return type;
            }
        }
        return this.typeTagError(diagnosticPosition, JCDiagnostic.fragment("type.req.ref", new Object[0]), type);
    }

    Type checkNullOrRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        switch (type.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                return type;
            }
        }
        return this.typeTagError(diagnosticPosition, JCDiagnostic.fragment("type.req.ref", new Object[0]), type);
    }

    boolean checkDisjoint(JCDiagnostic.DiagnosticPosition diagnosticPosition, long l, long l2, long l3) {
        if ((l & l2) != 0L && (l & l3) != 0L) {
            this.log.error(diagnosticPosition, "illegal.combination.of.modifiers", TreeInfo.flagNames(TreeInfo.firstFlag(l & l2)), TreeInfo.flagNames(TreeInfo.firstFlag(l & l3)));
            return false;
        }
        return true;
    }

    long checkFlags(JCDiagnostic.DiagnosticPosition diagnosticPosition, long l, Symbol symbol, JCTree jCTree) {
        long l2;
        long l3 = 0L;
        switch (symbol.kind) {
            case 4: {
                if (symbol.owner.kind != 2) {
                    l2 = 0x200000010L;
                    break;
                }
                if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    l3 = 25L;
                    l2 = 25L;
                    break;
                }
                l2 = 16607L;
                break;
            }
            case 16: {
                if (symbol.name == this.names.init) {
                    if ((symbol.owner.flags_field & 0x4000L) != 0L) {
                        l3 = 2L;
                        l2 = 2L;
                    } else {
                        l2 = 7L;
                    }
                } else if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    l3 = 1025L;
                    l2 = 1025L;
                } else {
                    l2 = 3391L;
                }
                if (((l | l3) & 0x400L) != 0L) break;
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            case 2: {
                if (symbol.isLocal()) {
                    l2 = 23568L;
                    if (symbol.name.len == 0) {
                        l2 |= 8L;
                        l3 |= 0x10L;
                    }
                    if ((symbol.owner.flags_field & 8L) == 0L && (l & 0x4000L) != 0L) {
                        this.log.error(diagnosticPosition, "enums.must.be.static", new Object[0]);
                    }
                } else if (symbol.owner.kind == 2) {
                    l2 = 24087L;
                    if (symbol.owner.owner.kind == 1 || (symbol.owner.flags_field & 8L) != 0L) {
                        l2 |= 8L;
                    } else if ((l & 0x4000L) != 0L) {
                        this.log.error(diagnosticPosition, "enums.must.be.static", new Object[0]);
                    }
                    if ((l & 0x4200L) != 0L) {
                        l3 = 8L;
                    }
                } else {
                    l2 = 32273L;
                }
                if ((l & 0x200L) != 0L) {
                    l3 |= 0x400L;
                }
                if ((l & 0x4000L) != 0L) {
                    l2 &= 0xFFFFFFFFFFFFFBEFL;
                    l3 |= this.implicitEnumFinalFlag(jCTree);
                }
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long l4 = l & 0xFFFL & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (l4 != 0L) {
            if ((l4 & 0x200L) != 0L) {
                this.log.error(diagnosticPosition, "intf.not.allowed.here", new Object[0]);
                l2 |= 0x200L;
            } else {
                this.log.error(diagnosticPosition, "mod.not.allowed.here", TreeInfo.flagNames(l4));
            }
        } else if (symbol.kind != 2 && !this.checkDisjoint(diagnosticPosition, l, 1024L, 10L) || !this.checkDisjoint(diagnosticPosition, l, 1536L, 304L) || !this.checkDisjoint(diagnosticPosition, l, 1L, 6L) || !this.checkDisjoint(diagnosticPosition, l, 2L, 5L) || !this.checkDisjoint(diagnosticPosition, l, 16L, 64L) || symbol.kind == 2 || this.checkDisjoint(diagnosticPosition, l, 1280L, 2048L)) {
            // empty if block
        }
        return l & (l2 | 0xFFFFFFFFFFFFF000L) | l3;
    }

    private long implicitEnumFinalFlag(JCTree jCTree) {
        if (jCTree.tag != 3) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends JCTree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            public void visitTree(JCTree jCTree) {
            }

            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                if ((jCVariableDecl.mods.flags & 0x4000L) != 0L && jCVariableDecl.init instanceof JCTree.JCNewClass && ((JCTree.JCNewClass)jCVariableDecl.init).def != null) {
                    this.specialized = true;
                }
            }
        }
        SpecialTreeVisitor specialTreeVisitor = new SpecialTreeVisitor();
        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
        for (JCTree jCTree2 : jCClassDecl.defs) {
            jCTree2.accept(specialTreeVisitor);
            if (!specialTreeVisitor.specialized) continue;
            return 0L;
        }
        return 16L;
    }

    void validate(JCTree jCTree) {
        try {
            if (jCTree != null) {
                jCTree.accept(this.validator);
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(jCTree.pos(), completionFailure);
        }
    }

    void validate(List<? extends JCTree> list) {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.validate((JCTree)list2.head);
            list2 = list2.tail;
        }
    }

    void validateTypeParams(List<JCTree.JCTypeParameter> list) {
        List<JCTree.JCTypeParameter> list2 = list;
        while (list2.nonEmpty()) {
            this.validate((JCTree)list2.head);
            list2 = list2.tail;
        }
    }

    boolean subset(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubtype(type, (Type)list2.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    boolean intersects(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubtype(type, (Type)list2.head) || this.types.isSubtype((Type)list2.head, type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    List<Type> incl(Type type, List<Type> list) {
        return this.subset(type, list) ? list : this.excl(type, list).prepend(type);
    }

    List<Type> excl(Type type, List<Type> list) {
        if (list.isEmpty()) {
            return list;
        }
        List<Type> list2 = this.excl(type, list.tail);
        if (this.types.isSubtype((Type)list.head, type)) {
            return list2;
        }
        if (list2 == list.tail) {
            return list;
        }
        return list2.prepend((Type)list.head);
    }

    List<Type> union(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.incl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    List<Type> diff(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.excl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    public List<Type> intersect(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list2)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        list4 = list2;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    boolean isUnchecked(Symbol.ClassSymbol classSymbol) {
        return classSymbol.kind == 31 || classSymbol.isSubClass(this.syms.errorType.tsym, this.types) || classSymbol.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type type) {
        return type.tag == 14 ? this.isUnchecked(this.types.supertype(type)) : (type.tag == 10 ? this.isUnchecked((Symbol.ClassSymbol)type.tsym) : type.tag == 17);
    }

    boolean isUnchecked(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        try {
            return this.isUnchecked(type);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(diagnosticPosition, completionFailure);
            return true;
        }
    }

    boolean isHandled(Type type, List<Type> list) {
        return this.isUnchecked(type) || this.subset(type, list);
    }

    List<Type> unHandled(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (!this.isHandled((Type)list4.head, list2)) {
                list3 = list3.prepend((Type)list4.head);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    static int protection(long l) {
        switch ((short)(l & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    private static String protectionString(long l) {
        long l2 = l & 7L;
        return l2 == 0L ? "package" : TreeInfo.flagNames(l2);
    }

    static Object cannotOverride(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "cant.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "cant.implement" : "clashes.with");
        return JCDiagnostic.fragment(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    static Object uncheckedOverrides(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "unchecked.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "unchecked.implement" : "unchecked.clash.with");
        return JCDiagnostic.fragment(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    static Object varargsOverrides(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "varargs.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "varargs.implement" : "varargs.clash.with");
        return JCDiagnostic.fragment(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    void checkOverride(JCTree jCTree, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, Symbol.ClassSymbol classSymbol) {
        if ((methodSymbol.flags() & 0x80001000L) != 0L || (methodSymbol2.flags() & 0x1000L) != 0L) {
            return;
        }
        if ((methodSymbol.flags() & 8L) != 0L && (methodSymbol2.flags() & 8L) == 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.static", Check.cannotOverride(methodSymbol, methodSymbol2));
            return;
        }
        if ((methodSymbol2.flags() & 0x10L) != 0L || (methodSymbol.flags() & 8L) == 0L && (methodSymbol2.flags() & 8L) != 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.meth", Check.cannotOverride(methodSymbol, methodSymbol2), TreeInfo.flagNames(methodSymbol2.flags() & 0x18L));
            return;
        }
        if ((methodSymbol.owner.flags() & 0x2000L) != 0L) {
            return;
        }
        if ((classSymbol.flags() & 0x200L) == 0L && Check.protection(methodSymbol.flags()) > Check.protection(methodSymbol2.flags())) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.weaker.access", Check.cannotOverride(methodSymbol, methodSymbol2), Check.protectionString(methodSymbol2.flags()));
            return;
        }
        Type type = this.types.memberType(classSymbol.type, methodSymbol);
        Type type2 = this.types.memberType(classSymbol.type, methodSymbol2);
        List<Type> list = type.getTypeArguments();
        List<Type> list2 = type2.getTypeArguments();
        Type type3 = type.getReturnType();
        Type type4 = this.types.subst(type2.getReturnType(), list2, list);
        this.overrideWarner.warned = false;
        boolean bl = this.types.returnTypeSubstitutable(type, type2, type4, this.overrideWarner);
        if (!bl) {
            if (this.source.allowCovariantReturns() || methodSymbol.owner == classSymbol || !methodSymbol.owner.isSubClass(methodSymbol2.owner, this.types)) {
                this.typeError(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), JCDiagnostic.fragment("override.incompatible.ret", Check.cannotOverride(methodSymbol, methodSymbol2)), type3, type4);
                return;
            }
        } else if (this.overrideWarner.warned) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "prob.found.req", JCDiagnostic.fragment("override.unchecked.ret", Check.uncheckedOverrides(methodSymbol, methodSymbol2)), type3, type4);
        }
        List<Type> list3 = this.types.subst(type2.getThrownTypes(), list2, list);
        List<Type> list4 = this.unHandled(type.getThrownTypes(), list3);
        if (list4.nonEmpty()) {
            this.log.error(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.meth.doesnt.throw", Check.cannotOverride(methodSymbol, methodSymbol2), list4.head);
            return;
        }
        if (((methodSymbol.flags() ^ methodSymbol2.flags()) & 0x400000000L) != 0L && this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            this.log.warning(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), (methodSymbol.flags() & 0x400000000L) != 0L ? "override.varargs.missing" : "override.varargs.extra", Check.varargsOverrides(methodSymbol, methodSymbol2));
        }
        if ((methodSymbol2.flags() & 0x80000000L) != 0L) {
            this.log.warning(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), "override.bridge", Check.uncheckedOverrides(methodSymbol, methodSymbol2));
        }
        if ((methodSymbol2.flags() & 0x20000L) != 0L && (methodSymbol.flags() & 0x20000L) == 0L && methodSymbol.outermostClass() != methodSymbol2.outermostClass() && !this.isDeprecatedOverrideIgnorable(methodSymbol2, classSymbol)) {
            this.warnDeprecated(TreeInfo.diagnosticPositionFor(methodSymbol, jCTree), methodSymbol2);
        }
    }

    private boolean isDeprecatedOverrideIgnorable(Symbol.MethodSymbol methodSymbol, Symbol.ClassSymbol classSymbol) {
        Symbol.ClassSymbol classSymbol2 = methodSymbol.enclClass();
        Type type = this.types.supertype(classSymbol.type);
        if (type.tag != 10) {
            return true;
        }
        Symbol.MethodSymbol methodSymbol2 = methodSymbol.implementation((Symbol.ClassSymbol)type.tsym, this.types, false);
        if (classSymbol2 != null && (classSymbol2.flags() & 0x200L) != 0L) {
            List<Type> list = this.types.interfaces(classSymbol.type);
            return list.contains(classSymbol2.type) ? false : methodSymbol2 != null;
        }
        return methodSymbol2 != methodSymbol;
    }

    public void checkCompatibleConcretes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        Type type2 = this.types.supertype(type);
        if (type2.tag != 10) {
            return;
        }
        Type type3 = type2;
        while (type3.tsym.type.isParameterized()) {
            Scope.Entry entry = type3.tsym.members().elems;
            while (entry != null) {
                Symbol symbol = entry.sym;
                if (symbol.kind == 16 && (symbol.flags() & 0x80001008L) == 0L && symbol.isInheritedIn(type.tsym, this.types) && ((Symbol.MethodSymbol)symbol).implementation(type.tsym, this.types, true) == symbol) {
                    Type type4 = this.types.memberType(type3, symbol);
                    int n = type4.getParameterTypes().length();
                    if (type4 != symbol.type) {
                        Type type5 = type2;
                        while (type5.tag == 10) {
                            Scope.Entry entry2 = type3.tsym.members().lookup(symbol.name);
                            while (entry2.scope != null) {
                                Type type6;
                                Symbol symbol2 = entry2.sym;
                                if (symbol2 != symbol && symbol2.kind == 16 && (symbol2.flags() & 0x80001008L) == 0L && symbol2.type.getParameterTypes().length() == n && symbol2.isInheritedIn(type.tsym, this.types) && ((Symbol.MethodSymbol)symbol2).implementation(type.tsym, this.types, true) == symbol2 && this.types.overrideEquivalent(type4, type6 = this.types.memberType(type5, symbol2))) {
                                    this.log.error(diagnosticPosition, "concrete.inheritance.conflict", symbol, type3, symbol2, type5, type2);
                                }
                                entry2 = entry2.next();
                            }
                            type5 = this.types.supertype(type5);
                        }
                    }
                }
                entry = entry.sibling;
            }
            type3 = this.types.supertype(type3);
        }
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return this.checkCompatibleAbstracts(diagnosticPosition, type, type2, this.types.makeCompoundType(type, type2));
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, Type type3) {
        Symbol symbol = this.firstIncompatibility(type, type2, type3);
        if (symbol != null) {
            this.log.error(diagnosticPosition, "types.incompatible.diff.ret", type, type2, symbol.name + "(" + this.types.memberType(type2, symbol).getParameterTypes() + ")");
            return false;
        }
        return true;
    }

    private Symbol firstIncompatibility(Type type, Type type2, Type type3) {
        HashMap<Symbol.TypeSymbol, Type> hashMap;
        HashMap<Symbol.TypeSymbol, Type> hashMap2 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(type, hashMap2);
        if (type == type2) {
            hashMap = hashMap2;
        } else {
            hashMap = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(type2, hashMap2, hashMap);
        }
        for (Type type4 : hashMap2.values()) {
            for (Type type5 : hashMap.values()) {
                Symbol symbol = this.firstDirectIncompatibility(type4, type5, type3);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return null;
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map) {
        if (type.tag != 10) {
            return;
        }
        if (map.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map);
            }
        }
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map, Map<Symbol.TypeSymbol, Type> map2) {
        if (type.tag != 10) {
            return;
        }
        if (map.get(type.tsym) != null) {
            return;
        }
        if (map2.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map, map2);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map, map2);
            }
        }
    }

    private Symbol firstDirectIncompatibility(Type type, Type type2, Type type3) {
        Scope.Entry entry = type.tsym.members().elems;
        while (entry != null) {
            Symbol.MethodSymbol methodSymbol;
            Symbol symbol = entry.sym;
            Type type4 = null;
            if (symbol.kind == 16 && symbol.isInheritedIn(type3.tsym, this.types) && ((methodSymbol = ((Symbol.MethodSymbol)symbol).implementation(type3.tsym, this.types, false)) == null || (methodSymbol.flags() & 0x400L) != 0L)) {
                Scope.Entry entry2 = type2.tsym.members().lookup(symbol.name);
                while (entry2.scope != null) {
                    Symbol symbol2 = entry2.sym;
                    if (symbol != symbol2 && symbol2.kind == 16 && symbol2.isInheritedIn(type3.tsym, this.types)) {
                        Type type5;
                        if (type4 == null) {
                            type4 = this.types.memberType(type, symbol);
                        }
                        if (this.types.overrideEquivalent(type4, type5 = this.types.memberType(type2, symbol2))) {
                            Type type6;
                            boolean bl;
                            List<Type> list = type4.getTypeArguments();
                            List<Type> list2 = type5.getTypeArguments();
                            Type type7 = type4.getReturnType();
                            boolean bl2 = bl = this.types.isSameType(type7, type6 = this.types.subst(type5.getReturnType(), list2, list)) || type7.tag >= 10 && type6.tag >= 10 && (this.types.covariantReturnType(type7, type6, Warner.noWarnings) || this.types.covariantReturnType(type6, type7, Warner.noWarnings));
                            if (!bl) {
                                return symbol2;
                            }
                        }
                    }
                    entry2 = entry2.next();
                }
            }
            entry = entry.sibling;
        }
        return null;
    }

    void checkOverride(JCTree jCTree, Symbol.MethodSymbol methodSymbol) {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        if ((classSymbol.flags() & 0x4000L) != 0L && this.names.finalize.equals(methodSymbol.name) && methodSymbol.overrides(this.syms.enumFinalFinalize, classSymbol, this.types, false)) {
            this.log.error(jCTree.pos(), "enum.no.finalize", new Object[0]);
            return;
        }
        Type type = this.types.supertype(classSymbol.type);
        while (type.tag == 10) {
            Symbol.TypeSymbol typeSymbol = type.tsym;
            Scope.Entry entry = typeSymbol.members().lookup(methodSymbol.name);
            while (entry.scope != null) {
                if (methodSymbol.overrides(entry.sym, classSymbol, this.types, false)) {
                    this.checkOverride(jCTree, methodSymbol, (Symbol.MethodSymbol)entry.sym, classSymbol);
                }
                entry = entry.next();
            }
            type = this.types.supertype(type);
        }
    }

    void checkAllDefined(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        try {
            Symbol.MethodSymbol methodSymbol = this.firstUndef(classSymbol, classSymbol);
            if (methodSymbol != null) {
                if ((classSymbol.flags() & 0x4000L) != 0L && this.types.supertype((Type)classSymbol.type).tsym == this.syms.enumSym && (classSymbol.flags() & 0x10L) == 0L) {
                    classSymbol.flags_field |= 0x400L;
                } else {
                    Symbol.MethodSymbol methodSymbol2 = new Symbol.MethodSymbol(methodSymbol.flags(), methodSymbol.name, this.types.memberType(classSymbol.type, methodSymbol), methodSymbol.owner);
                    this.log.error(diagnosticPosition, "does.not.override.abstract", classSymbol, methodSymbol2, methodSymbol2.location());
                }
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(diagnosticPosition, completionFailure);
        }
    }

    private Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2) {
        Symbol.MethodSymbol methodSymbol = null;
        if (classSymbol2 == classSymbol || (classSymbol2.flags() & 0x600L) != 0L) {
            Scope scope = classSymbol2.members();
            List list = scope.elems;
            while (methodSymbol == null && list != null) {
                Symbol.MethodSymbol methodSymbol2;
                Symbol.MethodSymbol methodSymbol3;
                if (((Scope.Entry)((Object)list)).sym.kind == 16 && (((Scope.Entry)((Object)list)).sym.flags() & 0x200400L) == 1024L && ((methodSymbol3 = (methodSymbol2 = (Symbol.MethodSymbol)((Scope.Entry)((Object)list)).sym).implementation(classSymbol, this.types, true)) == null || methodSymbol3 == methodSymbol2)) {
                    methodSymbol = methodSymbol2;
                }
                list = ((Scope.Entry)((Object)list)).sibling;
            }
            if (methodSymbol == null) {
                list = this.types.supertype(classSymbol2.type);
                if (((Type)((Object)list)).tag == 10) {
                    methodSymbol = this.firstUndef(classSymbol, (Symbol.ClassSymbol)((Type)((Object)list)).tsym);
                }
            }
            list = this.types.interfaces(classSymbol2.type);
            while (methodSymbol == null && list.nonEmpty()) {
                methodSymbol = this.firstUndef(classSymbol, (Symbol.ClassSymbol)((Type)list.head).tsym);
                list = list.tail;
            }
        }
        return methodSymbol;
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkNonCyclicInternal(diagnosticPosition, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        boolean bl = true;
        Symbol.TypeSymbol typeSymbol = type.tsym;
        if ((typeSymbol.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(diagnosticPosition, (Symbol.ClassSymbol)typeSymbol);
        } else if (!typeSymbol.type.isErroneous()) {
            try {
                typeSymbol.flags_field |= 0x8000000L;
                if (typeSymbol.type.tag == 10) {
                    List list;
                    Type.ClassType classType = (Type.ClassType)typeSymbol.type;
                    if (classType.interfaces_field != null) {
                        list = classType.interfaces_field;
                        while (list.nonEmpty()) {
                            bl &= this.checkNonCyclicInternal(diagnosticPosition, (Type)list.head);
                            list = list.tail;
                        }
                    }
                    if (classType.supertype_field != null && (list = classType.supertype_field) != null && ((Type)((Object)list)).tag == 10) {
                        bl &= this.checkNonCyclicInternal(diagnosticPosition, (Type)((Object)list));
                    }
                    if (typeSymbol.owner.kind == 2) {
                        bl &= this.checkNonCyclicInternal(diagnosticPosition, typeSymbol.owner.type);
                    }
                }
                Object var8_7 = null;
                typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
                throw throwable;
            }
        }
        if (bl) {
            boolean bl2 = bl = (typeSymbol.flags_field & 0x10000000L) == 0L && typeSymbol.completer == null;
        }
        if (bl) {
            typeSymbol.flags_field |= 0x40000000L;
        }
        return bl;
    }

    private void noteCyclic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        this.log.error(diagnosticPosition, "cyclic.inheritance", classSymbol);
        List list = this.types.interfaces(classSymbol.type);
        while (list.nonEmpty()) {
            list.head = new Type.ErrorType((Symbol.ClassSymbol)((Type)list.head).tsym);
            list = list.tail;
        }
        list = this.types.supertype(classSymbol.type);
        if (((Type)((Object)list)).tag == 10) {
            ((Type.ClassType)classSymbol.type).supertype_field = new Type.ErrorType((Symbol.ClassSymbol)((Type)((Object)list)).tsym);
        }
        classSymbol.type = new Type.ErrorType(classSymbol);
        classSymbol.flags_field |= 0x40000000L;
    }

    void checkImplementations(JCTree.JCClassDecl jCClassDecl) {
        this.checkImplementations(jCClassDecl, jCClassDecl.sym);
    }

    void checkImplementations(JCTree.JCClassDecl jCClassDecl, Symbol.ClassSymbol classSymbol) {
        Symbol.ClassSymbol classSymbol2 = jCClassDecl.sym;
        List<Type> list = this.types.closure(classSymbol.type);
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol3 = (Symbol.ClassSymbol)((Type)list.head).tsym;
            if ((this.allowGenerics || classSymbol2 != classSymbol3) && (classSymbol3.flags() & 0x400L) != 0L) {
                Scope.Entry entry = classSymbol3.members().elems;
                while (entry != null) {
                    Symbol.MethodSymbol methodSymbol;
                    Symbol.MethodSymbol methodSymbol2;
                    if (entry.sym.kind == 16 && (entry.sym.flags() & 0x408L) == 1024L && (methodSymbol2 = (methodSymbol = (Symbol.MethodSymbol)entry.sym).implementation(classSymbol2, this.types, false)) != null && methodSymbol2 != methodSymbol && (methodSymbol2.owner.flags() & 0x200L) == (classSymbol2.flags() & 0x200L)) {
                        this.checkOverride(jCClassDecl, methodSymbol2, methodSymbol, classSymbol2);
                    }
                    entry = entry.sibling;
                }
            }
            list = list.tail;
        }
    }

    void checkCompatibleSupertypes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        List<Type> list = this.types.interfaces(type);
        Type type2 = this.types.supertype(type);
        if (type2.tag == 10 && (type2.tsym.flags() & 0x400L) != 0L) {
            list = list.prepend(type2);
        }
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.allowGenerics && !((Type)list2.head).getTypeArguments().isEmpty() && !this.checkCompatibleAbstracts(diagnosticPosition, (Type)list2.head, (Type)list2.head, type)) {
                return;
            }
            List<Type> list3 = list;
            while (list3 != list2) {
                if (!this.checkCompatibleAbstracts(diagnosticPosition, (Type)list2.head, (Type)list3.head, type)) {
                    return;
                }
                list3 = list3.tail;
            }
            list2 = list2.tail;
        }
        this.checkCompatibleConcretes(diagnosticPosition, type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkClassBounds(diagnosticPosition, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition diagnosticPosition, Map<Symbol.TypeSymbol, Type> map, Type type) {
        if (type.isErroneous()) {
            return;
        }
        Object object = this.types.interfaces(type);
        while (((List)object).nonEmpty()) {
            List<Type> list;
            List<Type> list2;
            Type type2 = (Type)((List)object).head;
            Type type3 = map.put(type2.tsym, type2);
            if (type3 != null && !this.types.containsTypeEquivalent(list2 = type3.allparams(), list = type2.allparams())) {
                this.log.error(diagnosticPosition, "cant.inherit.diff.arg", type2.tsym, Type.toString(list2), Type.toString(list));
            }
            this.checkClassBounds(diagnosticPosition, map, type2);
            object = ((List)object).tail;
        }
        object = this.types.supertype(type);
        if (object != null) {
            this.checkClassBounds(diagnosticPosition, map, (Type)object);
        }
    }

    void checkNotRepeated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Set<Type> set) {
        if (set.contains(type)) {
            this.log.error(diagnosticPosition, "repeated.interface", new Object[0]);
        } else {
            set.add(type);
        }
    }

    void validateAnnotationType(JCTree jCTree) {
        if (jCTree != null) {
            this.validateAnnotationType(jCTree.pos(), jCTree.type);
        }
    }

    void validateAnnotationType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.lowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(diagnosticPosition, this.types.elemtype(type));
            return;
        }
        this.log.error(diagnosticPosition, "invalid.annotation.member.type", new Object[0]);
    }

    void validateAnnotationMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.MethodSymbol methodSymbol) {
        Type type = this.syms.annotationType;
        while (type.tag == 10) {
            Scope scope = type.tsym.members();
            Scope.Entry entry = scope.lookup(methodSymbol.name);
            while (entry.scope != null) {
                if (entry.sym.kind == 16 && (entry.sym.flags() & 5L) != 0L && this.types.overrideEquivalent(methodSymbol.type, entry.sym.type)) {
                    this.log.error(diagnosticPosition, "intf.annotation.member.clash", entry.sym, type);
                }
                entry = entry.next();
            }
            type = this.types.supertype(type);
        }
    }

    public void validateAnnotations(List<JCTree.JCAnnotation> list, Symbol symbol) {
        if (this.skipAnnotations) {
            return;
        }
        for (JCTree.JCAnnotation jCAnnotation : list) {
            this.validateAnnotation(jCAnnotation, symbol);
        }
    }

    public void validateAnnotation(JCTree.JCAnnotation jCAnnotation, Symbol symbol) {
        this.validateAnnotation(jCAnnotation);
        if (!this.annotationApplicable(jCAnnotation, symbol)) {
            this.log.error(jCAnnotation.pos(), "annotation.type.not.applicable", new Object[0]);
        }
        if (jCAnnotation.annotationType.type.tsym == this.syms.overrideType.tsym && !this.isOverrider(symbol)) {
            this.log.error(jCAnnotation.pos(), "method.does.not.override.superclass", new Object[0]);
        }
    }

    boolean isOverrider(Symbol symbol) {
        if (symbol.kind != 16 || symbol.isStatic()) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)methodSymbol.owner;
        for (Type type : this.types.closure(typeSymbol.type)) {
            if (type == typeSymbol.type) continue;
            Scope scope = type.tsym.members();
            Scope.Entry entry = scope.lookup(methodSymbol.name);
            while (entry.scope != null) {
                if (!entry.sym.isStatic() && methodSymbol.overrides(entry.sym, typeSymbol, this.types, true)) {
                    return true;
                }
                entry = entry.next();
            }
        }
        return false;
    }

    boolean annotationApplicable(JCTree.JCAnnotation jCAnnotation, Symbol symbol) {
        Attribute.Compound compound = jCAnnotation.annotationType.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (compound == null) {
            return true;
        }
        Attribute attribute = compound.member(this.names.value);
        if (!(attribute instanceof Attribute.Array)) {
            return true;
        }
        Attribute.Array array = (Attribute.Array)attribute;
        for (Attribute attribute2 : array.values) {
            if (!(attribute2 instanceof Attribute.Enum)) {
                return true;
            }
            Attribute.Enum enum_ = (Attribute.Enum)attribute2;
            if (enum_.value.name == this.names.TYPE) {
                if (symbol.kind != 2) continue;
                return true;
            }
            if (enum_.value.name == this.names.FIELD) {
                if (symbol.kind != 4 || symbol.owner.kind == 16) continue;
                return true;
            }
            if (enum_.value.name == this.names.METHOD) {
                if (symbol.kind != 16 || symbol.isConstructor()) continue;
                return true;
            }
            if (enum_.value.name == this.names.PARAMETER) {
                if (symbol.kind != 4 || symbol.owner.kind != 16 || (symbol.flags() & 0x200000000L) == 0L) continue;
                return true;
            }
            if (enum_.value.name == this.names.CONSTRUCTOR) {
                if (symbol.kind != 16 || !symbol.isConstructor()) continue;
                return true;
            }
            if (enum_.value.name == this.names.LOCAL_VARIABLE) {
                if (symbol.kind != 4 || symbol.owner.kind != 16 || (symbol.flags() & 0x200000000L) != 0L) continue;
                return true;
            }
            if (enum_.value.name == this.names.ANNOTATION_TYPE) {
                if (symbol.kind != 2 || (symbol.flags() & 0x2000L) == 0L) continue;
                return true;
            }
            if (enum_.value.name == this.names.PACKAGE) {
                if (symbol.kind != 1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void validateAnnotation(JCTree.JCAnnotation jCAnnotation) {
        Object object;
        JCTree.JCExpression jCExpression;
        if (jCAnnotation.type.isErroneous()) {
            return;
        }
        HashSet<Symbol.MethodSymbol> hashSet = new HashSet<Symbol.MethodSymbol>();
        Object object3 = jCAnnotation.annotationType.type.tsym.members().elems;
        while (object3 != null) {
            if (((Scope.Entry)object3).sym.kind == 16) {
                hashSet.add((Symbol.MethodSymbol)((Scope.Entry)object3).sym);
            }
            object3 = ((Scope.Entry)object3).sibling;
        }
        for (JCTree.JCExpression object22 : jCAnnotation.args) {
            if (object22.tag != 30) continue;
            jCExpression = (JCTree.JCAssign)object22;
            object = TreeInfo.symbol(jCExpression.lhs);
            if (object == null || ((Symbol)object).type.isErroneous()) continue;
            if (!hashSet.remove(object)) {
                this.log.error(object22.pos(), "duplicate.annotation.member.value", ((Symbol)object).name, jCAnnotation.type);
            }
            if (jCExpression.rhs.tag != 8192) continue;
            this.validateAnnotation((JCTree.JCAnnotation)jCExpression.rhs);
        }
        for (Symbol.MethodSymbol methodSymbol : hashSet) {
            if (methodSymbol.defaultValue != null || methodSymbol.type.isErroneous()) continue;
            this.log.error(jCAnnotation.pos(), "annotation.missing.default.value", jCAnnotation.type, methodSymbol.name);
        }
        if (jCAnnotation.annotationType.type.tsym != this.syms.annotationTargetType.tsym || jCAnnotation.args.tail == null) {
            return;
        }
        if (((JCTree.JCExpression)jCAnnotation.args.head).tag != 30) {
            return;
        }
        object3 = (JCTree.JCAssign)jCAnnotation.args.head;
        Symbol symbol = TreeInfo.symbol(((JCTree.JCAssign)object3).lhs);
        if (symbol.name != this.names.value) {
            return;
        }
        jCExpression = ((JCTree.JCAssign)object3).rhs;
        if (jCExpression.tag != 28) {
            return;
        }
        object = (JCTree.JCNewArray)jCExpression;
        HashSet<Symbol> hashSet2 = new HashSet<Symbol>();
        for (JCTree.JCExpression jCExpression2 : ((JCTree.JCNewArray)object).elems) {
            if (hashSet2.add(TreeInfo.symbol(jCExpression2))) continue;
            this.log.error(jCExpression2.pos(), "repeated.annotation.target", new Object[0]);
        }
    }

    void checkDeprecatedAnnotation(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (this.allowAnnotations && this.lint.isEnabled(Lint.LintCategory.DEP_ANN) && (symbol.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && symbol.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(diagnosticPosition, "missing.deprecated.annotation", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(JCTree.JCClassDecl jCClassDecl) {
        if ((jCClassDecl.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        assert ((jCClassDecl.sym.flags_field & 0x8000000L) == 0L);
        try {
            jCClassDecl.sym.flags_field |= 0x8000000L;
            for (JCTree jCTree : jCClassDecl.defs) {
                if (jCTree.tag != 4) continue;
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                this.checkAnnotationResType(jCMethodDecl.pos(), jCMethodDecl.restype.type);
            }
            Object var6_5 = null;
            jCClassDecl.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            jCClassDecl.sym.flags_field |= 0x800000000L;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            jCClassDecl.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            jCClassDecl.sym.flags_field |= 0x800000000L;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.TypeSymbol typeSymbol) {
        if ((typeSymbol.flags_field & 0x800000000L) != 0L) {
            return;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.log.error(diagnosticPosition, "cyclic.annotation.element", new Object[0]);
            return;
        }
        try {
            typeSymbol.flags_field |= 0x8000000L;
            Scope.Entry entry = typeSymbol.members().elems;
            while (entry != null) {
                Symbol symbol = entry.sym;
                if (symbol.kind == 16) {
                    this.checkAnnotationResType(diagnosticPosition, ((Symbol.MethodSymbol)symbol).type.getReturnType());
                }
                entry = entry.sibling;
            }
            Object var6_5 = null;
            typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            typeSymbol.flags_field |= 0x800000000L;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            typeSymbol.flags_field |= 0x800000000L;
            throw throwable;
        }
    }

    void checkAnnotationResType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        switch (type.tag) {
            case 10: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(diagnosticPosition, type.tsym);
                break;
            }
            case 11: {
                this.checkAnnotationResType(diagnosticPosition, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(JCTree.JCClassDecl jCClassDecl) {
        HashMap<Symbol, Symbol> hashMap = new HashMap<Symbol, Symbol>();
        Object object = jCClassDecl.defs;
        while (object.nonEmpty()) {
            Symbol[] symbolArray = TreeInfo.firstConstructorCall((JCTree)object.head);
            if (symbolArray != null) {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)object.head;
                if (TreeInfo.name(symbolArray.meth) == this.names._this) {
                    hashMap.put(jCMethodDecl.sym, TreeInfo.symbol(symbolArray.meth));
                } else {
                    jCMethodDecl.sym.flags_field |= 0x40000000L;
                }
            }
            object = object.tail;
        }
        object = new Symbol[]{};
        for (Symbol symbol : object = hashMap.keySet().toArray((T[])object)) {
            this.checkCyclicConstructor(jCClassDecl, symbol, hashMap);
        }
    }

    private void checkCyclicConstructor(JCTree.JCClassDecl jCClassDecl, Symbol symbol, Map<Symbol, Symbol> map) {
        if (symbol != null && (symbol.flags_field & 0x40000000L) == 0L) {
            if ((symbol.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor(symbol, jCClassDecl), "recursive.ctor.invocation", new Object[0]);
            } else {
                symbol.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(jCClassDecl, map.remove(symbol), map);
                symbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            symbol.flags_field |= 0x40000000L;
        }
    }

    void checkDivZero(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type) {
        int n;
        if (type.constValue() != null && this.lint.isEnabled(Lint.LintCategory.DIVZERO) && type.tag <= 5 && ((Number)type.constValue()).longValue() == 0L && ((n = ((Symbol.OperatorSymbol)symbol).opcode) == 108 || n == 112 || n == 109 || n == 113)) {
            this.log.warning(diagnosticPosition, "div.zero", new Object[0]);
        }
    }

    void checkEmptyIf(JCTree.JCIf jCIf) {
        if (jCIf.thenpart.tag == 6 && jCIf.elsepart == null && this.lint.isEnabled(Lint.LintCategory.EMPTY)) {
            this.log.warning(jCIf.thenpart.pos(), "empty.if", new Object[0]);
        }
    }

    boolean checkUnique(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Scope scope) {
        if (symbol.type.isErroneous()) {
            return true;
        }
        if (symbol.owner.name == this.names.any) {
            return false;
        }
        Scope.Entry entry = scope.lookup(symbol.name);
        while (entry.scope == scope) {
            if (symbol != entry.sym && symbol.kind == entry.sym.kind && symbol.name != this.names.error && (symbol.kind != 16 || this.types.overrideEquivalent(symbol.type, entry.sym.type))) {
                if ((symbol.flags() & 0x400000000L) != (entry.sym.flags() & 0x400000000L)) {
                    this.varargsDuplicateError(diagnosticPosition, symbol, entry.sym);
                } else {
                    this.duplicateError(diagnosticPosition, entry.sym);
                }
                return false;
            }
            entry = entry.next();
        }
        return true;
    }

    boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Scope scope) {
        return this.checkUniqueImport(diagnosticPosition, symbol, scope, false);
    }

    boolean checkUniqueStaticImport(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Scope scope) {
        return this.checkUniqueImport(diagnosticPosition, symbol, scope, true);
    }

    private boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Scope scope, boolean bl) {
        Scope.Entry entry = scope.lookup(symbol.name);
        while (entry.scope != null) {
            boolean bl2;
            boolean bl3 = bl2 = entry.scope == scope;
            if ((bl2 || symbol != entry.sym) && symbol.kind == entry.sym.kind && symbol.name != this.names.error) {
                if (!entry.sym.type.isErroneous()) {
                    String string = entry.sym.toString();
                    if (!bl2) {
                        if (bl) {
                            this.log.error(diagnosticPosition, "already.defined.static.single.import", string);
                        } else {
                            this.log.error(diagnosticPosition, "already.defined.single.import", string);
                        }
                    } else if (symbol != entry.sym) {
                        this.log.error(diagnosticPosition, "already.defined.this.unit", string);
                    }
                }
                return false;
            }
            entry = entry.next();
        }
        return true;
    }

    public void checkCanonical(JCTree jCTree) {
        if (!this.isCanonical(jCTree)) {
            this.log.error(jCTree.pos(), "import.requires.canonical", TreeInfo.symbol(jCTree));
        }
    }

    private boolean isCanonical(JCTree jCTree) {
        while (jCTree.tag == 34) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCTree;
            if (jCFieldAccess.sym.owner != TreeInfo.symbol(jCFieldAccess.selected)) {
                return false;
            }
            jCTree = jCFieldAccess.selected;
        }
        return true;
    }

    public Warner castWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return new ConversionWarner(diagnosticPosition, "unchecked.cast.to.type", type, type2);
    }

    public Warner convertWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return new ConversionWarner(diagnosticPosition, "unchecked.assign", type, type2);
    }

    private class ConversionWarner
    extends Warner {
        final String key;
        final Type found;
        final Type expected;

        public ConversionWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Type type, Type type2) {
            super(diagnosticPosition);
            this.key = string;
            this.found = type;
            this.expected = type2;
        }

        public void warnUnchecked() {
            boolean bl = this.warned;
            super.warnUnchecked();
            if (bl) {
                return;
            }
            JCDiagnostic jCDiagnostic = JCDiagnostic.fragment(this.key, new Object[0]);
            Check.this.warnUnchecked(this.pos(), "prob.found.req", jCDiagnostic, this.found, this.expected);
        }
    }

    class Validator
    extends JCTree.Visitor {
        Validator() {
        }

        public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            Check.this.validate(jCArrayTypeTree.elemtype);
        }

        public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
            if (jCTypeApply.type.tag == 10) {
                List<Type> list = jCTypeApply.type.tsym.type.getTypeArguments();
                List<Type> list2 = jCTypeApply.type.getTypeArguments();
                List<JCTree.JCExpression> list3 = jCTypeApply.arguments;
                List<Type> list4 = list;
                ListBuffer<Type.TypeVar> listBuffer = new ListBuffer<Type.TypeVar>();
                while (list3.nonEmpty() && list4.nonEmpty()) {
                    Check.this.validate((JCTree)list3.head);
                    listBuffer.append(Check.this.types.substBound((Type.TypeVar)list4.head, list, Type.removeBounds(list2)));
                    list3 = list3.tail;
                    list4 = list4.tail;
                }
                list3 = jCTypeApply.arguments;
                List list5 = listBuffer.toList();
                while (list3.nonEmpty() && list5.nonEmpty()) {
                    ((JCTree.JCExpression)list3.head).type.withTypeVar((Type)list5.head);
                    list3 = list3.tail;
                    list5 = list5.tail;
                }
                list3 = jCTypeApply.arguments;
                list5 = listBuffer.toList();
                while (list3.nonEmpty() && list5.nonEmpty()) {
                    Check.this.checkExtends(((JCTree.JCExpression)list3.head).pos(), ((JCTree.JCExpression)list3.head).type, (Type.TypeVar)list5.head);
                    list3 = list3.tail;
                    list5 = list5.tail;
                }
                if (jCTypeApply.type.getEnclosingType().isRaw()) {
                    Check.this.log.error(jCTypeApply.pos(), "improperly.formed.type.inner.raw.param", new Object[0]);
                }
                if (jCTypeApply.clazz.tag == 34) {
                    this.visitSelectInternal((JCTree.JCFieldAccess)jCTypeApply.clazz);
                }
            }
        }

        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            Check.this.validate(jCTypeParameter.bounds);
            Check.this.checkClassBounds(jCTypeParameter.pos(), jCTypeParameter.type);
        }

        public void visitWildcard(JCTree.JCWildcard jCWildcard) {
            if (jCWildcard.inner != null) {
                Check.this.validate(jCWildcard.inner);
            }
        }

        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.type.tag == 10) {
                this.visitSelectInternal(jCFieldAccess);
                if (jCFieldAccess.selected.type.isParameterized() && jCFieldAccess.type.tsym.type.getTypeArguments().nonEmpty()) {
                    Check.this.log.error(jCFieldAccess.pos(), "improperly.formed.type.param.missing", new Object[0]);
                }
            }
        }

        public void visitSelectInternal(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.type.getEnclosingType().tag == 10) {
                Check.this.validate(jCFieldAccess.selected);
            } else if (jCFieldAccess.selected.type.isParameterized()) {
                Check.this.log.error(jCFieldAccess.pos(), "cant.select.static.class.from.param.type", new Object[0]);
            }
        }

        public void visitTree(JCTree jCTree) {
        }
    }
}

