/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.fx.ui.workbench.renderers.base.BaseAreaRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WArea;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;

public class DefAreaRenderer
extends BaseAreaRenderer<SplitPane> {
    protected Class<? extends WArea<SplitPane>> getWidgetClass(MArea area) {
        return WAreaImpl.class;
    }

    public static class WAreaImpl
    extends WLayoutedWidgetImpl<SplitPane, SplitPane, MArea>
    implements WArea<SplitPane> {
        private List<WLayoutedWidget<MPartSashContainerElement>> items = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        private ChangeListener<Number> listener = new ChangeListener<Number>(){
            private boolean queueing;

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (!this.queueing) {
                    this.queueing = true;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WAreaImpl.this.recalcWeight();
                            queueing = false;
                        }
                    });
                }
            }
        };

        private void recalcWeight() {
            double prev = 0.0;
            int idx = 0;
            double[] dArray = ((SplitPane)this.getWidget()).getDividerPositions();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                ((MPartSashContainerElement)this.items.get(idx++).getDomElement()).setContainerData(String.valueOf((d - prev) * 10.0));
                prev = d;
                ++n2;
            }
            ((MPartSashContainerElement)this.items.get(this.items.size() - 1).getDomElement()).setContainerData(String.valueOf((1.0 - prev) * 10.0));
        }

        @Override
        protected void bindProperties(SplitPane widget) {
            super.bindProperties(widget);
            widget.getDividers().addListener((ListChangeListener)new ListChangeListener<SplitPane.Divider>(){

                public void onChanged(ListChangeListener.Change<? extends SplitPane.Divider> c) {
                    while (c.next()) {
                        for (SplitPane.Divider d : c.getAddedSubList()) {
                            d.positionProperty().addListener(WAreaImpl.this.listener);
                        }
                        for (SplitPane.Divider d : c.getRemoved()) {
                            d.positionProperty().removeListener(WAreaImpl.this.listener);
                        }
                    }
                }
            });
            for (SplitPane.Divider d : widget.getDividers()) {
                d.positionProperty().addListener(this.listener);
            }
        }

        @Override
        protected SplitPane createWidget() {
            SplitPane p = new SplitPane();
            return p;
        }

        @Inject
        void setOrientation(@Named(value="horizontal") boolean horizontal) {
            ((SplitPane)this.getWidget()).setOrientation(horizontal ? Orientation.HORIZONTAL : Orientation.VERTICAL);
        }

        @Override
        protected SplitPane getWidgetNode() {
            return (SplitPane)this.getWidget();
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            p.getItems().add((Object)((Node)widget.getStaticLayoutNode()));
            this.items.add(widget);
            this.updateDividers();
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(index, l);
            this.items.addAll(index, list);
            this.updateDividers();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(l);
            this.items.addAll(list);
            this.updateDividers();
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            p.getItems().remove(widget.getStaticLayoutNode());
            this.items.remove(widget);
            this.updateDividers();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.items.clear();
        }

        private void updateDividers() {
            if (this.items.size() <= 1) {
                return;
            }
            double total = 0.0;
            for (WLayoutedWidget<MPartSashContainerElement> w : this.items) {
                total += w.getWeight();
            }
            double[] deviders = new double[this.items.size() - 1];
            int i = 0;
            while (i < this.items.size() - 1) {
                deviders[i] = (i == 0 ? 0.0 : deviders[i - 1]) + this.items.get(i).getWeight() / total;
                ++i;
            }
            ((SplitPane)this.getWidget()).setDividerPositions(deviders);
        }

        public int getItemCount() {
            return ((SplitPane)this.getWidget()).getItems().size();
        }
    }
}

