/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.BaseDnDSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SplitDnDSupport<M extends MUIElement>
extends BaseDnDSupport {
    private final WLayoutedWidget<M> widget;
    private static int SPLIT_PADDING = 20;

    public SplitDnDSupport(@NonNull DnDFeedbackService feedbackService, WLayoutedWidget<M> widget) {
        super(feedbackService);
        this.widget = widget;
    }

    public void handleDragExit(DragEvent e) {
        SplitDnDSupport.cleanup();
    }

    private MUIElement findElement(String objectId) {
        EObject eo = (EObject)this.widget.getDomElement();
        EObject rv = null;
        if (eo != null) {
            rv = ((XMIResource)eo.eResource()).getEObject(objectId);
        }
        if (rv instanceof MUIElement) {
            return (MUIElement)rv;
        }
        return null;
    }

    public void handleDragOver(DragEvent e) {
        if (this.widget.getDropDroppedCallback() != null) {
            if (!DndTabPaneFactory.hasDnDContent((DragEvent)e)) {
                return;
            }
            @Nullable MUIElement m = this.widget.getDomElement();
            if (m instanceof MGenericTile) {
                e.consume();
            } else if (!(m instanceof MPart && this.isSplit(e) || !(m instanceof MElementContainer))) {
                MElementContainer c = (MElementContainer)m;
                if (c.getChildren().isEmpty()) {
                    e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    e.consume();
                } else {
                    this.updateFeedback(new DnDFeedbackService.DnDFeedbackData(null, null, this.getSplitType(e), (MUIElement)c, null));
                    e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    e.consume();
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void handleDragDropped(DragEvent e) {
        @Nullable @NonNull @Nullable WCallback dropDroppedCallback = this.widget.getDropDroppedCallback();
        if (dropDroppedCallback != null) {
            MElementContainer c;
            if (!DndTabPaneFactory.hasDnDContent((DragEvent)e)) {
                return;
            }
            String objectId = DndTabPaneFactory.getDnDContent((DragEvent)e);
            MUIElement draggedElement = this.findElement(objectId);
            if (draggedElement == null) {
                return;
            }
            @Nullable MUIElement m = this.widget.getDomElement();
            if (m instanceof MGenericTile) {
                e.consume();
            } else if (m instanceof MPart && this.isSplit(e)) {
                e.consume();
                if (m.getParent() instanceof MPartStack) {
                    WDragTargetWidget.DropData d = new WDragTargetWidget.DropData(this.widget.getDomElement(), draggedElement, this.getSplitType(e));
                    dropDroppedCallback.call((Object)d);
                }
            } else if (m instanceof MElementContainer && (c = (MElementContainer)m).getChildren().isEmpty()) {
                WDragTargetWidget.DropData d = new WDragTargetWidget.DropData(this.widget.getDomElement(), draggedElement, WDragTargetWidget.DropType.INSERT);
                dropDroppedCallback.call((Object)d);
                e.consume();
                e.setDropCompleted(true);
            }
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropType getSplitType(DragEvent e) {
        SplitAreas areas = this.calculateSplitAreas();
        if (areas.left.contains(e.getX(), e.getY())) {
            return WDragTargetWidget.DropType.SPLIT_LEFT;
        }
        if (areas.right.contains(e.getX(), e.getY())) {
            return WDragTargetWidget.DropType.SPLIT_RIGHT;
        }
        if (areas.top.contains(e.getX(), e.getY())) {
            return WDragTargetWidget.DropType.SPLIT_TOP;
        }
        if (areas.bottom.contains(e.getX(), e.getY())) {
            return WDragTargetWidget.DropType.SPLIT_BOTTOM;
        }
        return WDragTargetWidget.DropType.SPLIT_BOTTOM;
    }

    private SplitAreas calculateSplitAreas() {
        Bounds bounds = ((Node)this.widget.getStaticLayoutNode()).getBoundsInLocal();
        double hSplitWidth = (bounds.getWidth() - (double)(SPLIT_PADDING * 2)) / 5.0;
        double hSplitHeight = bounds.getHeight() - (double)(SPLIT_PADDING * 2);
        double vSplitWidth = bounds.getWidth() - (double)(SPLIT_PADDING * 2);
        double vSplitHeight = (bounds.getHeight() - (double)(SPLIT_PADDING * 2)) / 2.0;
        BoundingBox leftSplit = new BoundingBox((double)SPLIT_PADDING, (double)SPLIT_PADDING, hSplitWidth, hSplitHeight);
        BoundingBox rightSplit = new BoundingBox(bounds.getWidth() - (double)SPLIT_PADDING - hSplitWidth, (double)SPLIT_PADDING, hSplitWidth, hSplitHeight);
        BoundingBox topSplit = new BoundingBox((double)SPLIT_PADDING, (double)SPLIT_PADDING, vSplitWidth, vSplitHeight);
        BoundingBox bottomSplit = new BoundingBox((double)SPLIT_PADDING, (double)SPLIT_PADDING + vSplitHeight, vSplitWidth, vSplitHeight);
        return new SplitAreas((Bounds)leftSplit, (Bounds)rightSplit, (Bounds)topSplit, (Bounds)bottomSplit);
    }

    private boolean isSplit(DragEvent e) {
        Bounds boundsInLocal = ((Node)this.widget.getStaticLayoutNode()).getBoundsInLocal();
        boundsInLocal = new BoundingBox(boundsInLocal.getMinX() + (double)SPLIT_PADDING, boundsInLocal.getMinY() + (double)SPLIT_PADDING, boundsInLocal.getWidth() - (double)(SPLIT_PADDING * 2), boundsInLocal.getHeight() - (double)(SPLIT_PADDING * 2));
        return boundsInLocal.contains(e.getX(), e.getY());
    }

    private static class SplitAreas {
        final Bounds left;
        final Bounds right;
        final Bounds top;
        final Bounds bottom;

        SplitAreas(Bounds left, Bounds right, Bounds top, Bounds bottom) {
            this.left = left;
            this.right = right;
            this.bottom = bottom;
            this.top = top;
        }
    }
}

