/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.util.ExceptionAcceptor;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;

public class FormatterRequest {
    private Collection<ITextRegion> regions = Lists.newArrayList();
    private ITextRegionAccess textRegionAccess;
    private boolean allowIdentityEdits;
    private ITypedPreferenceValues preferences;
    private boolean formatUndenfinedTokensOnly;
    private IAcceptor<Exception> exceptionHandler;

    public FormatterRequest addRegion(ITextRegion region) {
        this.regions.add(region);
        return this;
    }

    public FormatterRequest setRegions(Collection<ITextRegion> regions) {
        this.regions = regions;
        return this;
    }

    public Collection<ITextRegion> getRegions() {
        return this.regions;
    }

    public ITextRegionAccess getTextRegionAccess() {
        return this.textRegionAccess;
    }

    public FormatterRequest setTextRegionAccess(ITextRegionAccess tokens) {
        if (tokens.hasSyntaxError() && this.exceptionHandler == null) {
            this.exceptionHandler = ExceptionAcceptor.IGNORING;
        }
        this.textRegionAccess = tokens;
        return this;
    }

    public FormatterRequest setAllowIdentityEdits(boolean allowIdentityEdits) {
        this.allowIdentityEdits = allowIdentityEdits;
        return this;
    }

    public boolean allowIdentityEdits() {
        return this.allowIdentityEdits;
    }

    public FormatterRequest setPreferences(ITypedPreferenceValues preferenceValues) {
        this.preferences = preferenceValues;
        return this;
    }

    public ITypedPreferenceValues getPreferences() {
        if (this.preferences == null) {
            this.preferences = new MapBasedPreferenceValues(Maps.newLinkedHashMap());
        }
        return this.preferences;
    }

    public boolean isFormatUndefinedHiddenRegionsOnly() {
        return this.formatUndenfinedTokensOnly;
    }

    public FormatterRequest setFormatUndenfinedTokensOnly(boolean formatUndenfinedTokensOnly) {
        this.formatUndenfinedTokensOnly = formatUndenfinedTokensOnly;
        return this;
    }

    public IAcceptor<Exception> getExceptionHandler() {
        if (this.exceptionHandler == null) {
            return ExceptionAcceptor.LOGGING;
        }
        return this.exceptionHandler;
    }

    public FormatterRequest setExceptionHandler(IAcceptor<Exception> problemHandler) {
        this.exceptionHandler = problemHandler;
        return this;
    }
}

