/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.guice;

import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.jdt.annotation.NonNull;

public class FXLoggerListener
implements TypeListener {
    public <T> void hear(TypeLiteral<T> typeLiteral, TypeEncounter<T> typeEncounter) {
        Field[] fieldArray = typeLiteral.getRawType().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == Logger.class && field.isAnnotationPresent(Log.class)) {
                Provider provider;
                String loggerName = field.getAnnotation(Log.class).value();
                if (loggerName == null || loggerName.isEmpty()) {
                    loggerName = typeLiteral.getRawType().getName();
                }
                if (loggerName == null) {
                    loggerName = "unknown";
                }
                if ((provider = typeEncounter.getProvider(LoggerFactory.class)) == null) {
                    throw new IllegalStateException("No " + String.valueOf(LoggerFactory.class) + " provider registered");
                }
                typeEncounter.register(new FieldLoggerInjector(field, loggerName, (Provider<LoggerFactory>)provider));
            }
            ++n2;
        }
    }

    static class FieldLoggerInjector<T>
    implements MembersInjector<T> {
        private @NonNull Provider<LoggerFactory> provider;
        private @NonNull Field field;
        private @NonNull String loggerName;

        public FieldLoggerInjector(@NonNull Field field, @NonNull String loggerName, @NonNull Provider<LoggerFactory> provider) {
            this.provider = provider;
            this.field = field;
            this.loggerName = loggerName;
            this.field.setAccessible(true);
        }

        public void injectMembers(T instance) {
            Logger logger = ((LoggerFactory)this.provider.get()).createLogger(this.loggerName);
            try {
                this.field.set(instance, logger);
            }
            catch (IllegalArgumentException e) {
                logger.error("Unable to inject the logger", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                logger.error("Unable to inject the logger", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

