/*******************************************************************************
 * Copyright (c) 2022 BestSolution.at and others.
 *  
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v.2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0.
 *  
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *     BestSolution.at - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.core.di.context.internal;

import java.util.Optional;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.core.di.ContextScope;
import org.eclipse.fx.core.di.context.ScopeCalculator;
import org.osgi.service.component.annotations.Component;

@Component
public class DefaultScopeCalculator implements ScopeCalculator {

	@Override
	public Optional<IEclipseContext> getContext(IEclipseContext localContext, ContextScope scope) {
		if( scope == ContextScope.APPLICATION ) {
			IEclipseContext c = localContext;
			while( c.getParent() != null ) {
				c = localContext.getParent();
			}
			return Optional.of(c);
		}

		return Optional.empty();
	}

}
