/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class AssertStatement
extends Statement {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(AssertStatement.class, "expression", Expression.class, true, true);
    public static final ChildPropertyDescriptor MESSAGE_PROPERTY = new ChildPropertyDescriptor(AssertStatement.class, "message", Expression.class, false, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Expression expression = null;
    private Expression optionalMessageExpression = null;

    static {
        ArrayList properyList = new ArrayList(3);
        AssertStatement.createPropertyList(AssertStatement.class, properyList);
        AssertStatement.addProperty(EXPRESSION_PROPERTY, properyList);
        AssertStatement.addProperty(MESSAGE_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = AssertStatement.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    AssertStatement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return AssertStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        if (property == MESSAGE_PROPERTY) {
            if (get) {
                return this.getMessage();
            }
            this.setMessage((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 6;
    }

    @Override
    ASTNode clone0(AST target) {
        AssertStatement result = new AssertStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        result.setMessage((Expression)ASTNode.copySubtree(target, this.getMessage()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getMessage());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (this.expression == null) {
            AssertStatement assertStatement = this;
            synchronized (assertStatement) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public Expression getMessage() {
        return this.optionalMessageExpression;
    }

    public void setMessage(Expression expression) {
        Expression oldChild = this.optionalMessageExpression;
        this.preReplaceChild(oldChild, expression, MESSAGE_PROPERTY);
        this.optionalMessageExpression = expression;
        this.postReplaceChild(oldChild, expression, MESSAGE_PROPERTY);
    }

    @Override
    int memSize() {
        return super.memSize() + 8;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.optionalMessageExpression == null ? 0 : this.getMessage().treeSize());
    }
}

