/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Messages;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Feature;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.util.NLS;

public class PlatformXmlListener
extends DirectoryChangeListener {
    private static final String PLATFORM_XML = "platform.xml";
    private boolean changed = false;
    private File root;
    private long lastModified = -1L;
    private Set<IMetadataRepository> configRepositories;

    private String toString(Feature[] features, String[] list) {
        int n;
        int n2;
        Object[] objectArray;
        StringBuilder buffer = new StringBuilder();
        if (features != null) {
            objectArray = features;
            n2 = features.length;
            n = 0;
            while (n < n2) {
                Feature feature = objectArray[n];
                String featureURL = feature.getUrl();
                if (featureURL != null) {
                    buffer.append(featureURL).append(',');
                } else {
                    String id = feature.getId();
                    String version = feature.getVersion();
                    if (id != null && version != null) {
                        buffer.append("features/" + id + "_" + version + "/,");
                    }
                }
                ++n;
            }
        }
        if (list != null) {
            objectArray = list;
            n2 = list.length;
            n = 0;
            while (n < n2) {
                Feature list1 = objectArray[n];
                buffer.append((String)list1).append(',');
                ++n;
            }
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    public PlatformXmlListener(File file) {
        if (!PLATFORM_XML.equals(file.getName())) {
            throw new IllegalArgumentException();
        }
        this.root = file;
    }

    public boolean added(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public boolean changed(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public Long getSeenFile(File file) {
        return 0L;
    }

    public boolean isInterested(File file) {
        return file.getName().equals(PLATFORM_XML) && this.lastModified != file.lastModified();
    }

    public boolean removed(File file) {
        this.changed = this.changed || PLATFORM_XML.equals(file.getName());
        return false;
    }

    public void startPoll() {
        this.changed = false;
    }

    public void stopPoll() {
        if (this.changed) {
            this.lastModified = this.root.lastModified();
            try {
                Configuration configuration = Configuration.load((File)this.root, (URL)Activator.getOSGiInstallArea());
                this.synchronizeConfiguration(configuration);
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", Messages.errorProcessingConfg, (Throwable)e));
            }
        }
        this.changed = false;
    }

    public Collection<IMetadataRepository> getMetadataRepositories() {
        if (this.configRepositories == null) {
            return Collections.emptySet();
        }
        return this.configRepositories;
    }

    private IMetadataRepository getMatchingRepo(Collection<IMetadataRepository> repositoryList, String urlString) {
        if (repositoryList == null) {
            return null;
        }
        IPath urlPath = new Path(urlString).makeAbsolute();
        for (IMetadataRepository repo : repositoryList) {
            File file = URIUtil.toFile((URI)repo.getLocation());
            if (file == null) continue;
            Path repoPath = new Path(file.getAbsolutePath());
            if (repoPath.makeAbsolute().equals((Object)urlPath)) {
                return repo;
            }
            if (!(repo instanceof ExtensionLocationMetadataRepository)) continue;
            try {
                File one = ExtensionLocationMetadataRepository.getBaseDirectory((URI)repo.getLocation());
                File two = ExtensionLocationMetadataRepository.getBaseDirectory((URI)new URI(urlString));
                if (!one.equals(two)) continue;
                return repo;
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() == 1000) continue;
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while comparing repository locations.", (Throwable)e));
            }
            catch (URISyntaxException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while comparing repository locations.", (Throwable)e));
            }
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void synchronizeConfiguration(Configuration config) {
        sites = config.getSites();
        newRepos = new LinkedHashSet<IMetadataRepository>();
        toBeRemoved = new HashSet<Site>();
        block11: for (Site site : sites) {
            siteURL = site.getUrl();
            match = this.getMatchingRepo(Activator.getRepositories(), siteURL);
            if (match == null) {
                try {
                    block20: {
                        linkFile = site.getLinkFile();
                        if (linkFile != null && linkFile.length() > 0 && !(link = new File(linkFile)).exists()) {
                            toBeRemoved.add(site);
                            continue;
                        }
                        if (!site.isEnabled()) {
                            toBeRemoved.add(site);
                            continue;
                        }
                        eclipseExtensionURL = String.valueOf(siteURL) + ".eclipseextension";
                        location = new URI(eclipseExtensionURL);
                        properties = new HashMap<String, String>();
                        properties.put("org.eclipse.update.site.policy", site.getPolicy());
                        listFeatures = site.getPolicy().equals("USER-INCLUDE") != false ? site.getFeatures() : null;
                        properties.put("org.eclipse.update.site.list", this.toString(listFeatures, site.getList()));
                        metadataRepository = null;
                        try {
                            metadataRepository = Activator.createExtensionLocationMetadataRepository(location, "extension location metadata repository: " + location.toString(), properties);
                            break block20;
                        }
                        catch (ProvisionException v0) {
                            try {
                                metadataRepository = Activator.loadMetadataRepository(location, null);
                            }
                            catch (ProvisionException inner) {
                                fileURI = new URI(siteURL);
                                file = URIUtil.toFile((URI)fileURI);
                                if (file != null && !file.exists()) {
                                    toBeRemoved.add(site);
                                    continue;
                                }
                                throw inner;
                            }
                            ** for (entry : properties.entrySet())
                        }
lbl-1000:
                        // 1 sources

                        {
                            metadataRepository.setProperty((String)entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                    }
                    newRepos.add(metadataRepository);
                    try {
                        Activator.createExtensionLocationArtifactRepository(location, "extension location artifact repository: " + location, properties);
                        continue;
                    }
                    catch (ProvisionException v1) {
                        artifactRepository = Activator.loadArtifactRepository(location, null);
                        ** for (key : properties.keySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        value = (String)properties.get(key);
                        artifactRepository.setProperty(key, value);
                        continue;
lbl60:
                        // 1 sources

                    }
                }
                catch (URISyntaxException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.errorLoadingRepository, (Object)siteURL), (Throwable)e));
                }
                catch (ProvisionException e) {
                    if (e.getStatus().getCode() == 1000) continue;
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.errorLoadingRepository, (Object)siteURL), (Throwable)e));
                }
                continue;
            }
            newRepos.add(match);
        }
        if (!toBeRemoved.isEmpty()) {
            iter = toBeRemoved.iterator();
            while (iter.hasNext()) {
                config.removeSite((Site)iter.next());
            }
            try {
                config.save(this.root, Activator.getOSGiInstallArea());
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while saving configuration at: " + this.root, (Throwable)e));
            }
        }
        this.configRepositories = newRepos;
    }
}

