/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyBatchUpdateException
extends BeansException {
    private PropertyAccessException[] propertyAccessExceptions;

    public PropertyBatchUpdateException(PropertyAccessException[] propertyAccessExceptions) {
        super(null);
        Assert.notEmpty((Object[])propertyAccessExceptions, (String)"At least 1 PropertyAccessException required");
        this.propertyAccessExceptions = propertyAccessExceptions;
    }

    public final int getExceptionCount() {
        return this.propertyAccessExceptions.length;
    }

    public final PropertyAccessException[] getPropertyAccessExceptions() {
        return this.propertyAccessExceptions;
    }

    public PropertyAccessException getPropertyAccessException(String propertyName) {
        PropertyAccessException[] propertyAccessExceptionArray = this.propertyAccessExceptions;
        int n = this.propertyAccessExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyAccessException pae = propertyAccessExceptionArray[n2];
            if (ObjectUtils.nullSafeEquals((Object)propertyName, (Object)pae.getPropertyName())) {
                return pae;
            }
            ++n2;
        }
        return null;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Failed properties: ");
        int i = 0;
        while (i < this.propertyAccessExceptions.length) {
            sb.append(this.propertyAccessExceptions[i].getMessage());
            if (i < this.propertyAccessExceptions.length - 1) {
                sb.append("; ");
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getName()).append("; nested PropertyAccessExceptions (");
        sb.append(this.getExceptionCount()).append(") are:");
        int i = 0;
        while (i < this.propertyAccessExceptions.length) {
            sb.append('\n').append("PropertyAccessException ").append(i + 1).append(": ");
            sb.append((Object)this.propertyAccessExceptions[i]);
            ++i;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
            int i = 0;
            while (i < this.propertyAccessExceptions.length) {
                ps.println("PropertyAccessException " + (i + 1) + ":");
                this.propertyAccessExceptions[i].printStackTrace(ps);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
            int i = 0;
            while (i < this.propertyAccessExceptions.length) {
                pw.println("PropertyAccessException " + (i + 1) + ":");
                this.propertyAccessExceptions[i].printStackTrace(pw);
                ++i;
            }
        }
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance((Object)this)) {
            return true;
        }
        PropertyAccessException[] propertyAccessExceptionArray = this.propertyAccessExceptions;
        int n = this.propertyAccessExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyAccessException pae = propertyAccessExceptionArray[n2];
            if (pae.contains(exType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

