/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.adapter;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.net.TrustOptions;
import io.vertx.proton.ProtonClient;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonSender;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.cli.AbstractCliClient;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AmqpCliClient
extends AbstractCliClient {
    protected PrintWriter writer = new PrintWriter(System.out);
    protected ProtonConnection adapterConnection;
    private ClientConfigProperties properties = new ClientConfigProperties();

    @Autowired(required=false)
    public void setClientConfig(ClientConfigProperties props) {
        this.properties = Objects.requireNonNull(props);
    }

    protected Future<ProtonSender> createSender() {
        if (this.adapterConnection == null || this.adapterConnection.isDisconnected()) {
            throw new IllegalStateException("connection to AMQP org.eclipse.hono.cli.app.adapter not established");
        }
        Promise result = Promise.promise();
        ProtonSender sender = this.adapterConnection.createSender(null);
        sender.openHandler((Handler)result);
        sender.open();
        return result.future();
    }

    protected Future<ProtonConnection> connectToAdapter() {
        Promise connectAttempt = Promise.promise();
        ProtonClientOptions options = new ProtonClientOptions();
        ProtonClient client = ProtonClient.create((Vertx)this.vertx);
        options.setConnectTimeout(this.properties.getConnectTimeout());
        options.setHeartbeat(this.properties.getHeartbeatInterval());
        options.setMaxFrameSize(this.properties.getMaxFrameSize());
        Optional.ofNullable(this.properties.getAmqpHostname()).ifPresent(s -> options.setVirtualHost(s));
        this.addTlsTrustOptions(options, this.properties);
        if (!Strings.isNullOrEmpty((Object)this.properties.getUsername()) && !Strings.isNullOrEmpty((Object)this.properties.getPassword())) {
            options.addEnabledSaslMechanism("PLAIN");
            this.log.info("connecting to AMQP org.eclipse.hono.cli.app.adapter using SASL PLAIN [host: {}, port: {}, username: {}]", new Object[]{this.properties.getHost(), this.properties.getPort(), this.properties.getUsername()});
            client.connect(options, this.properties.getHost(), this.properties.getPort(), this.properties.getUsername(), this.properties.getPassword(), (Handler)connectAttempt);
        } else {
            if (this.properties.getKeyCertOptions() != null && this.properties.getTrustOptions() != null) {
                options.setKeyCertOptions(this.properties.getKeyCertOptions());
            }
            this.log.info("connecting to AMQP org.eclipse.hono.cli.app.adapter [host: {}, port: {}]", (Object)this.properties.getHost(), (Object)this.properties.getPort());
            client.connect(options, this.properties.getHost(), this.properties.getPort(), (Handler)connectAttempt);
        }
        return connectAttempt.future().compose(unopenedConnection -> {
            Promise con = Promise.promise();
            unopenedConnection.openHandler((Handler)con);
            unopenedConnection.open();
            return con.future();
        });
    }

    private void addTlsTrustOptions(ProtonClientOptions clientOptions, ClientConfigProperties config) {
        TrustOptions trustOptions;
        if (config.isTlsEnabled()) {
            clientOptions.setSsl(true);
        }
        if ((trustOptions = config.getTrustOptions()) != null) {
            clientOptions.setSsl(true).setTrustOptions(trustOptions);
        }
        if (clientOptions.isSsl()) {
            if (config.isHostnameVerificationRequired()) {
                clientOptions.setHostnameVerificationAlgorithm("HTTPS");
            } else {
                clientOptions.setHostnameVerificationAlgorithm("");
            }
        }
    }
}

