/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ExternalMetricSourceFluentImpl<A extends ExternalMetricSourceFluent<A>>
extends BaseFluent<A>
implements ExternalMetricSourceFluent<A> {
    private String metricName;
    private LabelSelectorBuilder metricSelector;
    private Quantity targetAverageValue;
    private Quantity targetValue;
    private Map<String, Object> additionalProperties;

    public ExternalMetricSourceFluentImpl() {
    }

    public ExternalMetricSourceFluentImpl(ExternalMetricSource instance) {
        if (instance != null) {
            this.withMetricName(instance.getMetricName());
            this.withMetricSelector(instance.getMetricSelector());
            this.withTargetAverageValue(instance.getTargetAverageValue());
            this.withTargetValue(instance.getTargetValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    @Deprecated
    public LabelSelector getMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public A withMetricSelector(LabelSelector metricSelector) {
        this._visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector != null) {
            this.metricSelector = new LabelSelectorBuilder(metricSelector);
            this._visitables.get("metricSelector").add(this.metricSelector);
        } else {
            this.metricSelector = null;
            this._visitables.get("metricSelector").remove(this.metricSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNestedImpl();
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNestedImpl(item);
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector());
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : item);
    }

    @Override
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    @Override
    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    @Override
    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    @Override
    public Quantity getTargetValue() {
        return this.targetValue;
    }

    @Override
    public A withTargetValue(Quantity targetValue) {
        this.targetValue = targetValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetValue() {
        return this.targetValue != null;
    }

    @Override
    public A withNewTargetValue(String amount, String format) {
        return this.withTargetValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetValue(String amount) {
        return this.withTargetValue(new Quantity(amount));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalMetricSourceFluentImpl that = (ExternalMetricSourceFluentImpl)o;
        if (!Objects.equals(this.metricName, that.metricName)) {
            return false;
        }
        if (!Objects.equals(this.metricSelector, that.metricSelector)) {
            return false;
        }
        if (!Objects.equals(this.targetAverageValue, that.targetAverageValue)) {
            return false;
        }
        if (!Objects.equals(this.targetValue, that.targetValue)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.metricName, this.metricSelector, this.targetAverageValue, this.targetValue, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricName != null) {
            sb.append("metricName:");
            sb.append(this.metricName + ",");
        }
        if (this.metricSelector != null) {
            sb.append("metricSelector:");
            sb.append(this.metricSelector + ",");
        }
        if (this.targetAverageValue != null) {
            sb.append("targetAverageValue:");
            sb.append(this.targetAverageValue + ",");
        }
        if (this.targetValue != null) {
            sb.append("targetValue:");
            sb.append(this.targetValue + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetricSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ExternalMetricSourceFluent.MetricSelectorNested<N>>
    implements ExternalMetricSourceFluent.MetricSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        MetricSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        MetricSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalMetricSourceFluentImpl.this.withMetricSelector(this.builder.build());
        }

        @Override
        public N endMetricSelector() {
            return this.and();
        }
    }
}

