package org.eclipse.incquery.viewers.runtime.model.patterns;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2edgeQuerySpecification;
import org.eclipse.incquery.viewmodel.traceability.Trace;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.viewers.runtime.model.patterns.param2edge pattern,
 * to be used in conjunction with {@link Param2edgeMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see Param2edgeMatcher
 * @see Param2edgeProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class Param2edgeMatch extends BasePatternMatch {
  private Object fSource;
  
  private Object fTarget;
  
  private Trace fTrace;
  
  private Edge fEdge;
  
  private static List<String> parameterNames = makeImmutableList("source", "target", "trace", "edge");
  
  private Param2edgeMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    this.fSource = pSource;
    this.fTarget = pTarget;
    this.fTrace = pTrace;
    this.fEdge = pEdge;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("source".equals(parameterName)) return this.fSource;
    if ("target".equals(parameterName)) return this.fTarget;
    if ("trace".equals(parameterName)) return this.fTrace;
    if ("edge".equals(parameterName)) return this.fEdge;
    return null;
  }
  
  public Object getSource() {
    return this.fSource;
  }
  
  public Object getTarget() {
    return this.fTarget;
  }
  
  public Trace getTrace() {
    return this.fTrace;
  }
  
  public Edge getEdge() {
    return this.fEdge;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("source".equals(parameterName) && newValue instanceof Object) {
    	this.fSource = (Object) newValue;
    	return true;
    }
    if ("target".equals(parameterName) && newValue instanceof Object) {
    	this.fTarget = (Object) newValue;
    	return true;
    }
    if ("trace".equals(parameterName) ) {
    	this.fTrace = (Trace) newValue;
    	return true;
    }
    if ("edge".equals(parameterName) ) {
    	this.fEdge = (Edge) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSource(final Object pSource) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSource = pSource;
  }
  
  public void setTarget(final Object pTarget) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTarget = pTarget;
  }
  
  public void setTrace(final Trace pTrace) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTrace = pTrace;
  }
  
  public void setEdge(final Edge pEdge) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEdge = pEdge;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.viewers.runtime.model.patterns.param2edge";
  }
  
  @Override
  public List<String> parameterNames() {
    return Param2edgeMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSource, fTarget, fTrace, fEdge};
  }
  
  @Override
  public Param2edgeMatch toImmutable() {
    return isMutable() ? newMatch(fSource, fTarget, fTrace, fEdge) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"source\"=" + prettyPrintValue(fSource) + ", ");
    
    result.append("\"target\"=" + prettyPrintValue(fTarget) + ", ");
    
    result.append("\"trace\"=" + prettyPrintValue(fTrace) + ", ");
    
    result.append("\"edge\"=" + prettyPrintValue(fEdge)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSource == null) ? 0 : fSource.hashCode());
    result = prime * result + ((fTarget == null) ? 0 : fTarget.hashCode());
    result = prime * result + ((fTrace == null) ? 0 : fTrace.hashCode());
    result = prime * result + ((fEdge == null) ? 0 : fEdge.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof Param2edgeMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    Param2edgeMatch other = (Param2edgeMatch) obj;
    if (fSource == null) {if (other.fSource != null) return false;}
    else if (!fSource.equals(other.fSource)) return false;
    if (fTarget == null) {if (other.fTarget != null) return false;}
    else if (!fTarget.equals(other.fTarget)) return false;
    if (fTrace == null) {if (other.fTrace != null) return false;}
    else if (!fTrace.equals(other.fTrace)) return false;
    if (fEdge == null) {if (other.fEdge != null) return false;}
    else if (!fEdge.equals(other.fEdge)) return false;
    return true;
  }
  
  @Override
  public Param2edgeQuerySpecification specification() {
    try {
    	return Param2edgeQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static Param2edgeMatch newEmptyMatch() {
    return new Mutable(null, null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static Param2edgeMatch newMutableMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return new Mutable(pSource, pTarget, pTrace, pEdge);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pEdge the fixed value of pattern parameter edge, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static Param2edgeMatch newMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
    return new Immutable(pSource, pTarget, pTrace, pEdge);
  }
  
  private static final class Mutable extends Param2edgeMatch {
    Mutable(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      super(pSource, pTarget, pTrace, pEdge);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends Param2edgeMatch {
    Immutable(final Object pSource, final Object pTarget, final Trace pTrace, final Edge pEdge) {
      super(pSource, pTarget, pTrace, pEdge);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
