/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerCreation;

final class ImmutableContainerCreation
implements ContainerCreation {
    @Nullable
    private final String id;
    @Nullable
    private final List<String> warnings;

    private ImmutableContainerCreation(@Nullable String id, @Nullable List<String> warnings) {
        this.id = id;
        this.warnings = warnings;
    }

    @Override
    @JsonProperty(value="Id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Warnings")
    @Nullable
    public List<String> warnings() {
        return this.warnings;
    }

    public final ImmutableContainerCreation withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableContainerCreation(value, this.warnings);
    }

    public final ImmutableContainerCreation withWarnings(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerCreation(this.id, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerCreation.createUnmodifiableList(false, ImmutableContainerCreation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerCreation(this.id, newValue);
    }

    public final ImmutableContainerCreation withWarnings(@Nullable Iterable<String> elements) {
        if (this.warnings == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerCreation.createUnmodifiableList(false, ImmutableContainerCreation.createSafeList(elements, true, false));
        return new ImmutableContainerCreation(this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerCreation && this.equalTo(0, (ImmutableContainerCreation)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerCreation another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.warnings, another.warnings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.warnings);
        return h;
    }

    public String toString() {
        return "ContainerCreation{id=" + this.id + ", warnings=" + String.valueOf(this.warnings) + "}";
    }

    public static ImmutableContainerCreation copyOf(ContainerCreation instance) {
        if (instance instanceof ImmutableContainerCreation) {
            return (ImmutableContainerCreation)instance;
        }
        return ImmutableContainerCreation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements ContainerCreation.Builder {
        private String id;
        private List<String> warnings = null;

        private Builder() {
        }

        public final Builder from(ContainerCreation instance) {
            List<String> warningsValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((warningsValue = instance.warnings()) != null) {
                this.addAllWarnings(warningsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder warning(String element) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            return this;
        }

        public final Builder warnings(String ... elements) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Warnings")
        public final Builder warnings(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.warnings = null;
                return this;
            }
            this.warnings = new ArrayList<String>();
            return this.addAllWarnings(elements);
        }

        public final Builder addAllWarnings(Iterable<String> elements) {
            Objects.requireNonNull(elements, "warnings element");
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        @Override
        public ImmutableContainerCreation build() {
            return new ImmutableContainerCreation(this.id, this.warnings == null ? null : ImmutableContainerCreation.createUnmodifiableList(true, this.warnings));
        }
    }
}

