/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.module.script.ScriptEngineContainer;
import org.eclipse.smarthome.automation.module.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScriptModuleHandler<T extends Module>
extends BaseModuleHandler<T> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String SCRIPT_TYPE = "type";
    protected static final String SCRIPT = "script";
    protected ScriptEngineManager scriptEngineManager;
    private final String engineIdentifier;
    private Optional<ScriptEngine> scriptEngine = Optional.empty();
    private String type;
    protected String script;
    private final String ruleUID;

    public AbstractScriptModuleHandler(T module, String ruleUID, ScriptEngineManager scriptEngineManager) {
        super(module);
        this.scriptEngineManager = scriptEngineManager;
        this.ruleUID = ruleUID;
        this.engineIdentifier = UUID.randomUUID().toString();
        this.loadConfig();
    }

    public void dispose() {
        if (this.scriptEngine != null) {
            this.scriptEngineManager.removeEngine(this.engineIdentifier);
        }
    }

    protected Optional<ScriptEngine> getScriptEngine() {
        return this.scriptEngine.isPresent() ? this.scriptEngine : this.createScriptEngine();
    }

    private Optional<ScriptEngine> createScriptEngine() {
        ScriptEngineContainer container = this.scriptEngineManager.createScriptEngine(this.type, this.engineIdentifier);
        if (container != null) {
            this.scriptEngine = Optional.ofNullable(container.getScriptEngine());
            return this.scriptEngine;
        }
        this.logger.debug("No engine available for script type '{}' in action '{}'.", (Object)this.type, (Object)this.module.getId());
        return Optional.empty();
    }

    private void loadConfig() {
        Object type = this.module.getConfiguration().get(SCRIPT_TYPE);
        Object script = this.module.getConfiguration().get(SCRIPT);
        if (!this.isValid(type)) {
            throw new IllegalStateException(String.format("Type is missing in the configuration of module '%s'.", this.module.getId()));
        }
        if (!this.isValid(script)) {
            throw new IllegalStateException(String.format("Script is missing in the configuration of module '%s'.", this.module.getId()));
        }
        this.type = (String)type;
        this.script = (String)script;
    }

    private boolean isValid(Object parameter) {
        return parameter != null && parameter instanceof String && !((String)parameter).trim().isEmpty();
    }

    protected void setExecutionContext(ScriptEngine engine, Map<String, ?> context) {
        ScriptContext executionContext = engine.getContext();
        HashMap contextNew = new HashMap(context);
        contextNew.put("ruleUID", this.ruleUID);
        executionContext.setAttribute("ctx", contextNew, 100);
        executionContext.setAttribute("ruleUID", this.ruleUID, 100);
        for (Map.Entry<String, ?> entry : context.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            int dotIndex = key.indexOf(46);
            if (dotIndex != -1) {
                key = key.substring(dotIndex + 1);
            }
            executionContext.setAttribute(key, value, 100);
        }
    }
}

