/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.serialization.generators.xsd;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sphinx.emf.serialization.generators.util.JavaXSDPrimitiveTypeMapping;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Ecore2XSDConverter {
    protected Ecore2XSDFactory xsdFactory;
    protected XSDSchema xsdSchema;
    protected ArrayList<EClass> referencedClass = new ArrayList();

    public Ecore2XSDConverter(Ecore2XSDFactory xsdFactory, XSDSchema xsdSchema) {
        this.xsdFactory = xsdFactory;
        this.xsdSchema = xsdSchema;
    }

    public XSDSchema doConvertRMFPackageSchema2(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        progress.subTask("create XSD global element");
        this.xsdFactory.createGlobalElement3(rootEPackageModel, this.xsdSchema);
        progress.worked(5);
        SubMonitor classProgress = progress.newChild(70);
        classProgress.subTask("create XSD class type definitions");
        this.doConvertToRMFClassTypeDef5(rootEPackageModel, (IProgressMonitor)classProgress);
        SubMonitor enumProgress = progress.newChild(10);
        enumProgress.subTask("create XSD Enum schema");
        this.doConvertToRMFEnumSchema6(rootEPackageModel, (IProgressMonitor)enumProgress);
        SubMonitor dtProgress = progress.newChild(10);
        dtProgress.subTask("create XSD Data type schema");
        this.doConvertToRMFDataTypeSchema7(rootEPackageModel, (IProgressMonitor)dtProgress);
        SubMonitor rstProgress = progress.newChild(5);
        rstProgress.subTask("create referenced simple types");
        this.doConvertToReferencedSimpleType8(rootEPackageModel, (IProgressMonitor)rstProgress);
        return this.xsdSchema;
    }

    public void doConvertToRMFClassTypeDef5(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        SubMonitor _newChild = progress.newChild(50);
        EList _eClassifiers = rootEPackageModel.getEClassifiers();
        int _size = _eClassifiers.size();
        final SubMonitor classProgress = _newChild.setWorkRemaining(_size);
        EList _eClassifiers_1 = rootEPackageModel.getEClassifiers();
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return it instanceof EClass;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eClassifiers_1, (Functions.Function1)_function);
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Ecore2XSDConverter.this.xsdFactory.createClassTypeDefinition5((EClass)it, Ecore2XSDConverter.this.xsdSchema, Ecore2XSDConverter.this.referencedClass, (IProgressMonitor)classProgress);
            }
        };
        _filter.forEach(_function_1);
        SubMonitor _newChild_1 = progress.newChild(50);
        EList _eSubpackages = rootEPackageModel.getESubpackages();
        int _size_1 = _eSubpackages.size();
        final SubMonitor subProgress = _newChild_1.setWorkRemaining(_size_1);
        EList _eSubpackages_1 = rootEPackageModel.getESubpackages();
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToRMFClassTypeDef5(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        _eSubpackages_1.forEach((Consumer)_function_2);
    }

    public void doConvertToRMFEnumSchema6(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        SubMonitor _newChild = progress.newChild(50);
        EList _eClassifiers = rootEPackageModel.getEClassifiers();
        int _size = _eClassifiers.size();
        final SubMonitor classProgress = _newChild.setWorkRemaining(_size);
        EList _eClassifiers_1 = rootEPackageModel.getEClassifiers();
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return it instanceof EEnum;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eClassifiers_1, (Functions.Function1)_function);
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Ecore2XSDConverter.this.xsdFactory.createEnumSchema6((EEnum)it, Ecore2XSDConverter.this.xsdSchema);
                classProgress.worked(1);
                boolean _isCanceled = classProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        _filter.forEach(_function_1);
        SubMonitor _newChild_1 = progress.newChild(50);
        EList _eSubpackages = rootEPackageModel.getESubpackages();
        int _size_1 = _eSubpackages.size();
        final SubMonitor subProgress = _newChild_1.setWorkRemaining(_size_1);
        EList _eSubpackages_1 = rootEPackageModel.getESubpackages();
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToRMFEnumSchema6(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        _eSubpackages_1.forEach((Consumer)_function_2);
    }

    public void doConvertToRMFDataTypeSchema7(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        SubMonitor _newChild = progress.newChild(50);
        EList _eClassifiers = rootEPackageModel.getEClassifiers();
        int _size = _eClassifiers.size();
        final SubMonitor classProgress = _newChild.setWorkRemaining(_size);
        EList _eClassifiers_1 = rootEPackageModel.getEClassifiers();
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                boolean _and = false;
                _and = !(it instanceof EDataType) ? false : !(it instanceof EEnum);
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eClassifiers_1, (Functions.Function1)_function);
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Boolean _isGeneralPrimitiveType = Ecore2XSDConverter.this.isGeneralPrimitiveType((EDataType)it);
                if (_isGeneralPrimitiveType.booleanValue()) {
                    boolean _not;
                    Boolean _isXMLPrimitiveXsdType = Ecore2XSDConverter.this.xsdFactory.isXMLPrimitiveXsdType((EDataType)it);
                    boolean bl = _not = _isXMLPrimitiveXsdType == false;
                    if (_not) {
                        Ecore2XSDConverter.this.xsdFactory.createDataTypeSchema7b((EDataType)it, Ecore2XSDConverter.this.xsdSchema);
                    }
                } else {
                    Ecore2XSDConverter.this.xsdFactory.createDataTypeSchema7a((EDataType)it, Ecore2XSDConverter.this.xsdSchema);
                }
                classProgress.worked(1);
                boolean _isCanceled = classProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        _filter.forEach(_function_1);
        SubMonitor _newChild_1 = progress.newChild(50);
        EList _eClassifiers_2 = rootEPackageModel.getEClassifiers();
        int _size_1 = _eClassifiers_2.size();
        final SubMonitor subProgress = _newChild_1.setWorkRemaining(_size_1);
        EList _eSubpackages = rootEPackageModel.getESubpackages();
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToRMFDataTypeSchema7(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        _eSubpackages.forEach((Consumer)_function_2);
    }

    public void doConvertToReferencedSimpleType8(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        SubMonitor _newChild = progress.newChild(50);
        EList _eClassifiers = rootEPackageModel.getEClassifiers();
        int _size = _eClassifiers.size();
        final SubMonitor classProgress = _newChild.setWorkRemaining(_size);
        EList _eClassifiers_1 = rootEPackageModel.getEClassifiers();
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return it instanceof EClass;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eClassifiers_1, (Functions.Function1)_function);
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Ecore2XSDConverter.this.xsdFactory.createSimpleType8((EClass)it, Ecore2XSDConverter.this.xsdSchema);
                classProgress.worked(1);
                boolean _isCanceled = classProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        _filter.forEach(_function_1);
        SubMonitor _newChild_1 = progress.newChild(50);
        EList _eClassifiers_2 = rootEPackageModel.getEClassifiers();
        int _size_1 = _eClassifiers_2.size();
        final SubMonitor subProgress = _newChild_1.setWorkRemaining(_size_1);
        EList _eSubpackages = rootEPackageModel.getESubpackages();
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToReferencedSimpleType8(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        _eSubpackages.forEach((Consumer)_function_2);
    }

    protected Boolean isGeneralPrimitiveType(EDataType dataType) {
        boolean _notEquals;
        Class instanceClass = dataType.getInstanceClass();
        String _get = JavaXSDPrimitiveTypeMapping.javaXsdPrimitiveTypeMapping.get(instanceClass);
        boolean bl = _notEquals = !Objects.equal((Object)_get, null);
        if (_notEquals) {
            return true;
        }
        return false;
    }
}

