/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sphinx.emf.search.ui.ModelSearchResult;
import org.eclipse.sphinx.emf.search.ui.pages.ModelSearchResultViewPage;
import org.eclipse.sphinx.emf.search.ui.providers.AbstractModelSearchContentProvider;

public class ModelSearchTreeContentProvider
extends AbstractModelSearchContentProvider
implements ITreeContentProvider {
    private Map<Object, Set<Object>> childrenMap;

    public ModelSearchTreeContentProvider(ModelSearchResultViewPage page) {
        super(page);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ModelSearchResult) {
            return ((ModelSearchResult)parentElement).getElements();
        }
        return this.EMPTY_ARR;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    @Override
    protected void initialize(ModelSearchResult result) {
        super.initialize(result);
        this.childrenMap = new HashMap<Object, Set<Object>>();
        if (result != null) {
            Object[] elements;
            Object[] objectArray = elements = result.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.getPage().getDisplayedMatchCount(element) > 0) {
                    this.insert(null, null, element);
                }
                ++n2;
            }
        }
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        if (this.getSearchResult() == null) {
            return;
        }
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getPage().getViewer();
        HashSet toRemove = new HashSet();
        HashSet<Object> toUpdate = new HashSet<Object>();
        HashMap<Object, Set<Object>> toAdd = new HashMap<Object, Set<Object>>();
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object updatedElement = objectArray[n2];
            if (this.getPage().getDisplayedMatchCount(updatedElement) > 0) {
                this.insert(toAdd, toUpdate, updatedElement);
            }
            ++n2;
        }
        viewer.remove(toRemove.toArray());
        for (Object parent : toAdd.keySet()) {
            HashSet children = (HashSet)toAdd.get(parent);
            viewer.add(parent, children.toArray());
        }
        for (Object object : toUpdate) {
            viewer.refresh(object);
        }
    }

    protected void insert(Map<Object, Set<Object>> toAdd, Set<Object> toUpdate, Object child) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (toAdd != null) {
                    this.insertInto(parent, child, toAdd);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.getSearchResult(), child) && toAdd != null) {
            this.insertInto(this.getSearchResult(), child, toAdd);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        return this.insertInto(parent, child, this.childrenMap);
    }

    private boolean insertInto(Object parent, Object child, Map<Object, Set<Object>> map) {
        Set<Object> children = map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    @Override
    public void clear() {
        this.initialize(this.getSearchResult());
        this.getPage().getViewer().refresh();
    }
}

