/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLConstants;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.errorhandler.AttributeValueErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.errorhandler.DefaultErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.errorhandler.ITokenErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeListImpl;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDTokenizer;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.eclipse.actf.model.internal.dom.sgml.impl.InsTokenizer;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDOMImpl;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocType;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityDeclaration;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityReference;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLText;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.AndModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGMLParser
implements ISGMLConstants,
ISGMLParser {
    private boolean isXHTML = false;
    private boolean isEmptyElement = true;
    private boolean isEndWithSlash = false;
    private String currentTagName = "";
    private DOMImplementation domImpl;
    private static Class[] createDocumentMethodParamTypes = new Class[]{String.class, String.class, DocumentType.class};
    public IErrorHandler[] errorHandlers = new IErrorHandler[8];
    private ITokenErrorHandler[] tokenErrorHandlers = new ITokenErrorHandler[8];
    public int errorHandlerNum = 0;
    private int tokenErrorHandlerNum = 0;
    public static final boolean _DEBUG = false;
    private boolean extractNum = true;
    private boolean extractChar = true;
    public InsTokenizer tokenizer;
    private Document doc = null;
    public static Hashtable<String, String> pubEntityMap = new Hashtable();
    public ElementDefinition lastDef = null;
    static IModelGroup pcdata = new IModelGroup(){

        public boolean match(ISGMLParser iSGMLParser, Node node, Node node2) {
            if (node2 instanceof Text && !(node2 instanceof CDATASection)) {
                node.appendChild(node2);
                return true;
            }
            return false;
        }

        public boolean optional() {
            return false;
        }

        public void refer(boolean bl) {
        }

        public String toString() {
            return "#PCDATA";
        }

        public boolean match(int n) {
            return true;
        }

        public boolean[] rehash(int n) {
            boolean[] blArray = new boolean[n];
            blArray[n - 2] = true;
            return blArray;
        }
    };
    static IModelGroup cdata = new IModelGroup(){

        public boolean match(ISGMLParser iSGMLParser, Node node, Node node2) {
            if (node2 instanceof CDATASection) {
                node.appendChild(node2);
                return true;
            }
            return false;
        }

        public boolean optional() {
            return false;
        }

        public void refer(boolean bl) {
        }

        public String toString() {
            return "CDATA";
        }

        public boolean match(int n) {
            return false;
        }

        public boolean[] rehash(int n) {
            return null;
        }
    };
    static IModelGroup empty = new IModelGroup(){

        public boolean match(ISGMLParser iSGMLParser, Node node, Node node2) {
            return false;
        }

        public boolean optional() {
            return true;
        }

        public void refer(boolean bl) {
        }

        public String toString() {
            return "EMPTY";
        }

        public boolean match(int n) {
            return false;
        }

        public boolean[] rehash(int n) {
            return null;
        }
    };
    static IModelGroup any = new IModelGroup(){

        public boolean match(ISGMLParser iSGMLParser, Node node, Node node2) {
            node.appendChild(node2);
            return true;
        }

        public boolean optional() {
            return true;
        }

        public void refer(boolean bl) {
        }

        public boolean match(int n) {
            return true;
        }

        public boolean[] rehash(int n) {
            return null;
        }
    };
    public ElementDefinition anonymousElementDef;
    public SGMLDocTypeDef dtd;
    public Hashtable<Node, AndModelGroup.AndContext> andMap = new Hashtable();
    public Hashtable<Node, Integer> seqMap = new Hashtable();
    public Hashtable<Node, Node> plusMap = new Hashtable();
    public IErrorLogListener[] errorLogListeners = new IErrorLogListener[8];
    public int errorLogListenerNum = 0;
    private static final int BUF_SIZ = 256;
    public int bufCount = 0;
    public Node[] buf = new Node[256];
    public int pcdataNumber;
    public IModelGroup[] seqArray;
    public Element context = null;
    public Element[] forwardPath = new Element[256];
    public ElementDefinition[] ancesterElementDefs = new ElementDefinition[256];
    public Element[] ancesters = new Element[256];
    public int depth = 0;
    public int bufSize = 256;
    public AttributeListImpl nullAttributeList = this.createAttributeList();
    public Vector<Element> nodesWithEndtag = new Vector();
    private Vector<EndTag> missedEndtags = new Vector();
    private Vector<CATB> commentsBeforeDoctype = new Vector();
    private Node[] nodesWithIllegalChildren = new Node[256];
    private int nodeWithIllegalChildNum = 0;
    public AttributeListImpl attrlist = null;
    public int lastElementNumber;
    public ElementDefinition lastElementDef;
    protected String defaultDTD = null;
    private String defaultTopElement = null;
    public int defaultTagCase = 0;
    public int tagCase = 2;
    public int attrCase = 2;
    private String enforcedDoctype = null;
    public Object extraErrInfo = null;
    public DocumentHandler docHandler = null;
    public boolean preserveWhitespace = false;
    public boolean eHandleLogical = true;
    public Vector<Element> autoGenerated = new Vector();
    private boolean keepUnknowns;
    public Node currentNode;
    private boolean keepComment = true;
    private char[] saxch;
    private int begin;
    private int len;
    private LexicalHandler lexHandler;

    public DOMImplementation setDOMImplementation(DOMImplementation dOMImplementation) {
        Class<DOMImplementation> clazz = DOMImplementation.class;
        try {
            Method method = clazz.getMethod("createDocument", createDocumentMethodParamTypes);
            if (method != null) {
                this.domImpl = dOMImplementation;
                this.doc = null;
                return dOMImplementation;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public DOMImplementation getDOMImplementation() {
        return this.domImpl;
    }

    public SGMLParser() {
        this.addErrorHandler(new DefaultErrorHandler());
        this.addTokenErrorHandler(new AttributeValueErrorHandler());
        this.setDOMImplementation(SGMLDOMImpl.getDOMImplementation());
        if (this.getDOMImplementation() == null) {
            this.setDocument(new SGMLDocument());
        }
        this.anonymousElementDef = new ElementDefinition("ANONYMOUS", any);
    }

    public void setErrorHandler(IErrorHandler iErrorHandler) {
        this.addErrorHandler(iErrorHandler);
    }

    @Override
    public void addErrorHandler(IErrorHandler iErrorHandler) {
        if (this.errorHandlerNum == this.errorHandlers.length) {
            IErrorHandler[] iErrorHandlerArray = new IErrorHandler[this.errorHandlers.length * 2];
            int n = 0;
            while (n < this.errorHandlerNum) {
                iErrorHandlerArray[n] = this.errorHandlers[n];
                ++n;
            }
            this.errorHandlers = iErrorHandlerArray;
        }
        this.errorHandlers[this.errorHandlerNum++] = iErrorHandler;
    }

    public void addTokenErrorHandler(ITokenErrorHandler iTokenErrorHandler) {
        if (this.tokenErrorHandlerNum == this.tokenErrorHandlers.length) {
            ITokenErrorHandler[] iTokenErrorHandlerArray = new ITokenErrorHandler[this.errorHandlers.length * 2];
            int n = 0;
            while (n < this.tokenErrorHandlerNum) {
                iTokenErrorHandlerArray[n] = this.tokenErrorHandlers[n];
                ++n;
            }
            this.tokenErrorHandlers = iTokenErrorHandlerArray;
        }
        this.tokenErrorHandlers[this.tokenErrorHandlerNum++] = iTokenErrorHandler;
    }

    @Override
    public IErrorHandler[] getErrorHandlers() {
        IErrorHandler[] iErrorHandlerArray = new IErrorHandler[this.errorHandlerNum];
        int n = 0;
        while (n < this.errorHandlerNum) {
            iErrorHandlerArray[n] = this.errorHandlers[n];
            ++n;
        }
        return iErrorHandlerArray;
    }

    public ITokenErrorHandler[] getTokenErrorHandlers() {
        ITokenErrorHandler[] iTokenErrorHandlerArray = new ITokenErrorHandler[this.errorHandlerNum];
        int n = 0;
        while (n < this.tokenErrorHandlerNum) {
            iTokenErrorHandlerArray[n] = this.tokenErrorHandlers[n];
            ++n;
        }
        return iTokenErrorHandlerArray;
    }

    public void removeErrorHandler(IErrorHandler iErrorHandler) {
        int n = 0;
        while (n < this.errorHandlerNum) {
            if (this.errorHandlers[n] == iErrorHandler) {
                this.errorHandlers[n] = null;
                ++n;
                while (n < this.errorHandlerNum) {
                    this.errorHandlers[n - 1] = this.errorHandlers[n];
                    ++n;
                }
                --this.errorHandlerNum;
                return;
            }
            ++n;
        }
    }

    public void removeTokenErrorHandler(ITokenErrorHandler iTokenErrorHandler) {
        int n = 0;
        while (n < this.tokenErrorHandlerNum) {
            if (this.tokenErrorHandlers[n] == iTokenErrorHandler) {
                this.tokenErrorHandlers[n] = null;
                ++n;
                while (n < this.tokenErrorHandlerNum) {
                    this.tokenErrorHandlers[n - 1] = this.tokenErrorHandlers[n];
                    ++n;
                }
                --this.errorHandlerNum;
                return;
            }
            ++n;
        }
    }

    public void extractEntity(boolean bl) {
        this.extractChar = this.extractNum = bl;
    }

    public void extractNumEntity(boolean bl) {
        this.extractNum = bl;
    }

    public boolean extractNumEntity() {
        return this.extractNum;
    }

    public void extractCharEntity(boolean bl) {
        this.extractChar = bl;
    }

    public boolean extractCharEntity() {
        return this.extractChar;
    }

    public static Hashtable<String, String> getPublicEntityMap() {
        return pubEntityMap;
    }

    public ElementDefinition getAnonymousElementDefinition() {
        return this.anonymousElementDef;
    }

    @Override
    public SGMLDocTypeDef getDTD() {
        return this.dtd;
    }

    public final void setDTD(SGMLDocTypeDef sGMLDocTypeDef) {
        this.dtd = sGMLDocTypeDef;
        if (this.doc instanceof SGMLDocument) {
            ((SGMLDocument)this.doc).setDTD(sGMLDocTypeDef);
        }
        this.isXHTML = sGMLDocTypeDef.toString().indexOf("XHTML") > -1;
    }

    @Override
    public Hashtable<Node, AndModelGroup.AndContext> getAndMap() {
        return this.andMap;
    }

    @Override
    public Hashtable<Node, Integer> getSeqMap() {
        return this.seqMap;
    }

    @Override
    public Hashtable<Node, Node> getPlusMap() {
        return this.plusMap;
    }

    @Override
    public void clearContextMap(Node node) {
        this.andMap.remove(node);
        this.seqMap.remove(node);
        this.plusMap.remove(node);
    }

    private Attr attribute(ElementDefinition elementDefinition, AttributeListImpl attributeListImpl) throws IOException, ParseException, SAXException {
        Attr attr = null;
        if (this.tokenizer.nextToken() != 11) {
            if (this.handleError(13, this.tokenizer.sval)) {
                return this.attribute(elementDefinition, attributeListImpl);
            }
        } else {
            String string = this.changeAttrNameCase(this.tokenizer.sval);
            AttributeDefinition attributeDefinition = elementDefinition != null ? elementDefinition.getAttributeDef(string) : null;
            String string2 = string;
            if (this.tokenizer.nextToken() == 61) {
                string2 = this.tokenizer.readAttributeValue(attributeDefinition, elementDefinition);
                attr = this.doc.createAttribute(string);
                attr.setValue(string2);
            } else {
                this.tokenizer.pushBack();
                attr = this.doc.createAttribute(string);
            }
            if (attributeDefinition == null) {
                if (attributeListImpl != null) {
                    attributeListImpl.addAttribute(string, "CDATA", string2);
                }
                if (elementDefinition != null && elementDefinition != this.anonymousElementDef) {
                    if (this.handleError(4, attr)) {
                        attr = this.attribute(elementDefinition, attributeListImpl);
                    } else {
                        this.error(4, "Illegal attribute '" + string + "' for " + elementDefinition.getName());
                    }
                }
            } else if (attributeListImpl != null) {
                attributeListImpl.addAttribute(string, attributeDefinition.getDeclaredTypeStr(), string2);
            }
        }
        return attr;
    }

    @Override
    public final void error(int n, String string) {
        int n2 = 0;
        while (n2 < this.errorLogListenerNum) {
            if (this.tokenizer != null) {
                this.errorLogListeners[n2].errorLog(n, String.valueOf(this.tokenizer.getCurrentLine()) + ": " + string);
            } else {
                this.errorLogListeners[n2].errorLog(n, string);
            }
            ++n2;
        }
    }

    @Override
    public void addErrorLogListener(IErrorLogListener iErrorLogListener) {
        if (this.errorLogListenerNum == this.errorLogListeners.length) {
            IErrorLogListener[] iErrorLogListenerArray = new IErrorLogListener[this.errorLogListenerNum * 2];
            int n = 0;
            while (n < this.errorLogListenerNum) {
                iErrorLogListenerArray[n] = this.errorLogListeners[n];
                ++n;
            }
            this.errorLogListeners = iErrorLogListenerArray;
        }
        this.errorLogListeners[this.errorLogListenerNum++] = iErrorLogListener;
    }

    public void removeErrorLogListener(IErrorLogListener iErrorLogListener) {
        int n = 0;
        while (n < this.errorLogListenerNum) {
            if (this.errorLogListeners[n] == iErrorLogListener) {
                this.errorLogListeners[n] = null;
                ++n;
                while (n < this.errorLogListenerNum) {
                    this.errorLogListeners[n - 1] = this.errorLogListeners[n];
                    ++n;
                }
                --this.errorLogListenerNum;
                return;
            }
            ++n;
        }
    }

    private EndTag etag() throws IOException, ParseException, SAXException {
        if (this.tokenizer.nextToken() == 11) {
            ElementDefinition elementDefinition;
            String string = this.changeTagCase(this.tokenizer.sval);
            while (this.tokenizer.nextToken() != 62 && this.tokenizer.ttype != -1) {
            }
            EndTag endTag = new EndTag(string);
            this.currentNode = endTag;
            if (this.docHandler != null && !this.eHandleLogical) {
                this.docHandler.endElement(string);
            }
            if ((elementDefinition = this.dtd.getElementDefinition(string)) != null) {
                this.lastElementNumber = elementDefinition.number;
                return endTag;
            }
            if (this.keepUnknowns) {
                this.lastElementDef = this.anonymousElementDef;
                this.lastElementNumber = this.pcdataNumber + 1;
                return endTag;
            }
            if (this.handleError(8, endTag)) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public Node getNode() throws ParseException, IOException, SAXException {
        if (this.bufCount == 0) {
            return this.node();
        }
        return this.buf[--this.bufCount];
    }

    @Override
    public void pushBackNode(Node node) {
        this.buf[this.bufCount++] = node;
        if (node instanceof Element) {
            this.lastElementDef = this.dtd.getElementDefinition(node.getNodeName());
            this.lastElementNumber = this.lastElementDef.number;
        }
    }

    protected Reader getResource(String string) throws IOException {
        throw new IOException("cannot find " + string);
    }

    public Node node() throws ParseException, IOException, SAXException {
        Node node;
        if (this.isEndWithSlash && !this.isEmptyElement) {
            ElementDefinition elementDefinition;
            this.isEndWithSlash = false;
            EndTag endTag = new EndTag(this.currentTagName);
            this.currentNode = endTag;
            if (this.docHandler != null && !this.eHandleLogical) {
                this.docHandler.endElement(this.currentTagName);
            }
            if ((elementDefinition = this.dtd.getElementDefinition(this.currentTagName)) != null) {
                this.lastElementNumber = elementDefinition.number;
                return endTag;
            }
            if (this.keepUnknowns) {
                this.lastElementDef = this.anonymousElementDef;
                this.lastElementNumber = this.pcdataNumber + 1;
                return endTag;
            }
            if (this.handleError(8, endTag)) {
                return null;
            }
        }
        switch (this.tokenizer.nextToken()) {
            case 60: {
                node = this.stag();
                if (node != null) break;
                node = this.getNode();
                break;
            }
            case 8: {
                node = this.etag();
                if (node != null) break;
                node = this.node();
                break;
            }
            case 15: {
                this.currentNode = node = this.doc.createTextNode(this.tokenizer.sval);
                if (node instanceof SGMLText) {
                    ((SGMLText)node).setIsWhitespaceInElementContent(true);
                }
                if (this.docHandler == null || this.saxch == null) break;
                this.docHandler.characters(this.saxch, this.begin, this.len);
                this.saxch = null;
                break;
            }
            case 14: {
                this.currentNode = node = this.doc.createTextNode(this.tokenizer.sval);
                if (this.docHandler == null || this.saxch == null) break;
                this.docHandler.characters(this.saxch, this.begin, this.len);
                this.saxch = null;
                break;
            }
            case 13: {
                this.currentNode = node = this.doc.createComment(this.tokenizer.sval);
                if (this.lexHandler == null) break;
                this.lexHandler.comment(this.saxch, this.begin, this.len);
                this.saxch = null;
                break;
            }
            case 17: {
                this.currentNode = node = this.doc.createProcessingInstruction(null, this.tokenizer.sval);
                if (this.docHandler == null) break;
                this.docHandler.processingInstruction(null, this.tokenizer.sval);
                break;
            }
            case -1: {
                node = null;
                break;
            }
            case 1: {
                this.error(2, "Illegal Declaration. Discarding to next '>'");
                if (this.tokenizer.nextToken() != 62) {
                    this.tokenizer.consumeUntil('>');
                    this.tokenizer.switchTo(0);
                }
                return this.node();
            }
            default: {
                this.error(10, "Internal Parser Error: character encoding may be wrong.");
                return this.node();
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupDTD(String string) throws ParseException, IOException {
        SGMLDocTypeDef sGMLDocTypeDef = SGMLDocTypeDef.getPublic(string = this.makeUnique(string));
        if (sGMLDocTypeDef != null) {
            this.setDTD(sGMLDocTypeDef);
            this.lastDef = sGMLDocTypeDef.getElementDefinition(this.getDefaultTopElement());
        } else {
            String string2 = string;
            synchronized (string2) {
                sGMLDocTypeDef = SGMLDocTypeDef.getPublic(string);
                if (sGMLDocTypeDef == null) {
                    sGMLDocTypeDef = SGMLDocTypeDef.createPublic(string, this);
                    this.setDTD(sGMLDocTypeDef);
                    Reader reader = this.getResource(pubEntityMap.get(string));
                    DTDTokenizer dTDTokenizer = new DTDTokenizer(reader);
                    new DTDParser(dTDTokenizer, sGMLDocTypeDef).readDTD();
                    reader.close();
                    SGMLDocTypeDef.putPublic(string, sGMLDocTypeDef);
                    sGMLDocTypeDef.rehash();
                } else {
                    this.setDTD(sGMLDocTypeDef);
                }
            }
        }
        this.lastDef = this.dtd.getElementDefinition(this.getDefaultTopElement());
        this.pcdataNumber = this.dtd.getElementCount();
        int n = this.depth - 1;
        while (n >= 0) {
            this.ancesterElementDefs[n] = this.dtd.getElementDefinition(this.ancesterElementDefs[n].getName());
            if (this.ancesterElementDefs[n] == null) {
                this.error(8, String.valueOf(this.ancesters[n].getNodeName()) + " is not defined in " + string);
                this.ancesterElementDefs[n] = this.anonymousElementDef;
            }
            --n;
        }
        this.anonymousElementDef.rehash(this.pcdataNumber + 2);
        this.anonymousElementDef.number = this.pcdataNumber + 1;
    }

    public Node parse(Reader reader) throws ParseException, IOException, SAXException {
        Object object;
        if (this.domImpl == null && this.doc == null) {
            throw new ParseException("No factory instance.");
        }
        this.init();
        this.tokenizer = new InsTokenizer(reader, this);
        if (this.docHandler != null) {
            this.docHandler.setDocumentLocator(this.tokenizer);
            this.docHandler.startDocument();
        }
        this.setDTD(SGMLDocTypeDef.createAnonymous(this));
        DocumentType documentType = this.readDocType();
        if (documentType == null) {
            this.error(1, "<!DOCTYPE ...> is missing.  Try to use \"" + this.defaultDTD + "\" as document type");
            this.setupDTD(this.defaultDTD);
        }
        this.tokenizer.extractNumEntity(this.extractNum);
        this.tokenizer.extractCharEntity(this.extractChar);
        this.tokenizer.setPreserveWhitespace(this.preserveWhitespace);
        if (this.doc == null) {
            this.doc = this.createDocument(documentType);
            if (this.doc instanceof SGMLDocument && ((SGMLDocument)this.doc).getDTD() == null) {
                ((SGMLDocument)this.doc).setDTD(this.dtd);
            }
            while (!this.commentsBeforeDoctype.isEmpty()) {
                object = this.commentsBeforeDoctype.lastElement();
                Node node = ((CATB)object).comment ? this.doc.createComment(((CATB)object).str) : this.doc.createProcessingInstruction(null, ((CATB)object).str);
                this.doc.insertBefore(node, this.doc.getFirstChild());
                this.commentsBeforeDoctype.removeElement(object);
            }
        }
        this.context = this.doc.createElement("dummy0");
        this.seqArray = new IModelGroup[this.dtd.maxSeqLength];
        object = this.readInstances();
        if (this.docHandler != null) {
            this.docHandler.endDocument();
        }
        return object;
    }

    @Override
    public IModelGroup[] getSeqArray() {
        return this.seqArray;
    }

    protected Document createDocument(DocumentType documentType) {
        Document document = this.domImpl.createDocument("dummy1", "dummy1", documentType);
        if (document.getDocumentElement() != null) {
            document.removeChild(document.getDocumentElement());
        }
        return document;
    }

    @Override
    public Element getContext() {
        return this.context;
    }

    private void setContextForward(Element element) throws SAXException {
        Object object;
        if (this.depth >= this.bufSize) {
            object = new Element[this.bufSize * 2];
            System.arraycopy(this.ancesters, 0, object, 0, this.bufSize);
            this.ancesters = object;
            ElementDefinition[] elementDefinitionArray = new ElementDefinition[this.bufSize * 2];
            System.arraycopy(this.ancesterElementDefs, 0, elementDefinitionArray, 0, this.bufSize);
            this.ancesterElementDefs = elementDefinitionArray;
            this.bufSize *= 2;
        }
        if (this.eHandleLogical && this.docHandler != null) {
            object = this.context.getLastChild();
            while (object instanceof Element) {
                ElementDefinition elementDefinition;
                if (object == element) {
                    this.ancesters[this.depth] = element;
                    this.ancesterElementDefs[this.depth] = this.lastElementDef;
                    ++this.depth;
                    this.docHandler.startElement(element.getNodeName(), this.attrlist);
                    this.attrlist = null;
                    this.context = element;
                    return;
                }
                this.ancesters[this.depth] = (Element)object;
                this.ancesterElementDefs[this.depth] = elementDefinition = this.dtd.getElementDefinition(object.getNodeName());
                if (elementDefinition == null) {
                    this.ancesterElementDefs[this.depth] = this.anonymousElementDef;
                }
                this.docHandler.startElement(object.getNodeName(), this.nullAttributeList);
                ++this.depth;
                object = object.getLastChild();
            }
        } else {
            object = this.context.getLastChild();
            while (object instanceof Element) {
                ElementDefinition elementDefinition;
                if (object == element) {
                    this.ancesters[this.depth] = element;
                    this.ancesterElementDefs[this.depth] = this.lastElementDef;
                    ++this.depth;
                    this.attrlist = null;
                    this.context = element;
                    return;
                }
                this.ancesters[this.depth] = (Element)object;
                this.ancesterElementDefs[this.depth] = elementDefinition = this.dtd.getElementDefinition(object.getNodeName());
                if (elementDefinition == null) {
                    this.ancesterElementDefs[this.depth] = this.anonymousElementDef;
                }
                ++this.depth;
                object = object.getLastChild();
            }
        }
        throw new RuntimeException("Internal Parser Error.");
    }

    private void setContextBackward(int n) throws SAXException {
        if (this.eHandleLogical && this.docHandler != null) {
            int n2 = this.depth - 1;
            while (n2 >= n) {
                this.docHandler.endElement(this.ancesters[n2].getNodeName());
                --n2;
            }
        }
        this.depth = n;
        this.context = this.ancesters[n - 1];
    }

    @Override
    public final void setContext(Element elementArray) throws SAXException {
        Object object;
        int n;
        Object object2;
        int n2 = this.depth - 1;
        while (n2 >= 0) {
            object2 = this.ancesters[n2];
            if (object2 == elementArray) {
                if (this.eHandleLogical && this.docHandler != null) {
                    n = this.depth - 1;
                    while (n > n2) {
                        this.docHandler.endElement(this.ancesters[n].getNodeName());
                        --n;
                    }
                }
                this.depth = n2 + 1;
                this.context = elementArray;
                return;
            }
            n = 0;
            object = object2.getLastChild();
            while (object instanceof Element) {
                if (object == elementArray) {
                    if (this.eHandleLogical && this.docHandler != null) {
                        int n3 = this.depth - 1;
                        while (n3 > n2) {
                            this.docHandler.endElement(this.ancesters[n3].getNodeName());
                            --n3;
                        }
                        n3 = 0;
                        while (n3 < n) {
                            this.docHandler.startElement(this.forwardPath[n3].getNodeName(), this.nullAttributeList);
                            this.ancesters[n2 + n3 + 1] = this.forwardPath[n3];
                            this.ancesterElementDefs[n2 + n3 + 1] = this.dtd.getElementDefinition(this.forwardPath[n3].getNodeName());
                            if (this.ancesterElementDefs[n2 + n3 + 1] == null) {
                                this.ancesterElementDefs[n2 + n3 + 1] = this.anonymousElementDef;
                            }
                            ++n3;
                        }
                        this.docHandler.startElement(object.getNodeName(), this.attrlist);
                    } else {
                        int n4 = 0;
                        while (n4 < n) {
                            this.ancesters[n2 + n4 + 1] = this.forwardPath[n4];
                            this.ancesterElementDefs[n2 + n4 + 1] = this.dtd.getElementDefinition(this.forwardPath[n4].getNodeName());
                            if (this.ancesterElementDefs[n2 + n4 + 1] == null) {
                                this.ancesterElementDefs[n2 + n4 + 1] = this.anonymousElementDef;
                            }
                            ++n4;
                        }
                    }
                    this.depth = n2 + n + 1;
                    this.ancesters[this.depth] = elementArray;
                    this.ancesterElementDefs[this.depth] = this.lastElementDef;
                    ++this.depth;
                    this.attrlist = null;
                    this.context = elementArray;
                    return;
                }
                this.forwardPath[n++] = (Element)object;
                object = object.getLastChild();
            }
            --n2;
        }
        n2 = 0;
        object2 = elementArray;
        while (object2 instanceof Element) {
            ++n2;
            object2 = object2.getParentNode();
        }
        object2 = new Element[n2];
        n = 1;
        object = elementArray;
        while (object instanceof Element) {
            object2[n2 - n] = (Element)object;
            ++n;
            object = object.getParentNode();
        }
        n = 0;
        while (n < n2) {
            if (this.ancesters[n] != object2[n]) {
                if (this.eHandleLogical && this.docHandler != null) {
                    int n5 = this.depth - 1;
                    while (n5 >= n) {
                        this.docHandler.endElement(this.ancesters[n5].getNodeName());
                        --n5;
                    }
                    n5 = n;
                    while (n5 < n2 - 1) {
                        this.docHandler.startElement(object2[n5].getNodeName(), this.nullAttributeList);
                        ++n5;
                    }
                    this.docHandler.startElement(elementArray.getNodeName(), this.attrlist);
                }
                while (n < n2 - 1) {
                    this.ancesters[n] = object2[n];
                    this.ancesterElementDefs[n] = this.dtd.getElementDefinition(object2[n].getNodeName());
                }
                this.ancesters[n2 - 1] = elementArray;
                this.ancesterElementDefs[n2 - 1] = this.lastElementDef;
                this.depth = n2;
                this.attrlist = null;
                this.context = elementArray;
                return;
            }
            ++n;
        }
    }

    @Override
    public boolean hasEndTag(Element element) {
        return this.nodesWithEndtag.contains(element);
    }

    @Override
    public void setHasEndTag(Element element) {
        this.nodesWithEndtag.addElement(element);
    }

    private void setTopElement(Element element) throws SAXException {
        Element element2 = this.doc.getDocumentElement();
        if (element2 != null) {
            this.doc.replaceChild(element, element2);
        } else {
            this.doc.appendChild(element);
        }
        this.context = element;
        if (this.docHandler != null && this.eHandleLogical) {
            AttributeListImpl attributeListImpl = this.attrlist != null ? this.attrlist : this.nullAttributeList;
            this.docHandler.startElement(element.getNodeName(), attributeListImpl);
            this.attrlist = null;
        }
        this.ancesterElementDefs[0] = this.lastDef;
        this.ancesters[0] = element;
        ++this.depth;
    }

    /*
     * Unable to fully structure code
     */
    private Node readInstances() throws ParseException, IOException, SAXException {
        var1_1 = this.getNode();
        if (var1_1 != null) ** GOTO lbl8
        return this.doc;
lbl-1000:
        // 1 sources

        {
            if (this.keepComment) {
                this.doc.appendChild(var1_1);
            }
            var1_1 = this.getNode();
lbl8:
            // 2 sources

            ** while (var1_1.getNodeType() == 8 || var1_1.getNodeType() == 7)
        }
lbl9:
        // 1 sources

        switch (var1_1.getNodeType()) {
            case -1: {
                if (!this.handleError(5, var1_1)) {
                    if (this.eHandleLogical && this.docHandler != null) {
                        this.docHandler.ignorableWhitespace(this.saxch, this.begin, this.len);
                    }
                    this.error(5, "Illegal end tag: " + var1_1 + ".  Ignore it.");
                }
                return this.readInstances();
            }
            case 1: {
                if (this.lastDef.instance(var1_1)) {
                    this.setTopElement((Element)var1_1);
                } else {
                    var2_2 = this.attrlist;
                    this.attrlist = null;
                    this.setTopElement(this.doc.createElement(this.changeDefaultTagCase(this.lastDef.getName())));
                    this.attrlist = var2_2;
                    this.addAutoGenerated(this.context);
                    if (this.lastDef.getContentModel().match(this, this.context, var1_1)) {
                        if (!this.lastDef.startTagOmittable()) {
                            this.error(3, var1_1 + " can't be a top element.");
                        }
                        this.setContextForward((Element)var1_1);
                    } else if (!this.handleError(7, var1_1)) {
                        this.addErrorNode(this.context);
                        this.error(7, var1_1 + " is not allowed as a child of " + this.context);
                        this.context.appendChild(var1_1);
                        this.setContextForward((Element)var1_1);
                    }
                }
                this.postElement((Element)var1_1);
                break;
            }
            case 3: {
                if (this.preserveWhitespace && this.whitespaceText((Text)var1_1)) {
                    return this.readInstances();
                }
                this.error(3, "#text can't be a top element");
                this.setTopElement(this.doc.createElement(this.changeDefaultTagCase(this.lastDef.getName())));
                this.addAutoGenerated(this.context);
                this.context.appendChild(var1_1);
                break;
            }
            default: {
                throw new ParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": Internal Parser Error " + var1_1);
            }
        }
        return this.readInstances2();
    }

    private Node readInstances2() throws ParseException, IOException, SAXException {
        Node node = this.getNode();
        block6: while (node != null) {
            block0 : switch (node.getNodeType()) {
                case 7: 
                case 8: {
                    if (!this.keepComment) break;
                    this.context.appendChild(node);
                    break;
                }
                case -1: {
                    this.missedEndtags.removeAllElements();
                    int n = this.depth - 1;
                    while (n >= 0) {
                        if (this.ancesterElementDefs[n].number == this.lastElementNumber && (this.lastElementNumber != this.pcdataNumber + 1 || this.ancesters[n].getNodeName().equalsIgnoreCase(node.getNodeName()))) {
                            if (!this.missedEndtags.isEmpty()) {
                                this.extraErrInfo = this.missedEndtags;
                                if (this.handleError(6, node)) {
                                    this.extraErrInfo = null;
                                    break block0;
                                }
                                this.extraErrInfo = null;
                                this.error(6, this.missedEndtags + " have been forced to be inserted by " + node);
                            }
                            ((EndTag)node).setElement(this.ancesters[n]);
                            this.nodesWithEndtag.addElement(this.ancesters[n]);
                            if (n <= 0) break block6;
                            this.setContextBackward(n);
                            break block0;
                        }
                        if (!this.ancesterElementDefs[n].endTagOmittable()) {
                            this.missedEndtags.insertElementAt(new EndTag(this.ancesters[n].getNodeName()), 0);
                        }
                        --n;
                    }
                    if (this.handleError(5, node)) break;
                    if (this.eHandleLogical && this.docHandler != null) {
                        this.docHandler.ignorableWhitespace(this.saxch, this.begin, this.len);
                    }
                    this.error(5, "Illegal end tag: " + node + ".  Ignore it");
                    break;
                }
                case 1: {
                    int n;
                    ElementDefinition elementDefinition;
                    Element element = (Element)node;
                    Element element2 = null;
                    int n2 = this.depth - 1;
                    while (n2 >= 0) {
                        elementDefinition = this.ancesterElementDefs[n2];
                        if (!elementDefinition.endTagOmittable() && element2 == null) {
                            element2 = this.ancesters[n2];
                        }
                        if (elementDefinition.exclusion(this.lastElementNumber)) {
                            if (element2 != null) {
                                if (!this.handleError(7, node)) {
                                    this.addErrorNode(this.context);
                                    this.error(7, node + " is an exception uner " + this.ancesters[n2]);
                                    break;
                                }
                                if (this.context != node && this.eHandleLogical && this.docHandler != null) {
                                    this.docHandler.startElement(node.getNodeName(), this.attrlist);
                                }
                                this.postElement(element);
                                break block0;
                            }
                            if (this.ancesters[n2 - 1] == null) break;
                            this.setContextBackward(n2);
                            break;
                        }
                        if (elementDefinition.inclusion(this.lastElementNumber)) {
                            this.context.appendChild(node);
                            this.setContextForward(element);
                            this.postElement(element);
                            break block0;
                        }
                        --n2;
                    }
                    elementDefinition = this.ancesterElementDefs[this.depth - 1];
                    IModelGroup iModelGroup = elementDefinition.getContentModel();
                    if (iModelGroup.match(this.lastElementNumber) && iModelGroup.match(this, this.context, node)) {
                        this.setContextForward(element);
                    } else if (elementDefinition.endTagOmittable()) {
                        n = 0;
                        int n3 = this.depth - 2;
                        while (n3 >= 0) {
                            elementDefinition = this.ancesterElementDefs[n3];
                            iModelGroup = elementDefinition.getContentModel();
                            if (iModelGroup.match(this.lastElementNumber)) {
                                boolean bl = iModelGroup.match(this, this.ancesters[n3], node);
                                n = bl ? 1 : 0;
                                if (bl) break;
                            }
                            if (!elementDefinition.endTagOmittable()) break;
                            --n3;
                        }
                        if (n != 0) {
                            this.setContext(element);
                        } else if (!this.handleError(7, node)) {
                            this.context.appendChild(element);
                            this.addErrorNode(this.context);
                            this.error(7, node + " is not allowed as a child of " + this.context);
                            this.setContextForward(element);
                        } else if (element.getParentNode() != null) {
                            this.postElement(element);
                            break;
                        }
                    } else if (!this.handleError(7, node)) {
                        this.context.appendChild(element);
                        this.addErrorNode(this.context);
                        this.error(7, node + " is not allowed as a child of " + this.context);
                        this.setContextForward(element);
                    }
                    if (this.context != node && this.eHandleLogical && this.docHandler != null) {
                        this.docHandler.startElement(node.getNodeName(), this.attrlist);
                    }
                    this.postElement(element);
                    break;
                }
                case 3: {
                    int n;
                    if (this.preserveWhitespace && this.whitespaceText((Text)node)) {
                        this.getContext().appendChild(node);
                        break;
                    }
                    ElementDefinition elementDefinition = this.ancesterElementDefs[this.depth - 1];
                    IModelGroup iModelGroup = elementDefinition.getContentModel();
                    if (iModelGroup.match(this.pcdataNumber) && iModelGroup.match(this, this.context, node)) break;
                    if (elementDefinition.endTagOmittable()) {
                        n = this.depth - 2;
                        while (n >= 0) {
                            elementDefinition = this.ancesterElementDefs[n];
                            iModelGroup = elementDefinition.getContentModel();
                            if (iModelGroup.match(this.pcdataNumber) && iModelGroup.match(this, this.ancesters[n], node)) break block0;
                            if (!elementDefinition.endTagOmittable()) break;
                            --n;
                        }
                    }
                    if (this.handleError(7, node)) break;
                    this.addErrorNode(this.context);
                    this.error(7, "#text(" + node + ") is not allowed as a child of " + this.context);
                    this.context.appendChild(node);
                    break;
                }
                default: {
                    throw new ParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": Internal parser error " + node);
                }
            }
            node = this.getNode();
        }
        if (this.docHandler != null && this.eHandleLogical) {
            Element element = this.doc.getDocumentElement();
            if (this.getContext() != element) {
                this.setContext(element);
            }
            if (element != null) {
                this.docHandler.endElement(element.getNodeName());
            }
        }
        if ((node = this.getNode()) != null) {
            this.context = this.doc.getDocumentElement();
            if (this.docHandler != null && this.eHandleLogical) {
                this.docHandler.startElement(this.context.getNodeName(), this.nullAttributeList);
            }
            this.pushBackNode(node);
            this.readInstances2();
        }
        return this.doc;
    }

    private boolean whitespaceText(Text text) {
        if (text instanceof SGMLText) {
            return ((SGMLText)text).getIsWhitespaceInElementContent();
        }
        char[] cArray = text.getData().toCharArray();
        int n = cArray.length - 1;
        while (n >= 0) {
            if (!Character.isWhitespace(cArray[n])) {
                return false;
            }
            --n;
        }
        return true;
    }

    private void postElement(Element element) throws ParseException, IOException, SAXException {
        IModelGroup iModelGroup = this.lastElementDef.getContentModel();
        if (iModelGroup == cdata) {
            String string = element.getNodeName();
            CDATASection cDATASection = this.readCDATA(string);
            this.currentNode = new EndTag(string);
            ((EndTag)this.currentNode).setElement(element);
            this.nodesWithEndtag.addElement(element);
            if (this.docHandler != null && !this.eHandleLogical) {
                this.docHandler.endElement(string);
            }
            element.appendChild(cDATASection);
            if (this.context == element) {
                this.setContextBackward(this.depth - 1);
            }
        } else if (iModelGroup == empty && this.lastElementDef.endTagOmittable()) {
            if (this.context == element) {
                this.setContextBackward(this.depth - 1);
            } else if (this.eHandleLogical && this.docHandler != null) {
                this.docHandler.endElement(element.getNodeName());
            }
        } else if (this.isXHTML) {
            // empty if block
        }
    }

    private CDATASection readCDATA(String string) throws ParseException, IOException, SAXException {
        if (this.lexHandler != null) {
            this.lexHandler.startCDATA();
        }
        String string2 = this.tokenizer.rawText(string);
        CDATASection cDATASection = this.doc.createCDATASection(string2);
        this.currentNode = cDATASection;
        if (this.lexHandler != null) {
            this.lexHandler.endCDATA();
        }
        this.tokenizer.eatCDATAEndTag();
        return cDATASection;
    }

    private DocumentType readDocType() throws ParseException, IOException, SAXException {
        Object object;
        if (this.lastDef != null) {
            throw new ParseException("Already read DOCTYPE declaration");
        }
        block5: while (true) {
            switch (this.tokenizer.nextToken()) {
                case 13: {
                    if (this.doc == null) {
                        object = new CATB();
                        ((CATB)object).str = this.tokenizer.sval;
                        this.commentsBeforeDoctype.addElement((CATB)object);
                    } else {
                        this.currentNode = this.doc.createComment(this.tokenizer.sval);
                        this.doc.appendChild(this.currentNode);
                    }
                    if (this.lexHandler == null) continue block5;
                    this.lexHandler.comment(this.saxch, this.begin, this.len);
                    continue block5;
                }
                case 17: {
                    if (this.doc == null) {
                        object = new CATB();
                        ((CATB)object).comment = false;
                        ((CATB)object).str = this.tokenizer.sval;
                        this.commentsBeforeDoctype.addElement((CATB)object);
                    } else {
                        this.currentNode = this.doc.createProcessingInstruction(null, this.tokenizer.sval);
                        this.doc.appendChild(this.currentNode);
                    }
                    if (this.docHandler == null) continue block5;
                    this.docHandler.processingInstruction(null, this.tokenizer.sval);
                    continue block5;
                }
                case 1: {
                    break block5;
                }
                default: {
                    this.tokenizer.pushBack();
                    return null;
                }
            }
            break;
        }
        if (this.tokenizer.nextToken() != 11 && !this.tokenizer.sval.equals("DOCTYPE")) {
            throw new ParseException("Unknown declaration at " + this.tokenizer.getCurrentLine());
        }
        if (this.tokenizer.nextToken() == 11) {
            this.defaultTopElement = object = this.tokenizer.sval;
            if (this.tokenizer.nextToken() == 11 && this.tokenizer.sval.equalsIgnoreCase("PUBLIC") && this.tokenizer.nextToken() == 34) {
                String string;
                String string2;
                String string3 = string2 = this.tokenizer.eatUntil('\"');
                if (this.enforcedDoctype != null) {
                    string2 = this.enforcedDoctype;
                }
                if (this.lexHandler != null) {
                    this.lexHandler.startDTD((String)object, string2, null);
                }
                if ((string = pubEntityMap.get(string2)) == null) {
                    if (this.defaultDTD != null) {
                        this.error(2, "Instead of \"" + string2 + "\" use \"" + this.defaultDTD + "\" as a DTD.");
                        string = pubEntityMap.get(this.defaultDTD);
                    }
                    if (string == null) {
                        throw new ParseException(String.valueOf(this.tokenizer.getCurrentLine()) + ": this parser does not support " + string2);
                    }
                    string2 = this.defaultDTD;
                }
                this.setupDTD(string2);
                if (this.domImpl == null) {
                    this.domImpl = this.doc.getImplementation();
                }
                DocumentType documentType = null;
                if (this.domImpl != null) {
                    documentType = this.createDocType(this.domImpl, (String)object, string2);
                    this.currentNode = documentType;
                    if (!string2.equals(string3) && documentType instanceof SGMLDocType) {
                        ((SGMLDocType)documentType).setOrgId(string3);
                    }
                }
                this.tokenizer.consumeUntil('>');
                this.tokenizer.switchTo(0);
                this.lastDef = this.dtd.getElementDefinition((String)object);
                if (this.lastDef == null) {
                    String string4 = this.getDefaultTopElement();
                    this.error(2, String.valueOf(object) + " is not defined as a root element.  Use " + string4 + '.');
                    this.lastDef = this.dtd.getElementDefinition(string4);
                }
                if (this.lexHandler != null) {
                    this.lexHandler.endDTD();
                }
                return documentType;
            }
        }
        this.tokenizer.consumeUntil('>');
        this.error(2, "Invalid DOCTYPE declaration. Use " + this.defaultDTD);
        this.setupDTD(this.defaultDTD);
        this.lastDef = this.dtd.getElementDefinition(this.getDefaultTopElement());
        return null;
    }

    private DocumentType createDocType(DOMImplementation dOMImplementation, String string, String string2) {
        Method method;
        Class<?> clazz = dOMImplementation.getClass();
        Class<?> clazz2 = string.getClass();
        Class[] classArray = new Class[]{clazz2, clazz2, clazz2};
        try {
            method = clazz.getMethod("createDocumentType", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        Object[] objectArray = new String[]{string, string2, ""};
        try {
            return (DocumentType)method.invoke((Object)dOMImplementation, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    private void expandNodesWithIllegalChildren() {
        Node[] nodeArray = new Node[this.nodeWithIllegalChildNum * 2];
        System.arraycopy(this.nodesWithIllegalChildren, 0, nodeArray, 0, this.nodeWithIllegalChildNum);
        this.nodesWithIllegalChildren = nodeArray;
    }

    private void addErrorNode(Node node) {
        int n = this.nodeWithIllegalChildNum - 1;
        while (n >= 0) {
            if (this.nodesWithIllegalChildren[n] == node) {
                return;
            }
            --n;
        }
        if (this.nodesWithIllegalChildren.length == this.nodeWithIllegalChildNum) {
            this.expandNodesWithIllegalChildren();
        }
        this.nodesWithIllegalChildren[this.nodeWithIllegalChildNum++] = node;
    }

    public boolean isErrorNode(Node node) {
        int n = this.nodeWithIllegalChildNum - 1;
        while (n >= 0) {
            if (this.nodesWithIllegalChildren[n] == node) {
                return true;
            }
            --n;
        }
        return false;
    }

    protected void init() {
        this.lastDef = null;
        this.context = null;
        this.nodeWithIllegalChildNum = 0;
        this.depth = 0;
        this.andMap.clear();
        this.seqMap.clear();
        this.plusMap.clear();
        this.commentsBeforeDoctype.removeAllElements();
        if (this.getDOMImplementation() != null) {
            this.setDOMImplementation(this.getDOMImplementation());
        } else {
            Node node = this.doc.getFirstChild();
            while (node != null) {
                this.doc.removeChild(node);
                node = this.doc.getFirstChild();
            }
        }
    }

    int getCharEntity(String string) throws IOException, ParseException, SAXException {
        SGMLEntityReference sGMLEntityReference = null;
        try {
            sGMLEntityReference = this.dtd.getEntityReference(string);
        }
        catch (ParseException parseException) {
            return -1;
        }
        SGMLEntityDeclaration sGMLEntityDeclaration = sGMLEntityReference.getEntityDeclaration();
        int n = sGMLEntityDeclaration.getReplacementChar();
        if (n != -1) {
            return n;
        }
        InsTokenizer insTokenizer = new InsTokenizer(sGMLEntityDeclaration.getReplacementReader(), this);
        if (insTokenizer.nextToken() == 14 && insTokenizer.sval.length() == 1) {
            char c = insTokenizer.sval.charAt(0);
            sGMLEntityDeclaration.setReplacementChar(c);
            return c;
        }
        throw new ParseException("Internal Parser Error: " + string + " not defined.");
    }

    public void setDocument(Document document) {
        this.doc = document;
        this.domImpl = null;
    }

    private Node stag() throws IOException, ParseException, SAXException {
        ElementDefinition elementDefinition;
        this.isEmptyElement = true;
        this.isEndWithSlash = false;
        if (this.tokenizer.nextToken() != 11) {
            if (this.handleError(13, this.tokenizer.sval)) {
                return this.stag();
            }
            this.error(9, "Perhaps character encoding may not be correct.");
            while (this.tokenizer.nextToken() != 11) {
                if (this.tokenizer.ttype != -1 && this.tokenizer.ttype != 62) continue;
                return null;
            }
        }
        if ((elementDefinition = this.dtd.getElementDefinition(this.tokenizer.sval)) != null) {
            this.lastElementNumber = elementDefinition.number;
            this.lastElementDef = elementDefinition;
            this.isEmptyElement = elementDefinition.getContentModel().toString().equalsIgnoreCase("EMPTY");
        } else if (this.keepUnknowns) {
            this.lastElementNumber = this.pcdataNumber + 1;
            elementDefinition = this.lastElementDef = this.anonymousElementDef;
        }
        Element element = this.doc.createElement(this.changeTagCase(this.tokenizer.sval));
        this.currentNode = element;
        Attr attr = null;
        if (this.docHandler != null) {
            this.attrlist = this.createAttributeList();
        }
        this.isEndWithSlash = false;
        while (this.tokenizer.nextToken() != 62) {
            this.isEndWithSlash = this.tokenizer.ttype == 47;
            if (this.tokenizer.ttype == 60 || this.tokenizer.ttype == 8) {
                if (this.handleError(12, this.tokenizer.sval)) continue;
                this.error(9, "requires an attribute in " + element);
                this.tokenizer.pushBack();
                break;
            }
            if (this.tokenizer.ttype == -1) break;
            this.tokenizer.pushBack();
            attr = this.attribute(elementDefinition, this.attrlist);
            if (attr == null) continue;
            element.setAttributeNode(attr);
        }
        if (this.docHandler != null && !this.eHandleLogical) {
            this.docHandler.startElement(element.getNodeName(), this.attrlist);
        }
        if (elementDefinition == null) {
            if (!this.handleError(8, element)) {
                this.error(8, "Unknown Element: " + element.getTagName() + ".  Ignore it.");
            }
            return null;
        }
        if (elementDefinition == this.anonymousElementDef) {
            if (this.handleError(8, element)) {
                return null;
            }
            this.error(8, "Unknown Element: " + element.getTagName() + ".  Define its definition as <!ELEMENT " + element.getNodeName().toUpperCase() + " - - ANY>");
        }
        this.currentTagName = element.getNodeName();
        return element;
    }

    public String makeUnique(String string) {
        Enumeration<String> enumeration = pubEntityMap.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string.equals(string2)) continue;
            return string2;
        }
        return string;
    }

    public void setDefaultDTD(String string) {
        this.defaultDTD = this.makeUnique(string);
    }

    protected String getDefaultTopElement() throws ParseException {
        if (this.defaultTopElement != null) {
            return this.defaultTopElement;
        }
        throw new ParseException("doesn't know which element must be at the top.");
    }

    @Override
    public void setDefaultTagCase(int n) {
        if (n == 0 || n == 1) {
            this.defaultTagCase = n;
        }
    }

    @Override
    public String changeDefaultTagCase(String string) {
        switch (this.defaultTagCase) {
            case 0: {
                return string.toUpperCase();
            }
            case 1: {
                return string.toLowerCase();
            }
        }
        throw new RuntimeException("Internal Parser Error");
    }

    @Override
    public void setTagCase(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.tagCase = n;
        }
    }

    final String changeTagCase(String string) {
        switch (this.tagCase) {
            case 0: {
                return string.toUpperCase();
            }
            case 1: {
                return string.toLowerCase();
            }
            case 2: {
                return string;
            }
        }
        throw new RuntimeException("Internal Parser Error");
    }

    @Override
    public void setAttrNameCase(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.attrCase = n;
        }
    }

    final String changeAttrNameCase(String string) {
        switch (this.attrCase) {
            case 0: {
                return string.toUpperCase();
            }
            case 1: {
                return string.toLowerCase();
            }
            case 2: {
                return string;
            }
        }
        throw new RuntimeException("Internal Parser Error");
    }

    public void enforceDoctype(String string) {
        this.enforcedDoctype = this.makeUnique(string);
    }

    public void close() throws IOException {
        this.tokenizer.close();
        this.tokenizer = null;
    }

    @Override
    public Object getExtraErrInfo() {
        return this.extraErrInfo;
    }

    private boolean handleError(int n, Node node) throws ParseException, IOException, SAXException {
        int n2 = this.errorHandlerNum - 1;
        while (n2 >= 0) {
            if (this.errorHandlers[n2].handleError(n, this, node)) {
                return true;
            }
            --n2;
        }
        return false;
    }

    boolean handleError(int n, String string) throws ParseException, IOException {
        int n2 = this.tokenErrorHandlerNum - 1;
        while (n2 >= 0) {
            if (this.tokenErrorHandlers[n2].handleError(n, this, string)) {
                return true;
            }
            --n2;
        }
        return false;
    }

    void putCharNumEntity(Character c, String string) {
        Document document = this.getDocument();
        if (document instanceof SGMLDocument) {
            ((SGMLDocument)document).putCharNumEntity(c, string);
        }
    }

    public DocumentHandler getDocumentHandler() {
        return this.docHandler;
    }

    @Override
    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.docHandler = documentHandler;
    }

    @Override
    public boolean getPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    @Override
    public void setPreserveWhitespace(boolean bl) {
        if (this.tokenizer != null) {
            this.tokenizer.setPreserveWhitespace(bl);
        }
        this.preserveWhitespace = bl;
    }

    @Override
    public void elementHandle(boolean bl) {
        this.eHandleLogical = bl;
    }

    @Override
    public boolean autoGenerated(Element element) {
        return this.autoGenerated.contains(element);
    }

    @Override
    public final void addAutoGenerated(Element element) {
        this.autoGenerated.addElement(element);
    }

    @Override
    public void insert(String string) throws IOException {
        this.tokenizer.unread(string);
    }

    private AttributeListImpl createAttributeList() {
        return new AttributeListImpl();
    }

    @Override
    public void keepUnknownElements(boolean bl) {
        this.keepUnknowns = bl;
    }

    public int getCurrentLineNumber() {
        return this.tokenizer.getCurrentLine();
    }

    public int getCurrentColumnNumber() {
        return this.tokenizer.getCurrentCol();
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void setCurrentNode(Node node) {
        this.currentNode = node;
    }

    public void setKeepComment(boolean bl) {
        this.keepComment = bl;
    }

    void setCharacter(char[] cArray, int n, int n2) {
        this.saxch = cArray;
        this.begin = n;
        this.len = n2;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexHandler = lexicalHandler;
    }

    LexicalHandler getLexicalHandler() {
        return this.lexHandler;
    }

    void incrementDepth(int n) {
        this.depth += n;
    }

    @Override
    public void reopenContext(int n) throws SAXException {
        this.depth += n;
        this.context = this.ancesters[this.depth - 1];
        if (!this.eHandleLogical || this.docHandler == null) {
            return;
        }
        int n2 = this.depth;
        while (n2 < n) {
            this.docHandler.startElement(this.ancesters[n2].getNodeName(), this.nullAttributeList);
            ++n2;
        }
    }

    @Override
    public Element[] getContextElements() {
        Element[] elementArray = new Element[this.depth];
        System.arraycopy(this.ancesters, 0, elementArray, 0, this.depth);
        return elementArray;
    }

    public void parseFragment(Element element, Reader reader) throws IOException, ParseException, SAXException {
        if (this.dtd == null) {
            throw new ParseException("Can't parse without DTD");
        }
        if (this.doc == null) {
            throw new ParseException("Can't parse without a Document");
        }
        this.ancesterElementDefs[0] = this.dtd.getElementDefinition(element.getNodeName());
        if (this.ancesterElementDefs[0] == null) {
            this.ancesterElementDefs[0] = this.anonymousElementDef;
        }
        this.ancesters[0] = element;
        this.context = element;
        this.depth = 1;
        this.tokenizer = new InsTokenizer(reader, this);
        if (this.docHandler != null) {
            this.docHandler.setDocumentLocator(this.tokenizer);
        }
        this.tokenizer.extractNumEntity(this.extractNum);
        this.tokenizer.extractCharEntity(this.extractChar);
        this.tokenizer.setPreserveWhitespace(this.preserveWhitespace);
        this.readInstances2();
    }

    public DocumentFragment parseFragment(Reader reader) throws IOException, ParseException, SAXException {
        Element element = this.doc != null ? this.doc.createElement("dummy") : null;
        this.parseFragment(element, reader);
        DocumentFragment documentFragment = this.doc.createDocumentFragment();
        Node node = element.getFirstChild();
        while (node != null) {
            element.removeChild(node);
            documentFragment.appendChild(node);
            node = element.getFirstChild();
        }
        return documentFragment;
    }

    @Override
    public int getPushbackBufferSize() {
        return 256;
    }

    class CATB {
        boolean comment = true;
        String str;

        CATB() {
        }
    }
}

