/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.InheritanceType;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.PrimaryKeyJoinColumn;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaEntityModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPrimaryKeyJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularOrPluralStringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.SingularPluralTopLevelAnnotationAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class JavaInheritanceModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    private PersistentType subClassTestClassType;
    private PersistentType anotherSubClassTestClassType;
    public static String SUB_CLASS_TYPE_NAME = "SubClassTestClass";
    public static String SUB_CLASS_FILE_NAME = "SubClassTestClass.java";
    public static String ANOTHER_SUB_CLASS_TYPE_NAME = "AnotherSubClassTestClass";
    public static String ANOTHER_SUB_CLASS_FILE_NAME = "AnotherSubClassTestClass.java";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaInheritanceModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaInheritanceModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
        IType subClassType = this.project.createType(this.project.createPackage(SimpleTestProject.PACKAGE_NAME), SUB_CLASS_FILE_NAME, this.createSubclassTypeSource());
        PersistenceFile subClassPersistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)subClassType.getCompilationUnit().getResource()));
        this.subClassTestClassType = (PersistentType)subClassPersistenceFile.getPersistentTypes().get(0);
        IType anotherSubClassType = this.project.createType(this.project.createPackage(SimpleTestProject.PACKAGE_NAME), ANOTHER_SUB_CLASS_FILE_NAME, this.createAnotherSubclassTypeSource());
        PersistenceFile anotherSubClassPersistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)anotherSubClassType.getCompilationUnit().getResource()));
        this.anotherSubClassTestClassType = (PersistentType)anotherSubClassPersistenceFile.getPersistentTypes().get(0);
    }

    private String createSubclassTypeSource() {
        StringBuffer sb = new StringBuffer();
        sb.append("@Entity \n");
        sb.append("@PrimaryKeyJoinColumn() \n");
        sb.append("public class " + SUB_CLASS_TYPE_NAME + " extends " + SimpleTestProject.TYPE_NAME + "{\n");
        sb.append("    private String subClassTestField;\n");
        sb.append("    \n");
        sb.append("    public String getSubClassTestField() {\n");
        sb.append("        return this.subClassTestField;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public void setSubClassTestField(String testField) {\n");
        sb.append("        this.subClassTestField = testField;\n");
        sb.append("    }\n");
        sb.append("}");
        return sb.toString();
    }

    private String createAnotherSubclassTypeSource() {
        StringBuffer sb = new StringBuffer();
        sb.append("@Entity \n");
        sb.append("@PrimaryKeyJoinColumns(value=@PrimaryKeyJoinColumn()) \n");
        sb.append("public class " + ANOTHER_SUB_CLASS_TYPE_NAME + " extends " + SimpleTestProject.TYPE_NAME + "{\n");
        sb.append("    private String subClassTestField;\n");
        sb.append("    \n");
        sb.append("    public String getSubClassTestField() {\n");
        sb.append("        return this.subClassTestField;\n");
        sb.append("    }\n");
        sb.append("    \n");
        sb.append("    public void setSubClassTestField(String testField) {\n");
        sb.append("        this.subClassTestField = testField;\n");
        sb.append("    }\n");
        sb.append("}");
        return sb.toString();
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    private JavaEntityModelAdapter getEntityModelAdapter() {
        return (JavaEntityModelAdapter)this.testClassType.getTypeMapping().getModelAdapter();
    }

    private JavaEntityModelAdapter getSubClassEntityModelAdapter() {
        return (JavaEntityModelAdapter)this.subClassTestClassType.getTypeMapping().getModelAdapter();
    }

    private JavaInheritanceModelAdapter getInheritanceModelAdapter() {
        return (JavaInheritanceModelAdapter)this.getInheritance().getModelAdapter();
    }

    private JavaInheritanceModelAdapter getSubClassInheritanceModelAdapter() {
        return (JavaInheritanceModelAdapter)this.getSubClassInheritance().getModelAdapter();
    }

    private Inheritance getInheritance() {
        return ((Entity)this.testClassType.getTypeMapping()).getInheritance();
    }

    private Inheritance getSubClassInheritance() {
        return ((Entity)this.subClassTestClassType.getTypeMapping()).getInheritance();
    }

    private Inheritance getAnotherSubClassInheritance() {
        return ((Entity)this.anotherSubClassTestClassType.getTypeMapping()).getInheritance();
    }

    public void testSetInheritanceStrategyInJavaUpdatesPersistenceModel() {
        EnumAnnotationElementAdapter adapter = (EnumAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getInheritanceModelAdapter(), (String)"strategyAdapter");
        JavaInheritanceModelAdapterTests.assertEquals((Object)InheritanceType.DEFAULT_LITERAL, (Object)this.getInheritance().getStrategy());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz, (Object)"JOINED");
        JavaInheritanceModelAdapterTests.assertEquals((Object)InheritanceType.JOINED_LITERAL, (Object)this.getInheritance().getStrategy());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz2, (Object)"SINGLE_TABLE");
        JavaInheritanceModelAdapterTests.assertEquals((Object)InheritanceType.SINGLE_TABLE_LITERAL, (Object)this.getInheritance().getStrategy());
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz3, (Object)"TABLE_PER_CLASS");
        JavaInheritanceModelAdapterTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS_LITERAL, (Object)this.getInheritance().getStrategy());
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassTools.invokeMethod((Object)adapter, (String)"setJavaValue", (Class)clazz4, (Object)"Default");
        JavaInheritanceModelAdapterTests.assertEquals((Object)InheritanceType.DEFAULT_LITERAL, (Object)this.getInheritance().getStrategy());
    }

    public void testSetInheritanceStrategyInPersistenceModelUpdatesJava() {
        Inheritance inheritance = this.getInheritance();
        EnumAnnotationElementAdapter adapter = (EnumAnnotationElementAdapter)ClassTools.getFieldValue((Object)this.getInheritanceModelAdapter(), (String)"strategyAdapter");
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        inheritance.setStrategy(InheritanceType.JOINED_LITERAL);
        CompilationUnit astRoot = type.createASTRoot();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz, (Object)astRoot);
        JavaInheritanceModelAdapterTests.assertEquals((String)"JOINED", (String)javaValue);
        inheritance.setStrategy(InheritanceType.SINGLE_TABLE_LITERAL);
        astRoot = type.createASTRoot();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz2, (Object)astRoot);
        JavaInheritanceModelAdapterTests.assertEquals((String)"SINGLE_TABLE", (String)javaValue);
        inheritance.setStrategy(InheritanceType.TABLE_PER_CLASS_LITERAL);
        astRoot = type.createASTRoot();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz3, (Object)astRoot);
        JavaInheritanceModelAdapterTests.assertEquals((String)"TABLE_PER_CLASS", (String)javaValue);
        inheritance.setStrategy(InheritanceType.DEFAULT_LITERAL);
        astRoot = type.createASTRoot();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        javaValue = (String)ClassTools.invokeMethod((Object)adapter, (String)"javaValue", (Class)clazz4, (Object)astRoot);
        JavaInheritanceModelAdapterTests.assertEquals((String)"Default", (String)javaValue);
    }

    public void testSetPrimaryKeyJoinColumnsInJavaUpdatesPersistenceModel() {
        Inheritance inheritance = this.getInheritance();
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        JavaInheritanceModelAdapterTests.assertTrue((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation pkJoinColumnAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumn");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)pkJoinColumnAnnotation);
            }
        });
        JavaInheritanceModelAdapterTests.assertFalse((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotation((BodyDeclaration)bodyDeclaration, (String)"PrimaryKeyJoinColumn");
            }
        });
        JavaInheritanceModelAdapterTests.assertTrue((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation pkJoinColumnsAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumns");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)pkJoinColumnsAnnotation);
                MemberValuePair valuePair = bodyDeclaration.getAST().newMemberValuePair();
                valuePair.setName(bodyDeclaration.getAST().newSimpleName("value"));
                ArrayInitializer arrayInitializer = bodyDeclaration.getAST().newArrayInitializer();
                NormalAnnotation pkJoinColumnAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumn");
                ASTTools.addExpressionToArrayInitializer((ArrayInitializer)arrayInitializer, (Expression)pkJoinColumnAnnotation);
                valuePair.setValue((Expression)arrayInitializer);
                ASTTools.addValuePair((NormalAnnotation)pkJoinColumnsAnnotation, (MemberValuePair)valuePair);
            }
        });
        JavaInheritanceModelAdapterTests.assertFalse((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
    }

    public void testSetPrimaryKeyJoinColumnsInJavaUpdatesPersistenceModel2() {
        Inheritance inheritance = this.getInheritance();
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        JavaInheritanceModelAdapterTests.assertTrue((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation pkJoinColumnsAnnotation = ASTTools.newSingleMemberAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumns");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)pkJoinColumnsAnnotation);
                ArrayInitializer arrayInitializer = bodyDeclaration.getAST().newArrayInitializer();
                NormalAnnotation pkJoinColumnAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumn");
                ASTTools.addExpressionToArrayInitializer((ArrayInitializer)arrayInitializer, (Expression)pkJoinColumnAnnotation);
                pkJoinColumnsAnnotation.setValue((Expression)arrayInitializer);
            }
        });
        JavaInheritanceModelAdapterTests.assertFalse((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                SingleMemberAnnotation pkJoinColumnsAnnotation = (SingleMemberAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"PrimaryKeyJoinColumns");
                ArrayInitializer arrayInitializer = (ArrayInitializer)pkJoinColumnsAnnotation.getValue();
                NormalAnnotation pkJoinColumnAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumn");
                ASTTools.addExpressionToArrayInitializer((ArrayInitializer)arrayInitializer, (Expression)pkJoinColumnAnnotation);
            }
        });
        JavaInheritanceModelAdapterTests.assertEquals((int)2, (int)inheritance.getPrimaryKeyJoinColumns().size());
    }

    public void testSetPrimaryKeyJoinColumnsInJavaUpdatesPersistenceModel3() {
        Inheritance inheritance = this.getSubClassInheritance();
        JavaInheritanceModelAdapterTests.assertFalse((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
    }

    public void testSetPrimaryKeyJoinColumnsInJavaUpdatesPersistenceModel5() {
        Inheritance inheritance = this.getAnotherSubClassInheritance();
        JavaInheritanceModelAdapterTests.assertFalse((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
    }

    public void testSetPrimaryKeyJoinColumnsInJavaUpdatesPersistenceModel4() {
        Inheritance inheritance = this.getInheritance();
        Type type = (Type)ClassTools.getFieldValue((Object)this.getEntityModelAdapter(), (String)"type");
        JavaInheritanceModelAdapterTests.assertTrue((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
        type.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation pkJoinColumnsAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumns");
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)pkJoinColumnsAnnotation);
                MemberValuePair valuePair = bodyDeclaration.getAST().newMemberValuePair();
                valuePair.setName(bodyDeclaration.getAST().newSimpleName("value"));
                NormalAnnotation pkJoinColumnAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"PrimaryKeyJoinColumn");
                valuePair.setValue((Expression)pkJoinColumnAnnotation);
                ASTTools.addValuePair((NormalAnnotation)pkJoinColumnsAnnotation, (MemberValuePair)valuePair);
            }
        });
        JavaInheritanceModelAdapterTests.assertFalse((boolean)inheritance.isDefaultPrimaryKeyJoinColumns());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
    }

    public void testSetPrimaryKeyJoinColumnsInPersistenceModelUpdatesJava() {
        Inheritance inheritance = this.getSubClassInheritance();
        Type type = (Type)ClassTools.getFieldValue((Object)this.getSubClassEntityModelAdapter(), (String)"type");
        PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)inheritance.getPrimaryKeyJoinColumns().get(0);
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getDefaultName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getReferencedColumnName());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
        inheritance.setDefaultPrimaryKeyJoinColumns(true);
        joinColumn = (PrimaryKeyJoinColumn)inheritance.getPrimaryKeyJoinColumns().get(0);
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
        JavaInheritanceModelAdapterTests.assertEquals(null, (String)joinColumn.getSpecifiedName());
        JavaInheritanceModelAdapterTests.assertEquals(null, (String)joinColumn.getSpecifiedReferencedColumnName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getReferencedColumnName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getDefaultName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        inheritance.setDefaultPrimaryKeyJoinColumns(false);
        joinColumn = (PrimaryKeyJoinColumn)inheritance.getPrimaryKeyJoinColumns().get(0);
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getSpecifiedName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getSpecifiedReferencedColumnName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getName());
        JavaInheritanceModelAdapterTests.assertEquals((String)"id", (String)joinColumn.getReferencedColumnName());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)inheritance.getPrimaryKeyJoinColumns().size());
        SingularPluralTopLevelAnnotationAdapter joinColumnsModelAdapter = (SingularPluralTopLevelAnnotationAdapter)ClassTools.getFieldValue((Object)this.getSubClassInheritanceModelAdapter(), (String)"primaryKeyJoinColumnsAdapter");
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int size = (Integer)ClassTools.invokeMethod((Object)joinColumnsModelAdapter, (String)"javaElementsSize", (Class)clazz, (Object)type.createASTRoot());
        JavaInheritanceModelAdapterTests.assertEquals((int)1, (int)size);
        joinColumn.setSpecifiedName("newSpecifiedName");
        joinColumn.setSpecifiedReferencedColumnName("newSpecifiedReferencedColumnName");
        JavaPrimaryKeyJoinColumnModelAdapter primaryKeyJoinColumnModelAdapter = (JavaPrimaryKeyJoinColumnModelAdapter)joinColumn.getModelAdapter();
        SingularOrPluralStringAnnotationElementAdapter specifiedNameAdapter = (SingularOrPluralStringAnnotationElementAdapter)ClassTools.getFieldValue((Object)primaryKeyJoinColumnModelAdapter, (String)"specifiedNameAdapter");
        SingularOrPluralStringAnnotationElementAdapter specifiedReferencedColumnNameAdapter = (SingularOrPluralStringAnnotationElementAdapter)ClassTools.getFieldValue((Object)primaryKeyJoinColumnModelAdapter, (String)"specifiedReferencedColumnNameAdapter");
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String name = (String)ClassTools.invokeMethod((Object)specifiedNameAdapter, (String)"javaValue", (Class)clazz2, (Object)type.createASTRoot());
        JavaInheritanceModelAdapterTests.assertEquals((String)"newSpecifiedName", (String)name);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String referencedColumnName = (String)ClassTools.invokeMethod((Object)specifiedReferencedColumnNameAdapter, (String)"javaValue", (Class)clazz3, (Object)type.createASTRoot());
        JavaInheritanceModelAdapterTests.assertEquals((String)"newSpecifiedReferencedColumnName", (String)referencedColumnName);
    }
}

