/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { isDocument, isScalar, visit } from 'yaml';
export function getParent(doc, nodeToFind) {
    let parentNode;
    visit(doc, (_, node, path) => {
        if (node === nodeToFind) {
            parentNode = path[path.length - 1];
            return visit.BREAK;
        }
    });
    if (isDocument(parentNode)) {
        return undefined;
    }
    return parentNode;
}
export function isMapContainsEmptyPair(map) {
    if (map.items.length > 1) {
        return false;
    }
    const pair = map.items[0];
    if (isScalar(pair.key) && isScalar(pair.value) && pair.key.value === '' && !pair.value.value) {
        return true;
    }
    return false;
}
export function indexOf(seq, item) {
    for (const [i, obj] of seq.items.entries()) {
        if (item === obj) {
            return i;
        }
    }
    return undefined;
}
//# sourceMappingURL=astUtils.js.map